/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.math.Statistics;
import org.geotoolkit.resources.Errors;

@ThreadSafe
public class MosaicProfiler {
    private static final int DEFAULT_MIN = 512;
    private static final int DEFAULT_MAX = 1024;
    public final TileManager mosaic;
    private Rectangle region;
    private final Dimension minSize;
    private final Dimension maxSize;
    private final Dimension minSubsampling;
    private final Dimension maxSubsampling;
    private boolean subsamplingChangeAllowed;
    private final Random random = new Random();

    public MosaicProfiler(TileManager tileManager) throws IOException {
        this.mosaic = tileManager;
        this.region = tileManager.getRegion();
        this.maxSize = new Dimension(Math.min(1024, this.region.width), Math.min(1024, this.region.height));
        this.minSize = new Dimension(Math.min(512, this.maxSize.width), Math.min(512, this.maxSize.height));
        this.maxSubsampling = new Dimension(this.region.width / this.minSize.width, this.region.height / this.minSize.height);
        this.minSubsampling = new Dimension(1, 1);
    }

    public synchronized void setSeed(long l) {
        this.random.setSeed(l);
    }

    private static void setSize(Dimension dimension, Dimension dimension2) throws IllegalArgumentException {
        int n = dimension.width;
        ArgumentChecks.ensureStrictlyPositive((String)"width", (int)n);
        int n2 = dimension.height;
        ArgumentChecks.ensureStrictlyPositive((String)"height", (int)n2);
        dimension2.setSize(n, n2);
    }

    private static void adjust(Dimension dimension, Dimension dimension2, boolean bl) {
        if (dimension.width > dimension2.width) {
            if (bl) {
                dimension2.width = dimension.width;
            } else {
                dimension.width = dimension2.width;
            }
        }
        if (dimension.height > dimension2.height) {
            if (bl) {
                dimension2.height = dimension.height;
            } else {
                dimension.height = dimension2.height;
            }
        }
    }

    public synchronized Rectangle getQueryRegion() {
        return (Rectangle)this.region.clone();
    }

    public synchronized void setQueryRegion(Rectangle rectangle) throws IOException {
        Rectangle rectangle2 = this.region;
        this.region = this.mosaic.getRegion().intersection(rectangle);
        if (this.region.isEmpty()) {
            this.region = rectangle2;
            throw new IllegalArgumentException(Errors.format((int)15, (Object)rectangle));
        }
    }

    public synchronized Dimension getMosaicSize() throws IOException {
        return this.mosaic.getRegion().getSize();
    }

    public synchronized Dimension getMinSize() {
        return (Dimension)this.minSize.clone();
    }

    public synchronized void setMinSize(Dimension dimension) {
        MosaicProfiler.setSize(dimension, this.minSize);
        MosaicProfiler.adjust(this.minSize, this.maxSize, true);
    }

    public synchronized void setMinSize(int n) {
        ArgumentChecks.ensureStrictlyPositive((String)"size", (int)n);
        this.minSize.setSize(n, n);
        MosaicProfiler.adjust(this.minSize, this.maxSize, true);
    }

    public synchronized Dimension getMaxSize() {
        return (Dimension)this.maxSize.clone();
    }

    public synchronized void setMaxSize(Dimension dimension) {
        MosaicProfiler.setSize(dimension, this.maxSize);
        MosaicProfiler.adjust(this.minSize, this.maxSize, false);
    }

    public synchronized void setMaxSize(int n) {
        ArgumentChecks.ensureStrictlyPositive((String)"size", (int)n);
        this.maxSize.setSize(n, n);
        MosaicProfiler.adjust(this.minSize, this.maxSize, false);
    }

    public synchronized Dimension getMinSubsampling() {
        return (Dimension)this.minSubsampling.clone();
    }

    public synchronized void setMinSubsampling(Dimension dimension) {
        MosaicProfiler.setSize(dimension, this.minSubsampling);
        MosaicProfiler.adjust(this.minSubsampling, this.maxSubsampling, true);
    }

    public synchronized void setMinSubsampling(int n) {
        ArgumentChecks.ensureStrictlyPositive((String)"subsampling", (int)n);
        this.minSubsampling.setSize(n, n);
        MosaicProfiler.adjust(this.minSubsampling, this.maxSubsampling, true);
    }

    public synchronized Dimension getMaxSubsampling() {
        return (Dimension)this.maxSubsampling.clone();
    }

    public synchronized void setMaxSubsampling(Dimension dimension) {
        MosaicProfiler.setSize(dimension, this.maxSubsampling);
        MosaicProfiler.adjust(this.minSubsampling, this.maxSubsampling, false);
    }

    public synchronized void setMaxSubsampling(int n) {
        ArgumentChecks.ensureStrictlyPositive((String)"subsampling", (int)n);
        this.maxSubsampling.setSize(n, n);
        MosaicProfiler.adjust(this.minSubsampling, this.maxSubsampling, false);
    }

    public synchronized boolean isSubsamplingChangeAllowed() {
        return this.subsamplingChangeAllowed;
    }

    public synchronized void setSubsamplingChangeAllowed(boolean bl) {
        this.subsamplingChangeAllowed = bl;
    }

    public synchronized Statistics estimateEfficiency(int n) throws IOException {
        int n2 = this.maxSubsampling.width - this.minSubsampling.width + 1;
        int n3 = this.maxSubsampling.height - this.minSubsampling.height + 1;
        int n4 = this.maxSize.width - this.minSize.width + 1;
        int n5 = this.maxSize.height - this.minSize.height + 1;
        Rectangle rectangle = this.region;
        Rectangle rectangle2 = new Rectangle();
        Dimension dimension = new Dimension();
        Statistics statistics = new Statistics();
        while (--n >= 0) {
            int n6 = this.minSubsampling.width + this.random.nextInt(n2);
            int n7 = this.minSubsampling.height + this.random.nextInt(n3);
            int n8 = Math.min((this.minSize.width + this.random.nextInt(n4)) * n6, rectangle.width);
            int n9 = Math.min((this.minSize.height + this.random.nextInt(n5)) * n7, rectangle.height);
            int n10 = rectangle.x + this.random.nextInt(rectangle.width - n8 + 1);
            int n11 = rectangle.y + this.random.nextInt(rectangle.height - n9 + 1);
            rectangle2.setBounds(n10, n11, n8, n9);
            assert (rectangle.contains(rectangle2)) : rectangle2;
            dimension.setSize(n6, n7);
            long l = 0L;
            for (Tile tile : this.mosaic.getTiles(rectangle2, dimension, this.subsamplingChangeAllowed)) {
                l += (long)tile.countUnwantedPixelsFromAbsolute(rectangle2, dimension);
            }
            long l2 = (long)n8 * (long)n9 / (long)(dimension.width * dimension.height);
            statistics.accept(1.0 / ((double)l / (double)l2 + 1.0));
        }
        return statistics;
    }
}

