/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.image.io.metadata.ReferencingBuilder;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.mosaic.ImageTypePolicy;
import org.geotoolkit.image.io.mosaic.MosaicController;
import org.geotoolkit.image.io.mosaic.MosaicImageReadParam;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.image.io.mosaic.TileManagerFactory;
import org.geotoolkit.image.io.mosaic.TileReaderPool;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.image.io.GridDomainAccessor;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.wkt.PrjFiles;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.LogProducer;
import org.geotoolkit.util.logging.Logging;
import org.geotoolkit.util.logging.PerformanceLevel;
import org.opengis.metadata.spatial.PixelOrientation;

public class MosaicImageReader
extends ImageReader
implements LogProducer,
Closeable,
Disposable {
    private static final Class<?>[] INTEGER_ARGUMENTS = new Class[]{Integer.TYPE};
    final TileReaderPool readers = new TileReaderPool();
    private transient ImageReader reading;
    private transient IIOMetadata[] metadata;
    private transient ImageTypeSpecifier cachedImageType;
    private Level logLevel;

    public MosaicImageReader() {
        this(null);
    }

    public MosaicImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi != null ? imageReaderSpi : Spi.DEFAULT);
    }

    private boolean isLoggable() {
        Level level = this.logLevel;
        if (level == null) {
            level = PerformanceLevel.SLOWEST;
        }
        return Tile.LOGGER.isLoggable(level);
    }

    public Level getLogLevel() {
        Level level = this.logLevel;
        return level != null ? level : PerformanceLevel.PERFORMANCE;
    }

    public void setLogLevel(Level level) {
        this.logLevel = level;
    }

    private TileManager getTileManager(int n) throws IOException {
        if (this.input instanceof TileManager[]) {
            TileManager[] tileManagerArray = (TileManager[])this.input;
            ArgumentChecks.ensureValidIndex((int)tileManagerArray.length, (int)n);
            return tileManagerArray[n];
        }
        throw new IllegalStateException(Errors.format((int)156));
    }

    public TileManager[] getInput() {
        TileManager[] tileManagerArray = (TileManager[])super.getInput();
        return tileManagerArray != null ? (TileManager[])tileManagerArray.clone() : null;
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) throws IllegalArgumentException {
        TileManager[] tileManagerArray;
        this.cachedImageType = null;
        this.metadata = null;
        try {
            tileManagerArray = TileManagerFactory.DEFAULT.createFromObject(object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getLocalizedMessage(), iOException);
        }
        int n = tileManagerArray != null ? tileManagerArray.length : 0;
        super.setInput(tileManagerArray, bl, bl2);
        this.availableLocales = null;
        Set<ImageReaderSpi> set = Collections.emptySet();
        try {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    set = tileManagerArray[0].getImageReaderSpis();
                    break;
                }
                default: {
                    set = new HashSet<ImageReaderSpi>(tileManagerArray[0].getImageReaderSpis());
                    for (int i = 1; i < n; ++i) {
                        set.addAll(tileManagerArray[i].getImageReaderSpis());
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Logging.unexpectedException((Logger)Tile.LOGGER, MosaicImageReader.class, (String)"setInput", (Throwable)iOException);
        }
        this.readers.setProviders(set);
    }

    public Set<ImageReaderSpi> getTileReaderSpis() {
        return this.readers.providers;
    }

    ImageReader getTileReader(Tile tile) throws IOException {
        return tile.getImageReader(this, true, true);
    }

    private Tile getSpecificTile(Collection<Tile> collection) {
        Tile tile = null;
        Set<ImageReader> set = this.readers.getTileReaders();
        for (Class clazz = Classes.findSpecializedClass(set); clazz != null && ImageReader.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
            for (ImageReader imageReader : set) {
                if (!clazz.equals(imageReader.getClass())) continue;
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                for (Tile tile2 : collection) {
                    ImageReaderSpi imageReaderSpi2 = tile2.getImageReaderSpi();
                    if (imageReaderSpi2.equals(imageReaderSpi)) {
                        return tile2;
                    }
                    if (tile != null || !imageReaderSpi2.isOwnReader(imageReader)) continue;
                    tile = tile2;
                }
            }
        }
        return tile;
    }

    @Override
    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            LinkedHashSet<Locale> linkedHashSet = new LinkedHashSet<Locale>();
            for (ImageReader imageReader : this.readers.getTileReaders()) {
                Locale[] localeArray = imageReader.getAvailableLocales();
                if (localeArray == null) continue;
                for (Locale locale : localeArray) {
                    linkedHashSet.add(locale);
                }
            }
            if (linkedHashSet.isEmpty()) {
                return null;
            }
            this.availableLocales = linkedHashSet.toArray(new Locale[linkedHashSet.size()]);
        }
        return (Locale[])this.availableLocales.clone();
    }

    @Override
    public void setLocale(Locale locale) throws IllegalArgumentException {
        super.setLocale(locale);
        this.readers.setLocale(locale);
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return this.input instanceof TileManager[] ? ((TileManager[])this.input).length : 0;
    }

    @Override
    public boolean isImageTiled(int n) throws IOException {
        return this.getTileManager(n).isImageTiled();
    }

    @Override
    public int getWidth(int n) throws IOException {
        return this.getTileManager((int)n).getRegion().width;
    }

    @Override
    public int getHeight(int n) throws IOException {
        return this.getTileManager((int)n).getRegion().height;
    }

    @Override
    public int getTileWidth(int n) throws IOException {
        return this.getTileManager((int)n).getTileSize().width;
    }

    @Override
    public int getTileHeight(int n) throws IOException {
        return this.getTileManager((int)n).getTileSize().height;
    }

    private boolean useDefaultImplementation(String string, Class<?>[] classArray) {
        for (ImageReader imageReader : this.readers.getTileReaders()) {
            Class<?> clazz = imageReader.getClass();
            try {
                clazz = clazz.getMethod(string, classArray).getDeclaringClass();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logging.unexpectedException((Logger)Tile.LOGGER, MosaicImageReader.class, (String)"useDefaultImplementation", (Throwable)noSuchMethodException);
                return false;
            }
            if (clazz.equals(ImageReader.class)) continue;
            return false;
        }
        return true;
    }

    private static boolean canDelegate(Collection<Tile> collection, Rectangle rectangle) throws IOException {
        Iterator<Tile> iterator = collection.iterator();
        if (iterator.hasNext()) {
            Tile tile = iterator.next();
            if (!iterator.hasNext()) {
                return tile.getRegion().contains(rectangle);
            }
        }
        return false;
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        if (this.useDefaultImplementation("isRandomAccessEasy", INTEGER_ARGUMENTS)) {
            return super.isRandomAccessEasy(n);
        }
        for (Tile tile : this.getTileManager(n).getTiles()) {
            Object object = tile.getInput();
            if (!(object instanceof File)) {
                return false;
            }
            ImageReader imageReader = this.getTileReader(tile);
            if (imageReader.isRandomAccessEasy(tile.getImageIndex())) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getAspectRatio(int n) throws IOException {
        if (!this.useDefaultImplementation("getAspectRatio", INTEGER_ARGUMENTS)) {
            float f = Float.NaN;
            for (Tile tile : this.getTileManager(n).getTiles()) {
                ImageReader imageReader = tile.getImageReader(this, true, this.ignoreMetadata);
                float f2 = imageReader.getAspectRatio(tile.getImageIndex());
                if (f2 == f || Float.isNaN(f2)) continue;
                if (!Float.isNaN(f)) {
                    return super.getAspectRatio(n);
                }
                f = f2;
            }
            if (!Float.isNaN(f)) {
                return f;
            }
        }
        return super.getAspectRatio(n);
    }

    private ImageTypePolicy getImageTypePolicy(ImageReadParam imageReadParam) {
        ImageTypePolicy imageTypePolicy;
        if (imageReadParam instanceof MosaicImageReadParam && (imageTypePolicy = ((MosaicImageReadParam)imageReadParam).getImageTypePolicy()) != null) {
            return imageTypePolicy;
        }
        return this.getDefaultImageTypePolicy();
    }

    public ImageTypePolicy getDefaultImageTypePolicy() {
        switch (this.readers.providers.size()) {
            default: {
                return ImageTypePolicy.SUPPORTED_BY_ALL;
            }
            case 1: {
                return ImageTypePolicy.SUPPORTED_BY_FIRST;
            }
            case 0: 
        }
        return ImageTypePolicy.ALWAYS_ARGB;
    }

    private static ImageTypeSpecifier getPredefinedImageType(ImageTypePolicy imageTypePolicy) {
        int n;
        switch (imageTypePolicy) {
            case ALWAYS_ARGB: {
                n = 2;
                break;
            }
            case ALWAYS_RGB: {
                n = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(imageTypePolicy.toString());
            }
        }
        return ImageTypeSpecifier.createFromBufferedImageType(n);
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(null, this.getDefaultImageTypePolicy(), n);
        if (imageTypeSpecifier == null) {
            imageTypeSpecifier = super.getRawImageType(n);
        }
        return imageTypeSpecifier;
    }

    private ImageTypeSpecifier getRawImageType(Collection<Tile> collection, ImageTypePolicy imageTypePolicy, int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = null;
        switch (imageTypePolicy) {
            default: {
                imageTypeSpecifier = MosaicImageReader.getPredefinedImageType(imageTypePolicy);
                break;
            }
            case SUPPORTED_BY_FIRST: {
                if (this.cachedImageType != null) {
                    return this.cachedImageType;
                }
            }
            case SUPPORTED_BY_ONE: {
                Tile tile;
                if (collection == null) {
                    collection = this.getTileManager(n).getTiles();
                }
                if ((tile = this.getSpecificTile(collection)) == null) break;
                imageTypeSpecifier = this.getTileReader(tile).getRawImageType(tile.getImageIndex());
                assert (imageTypeSpecifier == null || imageTypeSpecifier.equals(this.getRawImageType(collection))) : MosaicImageReader.incompatibleImageType(tile);
                break;
            }
            case SUPPORTED_BY_ALL: {
                if (collection == null) {
                    collection = this.getTileManager(n).getTiles();
                }
                imageTypeSpecifier = this.getRawImageType(collection);
            }
        }
        if (imageTypePolicy == ImageTypePolicy.SUPPORTED_BY_FIRST) {
            this.cachedImageType = imageTypeSpecifier;
        }
        return imageTypeSpecifier;
    }

    private ImageTypeSpecifier getRawImageType(Collection<Tile> collection) throws IOException {
        FrequencySortedSet frequencySortedSet = new FrequencySortedSet(true);
        Set<ImageTypeSpecifier> set = this.getImageTypes(collection, (Collection<ImageTypeSpecifier>)frequencySortedSet);
        frequencySortedSet.retainAll(set);
        boolean bl = true;
        do {
            for (ImageTypeSpecifier imageTypeSpecifier : frequencySortedSet) {
                if (bl && !MosaicImageReader.isTransparent(imageTypeSpecifier)) continue;
                return imageTypeSpecifier;
            }
            for (ImageTypeSpecifier imageTypeSpecifier : set) {
                if (bl && !MosaicImageReader.isTransparent(imageTypeSpecifier)) continue;
                return imageTypeSpecifier;
            }
        } while (!(bl = !bl));
        return null;
    }

    private Set<ImageTypeSpecifier> getImageTypes(Collection<Tile> collection, Collection<ImageTypeSpecifier> collection2) throws IOException {
        int n = 0;
        LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>();
        for (Tile tile : collection) {
            Object object;
            ImageReader imageReader = this.getTileReader(tile);
            int n2 = tile.getImageIndex();
            if (collection2 != null) {
                collection2.add(imageReader.getRawImageType(n2));
            }
            Iterator<ImageTypeSpecifier> iterator = imageReader.getImageTypes(n2);
            while (iterator.hasNext()) {
                Integer n3;
                object = iterator.next();
                if (object == null || (n3 = linkedHashMap.put(object, n)) != null || n == 0) continue;
                linkedHashMap.remove(object);
            }
            object = linkedHashMap.values().iterator();
            while (object.hasNext()) {
                if ((Integer)object.next() == n) continue;
                object.remove();
            }
            ++n;
        }
        if (collection2 != null && collection2.remove(null)) {
            MosaicImageReader.log("getRawImageType", new LogRecord(Level.WARNING, "Tile.getImageReader().getRawImageType() == null"));
        }
        return linkedHashMap.keySet();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        Iterator<ImageTypeSpecifier> iterator;
        ImageTypePolicy imageTypePolicy = this.getDefaultImageTypePolicy();
        switch (imageTypePolicy) {
            default: {
                iterator = Collections.singleton(MosaicImageReader.getPredefinedImageType(imageTypePolicy)).iterator();
                break;
            }
            case SUPPORTED_BY_FIRST: 
            case SUPPORTED_BY_ONE: {
                Collection<Tile> collection = this.getTileManager(n).getTiles();
                Tile tile = this.getSpecificTile(collection);
                if (tile == null) {
                    Set set = Collections.emptySet();
                    return set.iterator();
                }
                iterator = this.getTileReader(tile).getImageTypes(tile.getImageIndex());
                assert ((iterator = MosaicImageReader.containsAll(this.getImageTypes(collection, null), iterator)) != null) : MosaicImageReader.incompatibleImageType(tile);
                break;
            }
            case SUPPORTED_BY_ALL: {
                Collection<Tile> collection = this.getTileManager(n).getTiles();
                iterator = this.getImageTypes(collection, null).iterator();
                break;
            }
        }
        return iterator;
    }

    private static Iterator<ImageTypeSpecifier> containsAll(Collection<ImageTypeSpecifier> collection, Iterator<ImageTypeSpecifier> iterator) {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(collection.size());
        while (iterator.hasNext()) {
            ImageTypeSpecifier imageTypeSpecifier = iterator.next();
            if (imageTypeSpecifier == null) continue;
            arrayList.add(imageTypeSpecifier);
        }
        return collection.containsAll(arrayList) ? arrayList.iterator() : null;
    }

    private static boolean isTransparent(ImageTypeSpecifier imageTypeSpecifier) {
        return imageTypeSpecifier.getColorModel().getTransparency() != 1;
    }

    private static String incompatibleImageType(Tile tile) {
        return "Image type computed by " + (Object)((Object)ImageTypePolicy.SUPPORTED_BY_ONE) + " policy using " + tile + " is incompatible with type computed by " + (Object)((Object)ImageTypePolicy.SUPPORTED_BY_ALL) + " policy.";
    }

    @Override
    public MosaicImageReadParam getDefaultReadParam() {
        return new MosaicImageReadParam(this);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        TileManager tileManager;
        ImageGeometry imageGeometry;
        IIOMetadata iIOMetadata = null;
        if (this.metadata != null) {
            iIOMetadata = this.metadata[n];
        }
        if (iIOMetadata == null && (imageGeometry = (tileManager = this.getTileManager(n)).getGridGeometry()) != null) {
            SpatialMetadata spatialMetadata = new SpatialMetadata(false, (ImageReader)this, null);
            GridDomainAccessor gridDomainAccessor = new GridDomainAccessor(spatialMetadata);
            gridDomainAccessor.setAll((AffineTransform)imageGeometry.getGridToCRS(), (Rectangle)imageGeometry.getExtent(), null, PixelOrientation.UPPER_LEFT);
            File file = tileManager.getSourceFile();
            if (file != null) {
                String string = file.getName();
                int n2 = string.lastIndexOf(46);
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                string = string + ".prj";
                if ((file = new File(file.getParent(), string)).isFile()) {
                    ReferencingBuilder referencingBuilder = new ReferencingBuilder(spatialMetadata);
                    referencingBuilder.setCoordinateReferenceSystem(PrjFiles.read((File)file));
                }
            }
            if (this.metadata == null) {
                this.metadata = new SpatialMetadata[this.getNumImages(true)];
            }
            this.metadata[n] = spatialMetadata;
            iIOMetadata = spatialMetadata;
        }
        return iIOMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BufferedImage read(int var1_1, ImageReadParam var2_2) throws IOException {
        this.clearAbortRequest();
        this.processImageStarted(var1_1);
        var3_3 = new Dimension(1, 1);
        var4_4 = false;
        var5_5 = null;
        var6_6 = false;
        if (var2_2 != null) {
            var3_3.width = var2_2.getSourceXSubsampling();
            var3_3.height = var2_2.getSourceYSubsampling();
            if (var2_2 instanceof MosaicImageReadParam) {
                var5_5 = (MosaicImageReadParam)var2_2;
                var4_4 = var5_5.isSubsamplingChangeAllowed();
                var6_6 = var5_5.getNullForEmptyImage();
            }
        }
        var7_7 = this.getWidth(var1_1);
        var8_8 = this.getHeight(var1_1);
        var9_9 = MosaicImageReader.getSourceRegion(var2_2, var7_7, var8_8);
        var10_10 = this.getTileManager(var1_1);
        var11_11 = var10_10.getTiles(var9_9, var3_3, var4_4);
        if (var6_6 && var11_11.isEmpty()) {
            this.processImageComplete();
            return null;
        }
        var12_12 = var3_3.width;
        var13_13 = var3_3.height;
        if (var4_4) {
            if (var2_2.getSourceXSubsampling() != var12_12 || var2_2.getSourceYSubsampling() != var13_13) {
                var14_14 = var2_2.getSubsamplingXOffset() % var12_12;
                var15_16 = var2_2.getSubsamplingYOffset() % var13_13;
                var2_2.setSourceSubsampling(var12_12, var13_13, var14_14, var15_16);
            } else {
                var4_4 = false;
            }
        }
        var14_15 = null;
        var17_18 = null;
        if (!MosaicImageReader.canDelegate(var11_11, var9_9)) ** GOTO lbl-1000
        var17_18 = this.getImageTypePolicy(var2_2);
        if (var17_18.canDelegate) {
            var15_17 = null;
            if (var4_4) {
                var9_9.setBounds(MosaicImageReader.getSourceRegion(var2_2, var7_7, var8_8));
            }
            var16_19 = var2_2 != null ? var2_2.getDestinationOffset() : new Point();
        } else lbl-1000:
        // 2 sources

        {
            if (var2_2 != null) {
                var14_15 = var2_2.getDestination();
            }
            var15_17 = new Rectangle();
            MosaicImageReader.computeRegions(var2_2, var7_7, var8_8, var14_15, var9_9, var15_17);
            if (var14_15 == null) {
                var18_20 = null;
                if (var2_2 != null) {
                    var18_20 = var2_2.getDestinationType();
                }
                if (var18_20 == null) {
                    if (var17_18 == null) {
                        var17_18 = this.getImageTypePolicy(var2_2);
                    }
                    if ((var18_20 = this.getRawImageType(var11_11, var17_18, var1_1)) == null) {
                        var18_20 = this.getRawImageType(var1_1);
                    }
                }
                var19_21 = var15_17.x + var15_17.width;
                var20_24 = var15_17.y + var15_17.height;
                var14_15 = var18_20.createBufferedImage(var19_21, var20_24);
                MosaicImageReader.computeRegions(var2_2, var7_7, var8_8, var14_15, var9_9, var15_17);
            }
            var16_19 = var15_17.getLocation();
        }
        var18_20 = null;
        if (var5_5 == null) {
            var5_5 = new MosaicImageReadParam();
        } else if (var5_5.hasController() && (var19_22 = var5_5.getController()) instanceof MosaicController) {
            var18_20 = (MosaicController)var19_22;
        }
        if (this.isLoggable()) {
            var19_23 = new TableWriter(null, " \u2502 ");
            var19_23.writeHorizontalSeparator();
            var19_23.write("Reader\tTile\tIndex\tSize\tSource\tDestination\tSubsampling");
            var19_23.writeHorizontalSeparator();
            var20_25 = System.nanoTime();
            var22_26 = 2;
        } else {
            var19_23 = null;
            var20_25 = 0L;
            var22_26 = 0;
        }
        try {
            for (Tile var24_29 : var11_11) {
                if (this.abortRequested()) {
                    this.processReadAborted();
                    var22_26 = 1;
                    break;
                }
                var25_30 = var24_29.getAbsoluteRegion();
                var26_31 = var25_30.intersection(var9_9);
                var27_32 = (var26_31.x - var9_9.x) % var12_12;
                var28_33 = (var26_31.y - var9_9.y) % var13_13;
                if (var27_32 != 0) {
                    var26_31.x -= var27_32;
                    var26_31.width += var27_32;
                    if (var26_31.x < var25_30.x) {
                        var26_31.x = var25_30.x;
                        if (var26_31.width > var25_30.width) {
                            var26_31.width = var25_30.width;
                        }
                    }
                }
                if (var28_33 != 0) {
                    var26_31.y -= var28_33;
                    var26_31.height += var28_33;
                    if (var26_31.y < var25_30.y) {
                        var26_31.y = var25_30.y;
                        if (var26_31.height > var25_30.height) {
                            var26_31.height = var25_30.height;
                        }
                    }
                }
                if (var15_17 != null) {
                    var27_32 = (var26_31.x - var9_9.x) / var12_12;
                    var28_33 = (var26_31.y - var9_9.y) / var13_13;
                    var16_19.x = var15_17.x + var27_32;
                    var16_19.y = var15_17.y + var28_33;
                }
                if (!MosaicImageReader.$assertionsDisabled && !var25_30.contains((Rectangle)var26_31)) {
                    throw new AssertionError(var26_31);
                }
                var26_31.translate(-var25_30.x, -var25_30.y);
                var3_3.setSize(var24_29.getSubsampling());
                if (!MosaicImageReader.$assertionsDisabled && var12_12 % var3_3.width != 0) {
                    throw new AssertionError(var3_3);
                }
                if (!MosaicImageReader.$assertionsDisabled && var13_13 % var3_3.height != 0) {
                    throw new AssertionError(var3_3);
                }
                var27_32 = var26_31.x % var3_3.width;
                var28_33 = var26_31.y % var3_3.height;
                var26_31.x /= var3_3.width;
                var26_31.y /= var3_3.height;
                if (var27_32 < 0) {
                    --var26_31.x;
                    var27_32 = var3_3.width - var27_32;
                }
                if (var28_33 < 0) {
                    --var26_31.y;
                    var28_33 = var3_3.height - var28_33;
                }
                var26_31.width += var27_32;
                var26_31.height += var28_33;
                var26_31.width /= var3_3.width;
                var26_31.height /= var3_3.height;
                if (var26_31.isEmpty()) continue;
                var3_3.width = var12_12 / var3_3.width;
                var3_3.height = var13_13 / var3_3.height;
                var29_34 = var24_29.getImageIndex();
                if (var19_23 != null) {
                    var19_23.write(Formats.getDisplayName(var24_29.getImageReaderSpi()));
                    var19_23.nextColumn();
                    var19_23.write(var24_29.getInputName());
                    var19_23.nextColumn();
                    var19_23.write(String.valueOf(var29_34));
                    MosaicImageReader.format(var19_23, var26_31.width, var26_31.height);
                    MosaicImageReader.format(var19_23, var26_31.x, var26_31.y);
                    MosaicImageReader.format(var19_23, var16_19.x, var16_19.y);
                    MosaicImageReader.format(var19_23, var3_3.width, var3_3.height);
                    var19_23.nextLine();
                }
                var30_35 = this.getTileReader(var24_29);
                var31_36 = var5_5.getCachedTileParameters(var30_35);
                try {
                    var31_36.setDestinationType(null);
                    if (var10_10.canWriteInPlace(var30_35.getOriginatingProvider())) {
                        var31_36.setDestination(var14_15);
                        var31_36.setDestinationOffset(var16_19);
                    }
                    if (var31_36.canSetSourceRenderSize()) {
                        var31_36.setSourceRenderSize(null);
                    }
                    var31_36.setSourceRegion((Rectangle)var26_31);
                    var31_36.setSourceSubsampling(var3_3.width, var3_3.height, 0, 0);
                    if (var18_20 != null) {
                        var18_20.configure(var24_29, var31_36);
                    }
                    var33_38 = this;
                    synchronized (var33_38) {
                        this.reading = var30_35;
                    }
                    var32_37 = var30_35.read(var29_34, var31_36);
                }
                finally {
                    var33_38 = this;
                    synchronized (var33_38) {
                        this.reading = null;
                    }
                    var31_36.setDestination(null);
                    var31_36.setSourceRegion(null);
                    var31_36.setDestinationOffset(new Point());
                }
                if (var14_15 == null) {
                    var14_15 = var32_37;
                    continue;
                }
                if (var32_37 == var14_15) continue;
                var33_38 = var32_37.getRaster();
                var33_38 = Raster.createRaster(var33_38.getSampleModel(), var33_38.getDataBuffer(), var16_19);
                var14_15.setData((Raster)var33_38);
            }
            var22_26 = 0;
            ** if (var19_23 == null) goto lbl-1000
        }
        catch (Throwable var39_44) {
            if (var19_23 != null) {
                var40_45 = System.nanoTime() - var20_25;
                var42_46 = this.logLevel;
                if (var42_46 == null) {
                    var42_46 = PerformanceLevel.forDuration((long)var40_45, (TimeUnit)TimeUnit.NANOSECONDS);
                }
                var19_23.writeHorizontalSeparator();
                var43_47 = Loggings.getResources((Locale)this.locale).getString(60, (Object)new Number[]{var9_9.x, var9_9.x + var9_9.width - 1, var9_9.y, var9_9.y + var9_9.height - 1, (double)var40_45 / 1000000.0, var22_26}) + System.getProperty("line.separator", "\n") + var19_23;
                MosaicImageReader.log("read", new LogRecord(var42_46, var43_47));
            }
            throw var39_44;
        }
lbl-1000:
        // 1 sources

        {
            var23_28 = System.nanoTime() - var20_25;
            var25_30 = this.logLevel;
            if (var25_30 == null) {
                var25_30 = PerformanceLevel.forDuration((long)var23_28, (TimeUnit)TimeUnit.NANOSECONDS);
            }
            var19_23.writeHorizontalSeparator();
            var26_31 = Loggings.getResources((Locale)this.locale).getString(60, (Object)new Number[]{var9_9.x, var9_9.x + var9_9.width - 1, var9_9.y, var9_9.y + var9_9.height - 1, (double)var23_28 / 1000000.0, var22_26}) + System.getProperty("line.separator", "\n") + var19_23;
            MosaicImageReader.log("read", new LogRecord((Level)var25_30, (String)var26_31));
        }
lbl-1000:
        // 2 sources

        {
        }
        this.processImageComplete();
        return var14_15;
    }

    private static void log(String string, LogRecord logRecord) {
        logRecord.setSourceClassName(MosaicImageReader.class.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName(Tile.LOGGER.getName());
        Tile.LOGGER.log(logRecord);
    }

    @Override
    public BufferedImage readTile(int n, int n2, int n3) throws IOException {
        int n4 = this.getTileWidth(n);
        int n5 = this.getTileHeight(n);
        Rectangle rectangle = new Rectangle(n2 * n4, n3 * n5, n4, n5);
        MosaicImageReadParam mosaicImageReadParam = this.getDefaultReadParam();
        mosaicImageReadParam.setSourceRegion(rectangle);
        return this.read(n, mosaicImageReadParam);
    }

    private static void format(TableWriter tableWriter, int n, int n2) {
        tableWriter.nextColumn();
        tableWriter.write(40);
        tableWriter.write(String.valueOf(n));
        tableWriter.write(44);
        tableWriter.write(String.valueOf(n2));
        tableWriter.write(41);
    }

    @Override
    public synchronized void abort() {
        super.abort();
        if (this.reading != null) {
            this.reading.abort();
        }
    }

    @Override
    public void close() throws IOException {
        this.readers.close();
    }

    @Override
    public void dispose() {
        this.cachedImageType = null;
        this.metadata = null;
        this.input = null;
        try {
            this.close();
        }
        catch (IOException iOException) {
            Logging.unexpectedException((Logger)Tile.LOGGER, MosaicImageReader.class, (String)"dispose", (Throwable)iOException);
        }
        this.readers.dispose();
        super.dispose();
    }

    public static class Spi
    extends ImageReaderSpi {
        static final String[] NAMES = new String[]{"mosaic"};
        public static final Spi DEFAULT = new Spi();

        public Spi() {
            this.vendorName = "Geotoolkit.org";
            this.version = Version.GEOTOOLKIT.toString();
            this.names = NAMES;
            this.pluginClassName = "org.geotoolkit.image.io.mosaic.MosaicImageReader";
        }

        @Override
        public synchronized Class<?>[] getInputTypes() {
            if (this.inputTypes == null) {
                this.inputTypes = new Class[]{TileManager[].class, TileManager.class, Tile[].class, Collection.class, File.class};
            }
            return super.getInputTypes();
        }

        @Override
        public boolean canDecodeInput(Object object) throws IOException {
            File file;
            if (object instanceof TileManager || object instanceof TileManager[] || object instanceof Tile[]) {
                return true;
            }
            if (object instanceof Collection) {
                for (Object e : (Collection)object) {
                    if (e instanceof Tile) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof File && (file = (File)object).canRead()) {
                if (file.isFile()) {
                    return "TileManager.serialized".equals(file.getName());
                }
                if (file.isDirectory()) {
                    return (file = new File(file, "TileManager.serialized")).isFile() && file.canRead();
                }
            }
            return false;
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new MosaicImageReader(this);
        }

        @Override
        public String getDescription(Locale locale) {
            return "Mosaic Image Reader";
        }
    }
}

