/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.util.Map;
import javax.imageio.IIOParam;
import javax.imageio.IIOParamController;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.geotoolkit.image.io.mosaic.MosaicImageReadParam;
import org.geotoolkit.image.io.mosaic.Tile;

public class MosaicController
implements IIOParamController {
    static final MosaicController DEFAULT = new MosaicController();

    protected MosaicController() {
    }

    @Override
    public boolean activate(IIOParam iIOParam) {
        if (iIOParam instanceof MosaicImageReadParam) {
            MosaicImageReadParam mosaicImageReadParam = (MosaicImageReadParam)iIOParam;
            for (Map.Entry<ImageReader, ImageReadParam> entry : mosaicImageReadParam.readers.entrySet()) {
                ImageReadParam imageReadParam = entry.getValue();
                if (imageReadParam == null) {
                    imageReadParam = mosaicImageReadParam.getTileParameters(entry.getKey());
                    entry.setValue(imageReadParam);
                }
                if (this.activateForTile(imageReadParam)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean activateForTile(IIOParam iIOParam) {
        if (iIOParam.hasController()) {
            return iIOParam.activateController();
        }
        return true;
    }

    protected void configure(Tile tile, IIOParam iIOParam) {
    }
}

