/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.image.io.IIOListeners;
import org.geotoolkit.image.io.mosaic.ComparedTileManager;
import org.geotoolkit.image.io.mosaic.FilenameFormatter;
import org.geotoolkit.image.io.mosaic.GridTileManager;
import org.geotoolkit.image.io.mosaic.MosaicImageReader;
import org.geotoolkit.image.io.mosaic.MosaicImageWriteParam;
import org.geotoolkit.image.io.mosaic.MosaicImageWriter;
import org.geotoolkit.image.io.mosaic.OverviewLevel;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileLayout;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.image.io.mosaic.TileManagerFactory;
import org.geotoolkit.image.io.mosaic.TileWritingPolicy;
import org.geotoolkit.image.io.plugin.WorldFileImageReader;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.lang.Builder;
import org.geotoolkit.math.Fraction;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.collection.BackingStoreException;
import org.geotoolkit.util.logging.LogProducer;
import org.geotoolkit.util.logging.PerformanceLevel;

@ThreadSafe
public class MosaicBuilder
extends Builder<TileManager>
implements LogProducer {
    private static final int DEFAULT_TILE_SIZE = 512;
    private static final int MIN_TILE_SIZE = 64;
    protected final TileManagerFactory factory;
    private TileLayout layout;
    private File directory;
    private ImageReaderSpi tileReaderSpi;
    private AffineTransform gridToCRS;
    private Rectangle untiledBounds;
    private Dimension tileSize;
    private int[] subsamplings;
    private final IIOListeners listeners;
    private final FilenameFormatter formatter;
    private Level logLevel;

    public MosaicBuilder() {
        this(null);
    }

    public MosaicBuilder(TileManagerFactory tileManagerFactory) {
        this.factory = tileManagerFactory != null ? tileManagerFactory : TileManagerFactory.DEFAULT;
        this.layout = TileLayout.CONSTANT_TILE_SIZE;
        this.formatter = new FilenameFormatter();
        this.listeners = new IIOListeners();
    }

    public synchronized Level getLogLevel() {
        Level level = this.logLevel;
        return level != null ? level : PerformanceLevel.PERFORMANCE;
    }

    public synchronized void setLogLevel(Level level) {
        this.logLevel = level;
    }

    public synchronized TileLayout getTileLayout() {
        return this.layout;
    }

    public synchronized void setTileLayout(TileLayout tileLayout) {
        if (tileLayout != null) {
            switch (tileLayout) {
                case CONSTANT_TILE_SIZE: 
                case CONSTANT_GEOGRAPHIC_AREA: {
                    this.layout = tileLayout;
                    return;
                }
            }
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"layout", (Object)((Object)tileLayout)));
    }

    public synchronized File getTileDirectory() {
        return this.directory;
    }

    public synchronized void setTileDirectory(File file) {
        this.directory = file;
    }

    public synchronized ImageReaderSpi getTileReaderSpi() {
        return this.tileReaderSpi;
    }

    public synchronized void setTileReaderSpi(ImageReaderSpi imageReaderSpi) {
        this.tileReaderSpi = imageReaderSpi;
    }

    public void setTileReaderSpi(String string) throws IllegalArgumentException {
        this.setTileReaderSpi(Formats.getReaderByFormatName(string, WorldFileImageReader.Spi.class));
    }

    public synchronized AffineTransform getGridToCRS() {
        return this.gridToCRS != null ? (AffineTransform)this.gridToCRS.clone() : null;
    }

    public synchronized void setGridToCRS(AffineTransform affineTransform) {
        this.gridToCRS = affineTransform != null ? new AffineTransform(affineTransform) : null;
    }

    public synchronized Rectangle getUntiledImageBounds() {
        return this.untiledBounds != null ? (Rectangle)this.untiledBounds.clone() : null;
    }

    public synchronized void setUntiledImageBounds(Rectangle rectangle) {
        this.untiledBounds = rectangle != null ? new Rectangle(rectangle) : null;
    }

    public synchronized Dimension getTileSize() {
        if (this.tileSize == null) {
            Rectangle rectangle = this.getUntiledImageBounds();
            if (rectangle == null) {
                return null;
            }
            int n = rectangle.width;
            int n2 = rectangle.height;
            n = MosaicBuilder.suggestedTileSize(n);
            n2 = n2 == rectangle.width ? n : MosaicBuilder.suggestedTileSize(n2);
            this.tileSize = new Dimension(n, n2);
        }
        return (Dimension)this.tileSize.clone();
    }

    public synchronized void setTileSize(Dimension dimension) {
        if (dimension == null) {
            this.tileSize = null;
        } else {
            if (dimension.width < 2 || dimension.height < 2) {
                throw new IllegalArgumentException(Errors.format((int)72, (Object)"size"));
            }
            this.tileSize = new Dimension(dimension);
        }
    }

    private static int suggestedTileSize(int n) {
        return MosaicBuilder.suggestedTileSize(n, 512, 384, 640);
    }

    public static int suggestedTileSize(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        if (n3 <= 1 || n3 > n4) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)n3, (Object)n4));
        }
        ArgumentChecks.ensureBetween((String)"tileSize", (int)n3, (int)n4, (int)n2);
        if (n <= n3) {
            return n;
        }
        int n5 = 0;
        int n6 = n2;
        for (int i = n3; i <= n4; ++i) {
            int n7;
            if (n % i != 0 || (n7 = MathFunctions.divisors((int)Fraction.round((int)n, (int)i)).length) < n5 || n7 == n5 && Math.abs(i - n2) >= Math.abs(n6 - n2)) continue;
            n6 = i;
            n5 = n7;
        }
        return n6;
    }

    public synchronized Dimension[] getSubsamplings() {
        int n;
        Dimension[] dimensionArray;
        if (this.subsamplings == null) {
            int n2;
            dimensionArray = this.getUntiledImageBounds();
            if (dimensionArray == null) {
                return null;
            }
            Dimension dimension = this.getTileSize();
            if (dimension == null) {
                return null;
            }
            if (this.layout == TileLayout.CONSTANT_GEOGRAPHIC_AREA) {
                n = dimension.width / 64;
                n2 = dimension.height / 64;
            } else {
                n = (dimensionArray.width - 1) / dimension.width + 1;
                n2 = (dimensionArray.height - 1) / dimension.height + 1;
            }
            int[] nArray = new int[Math.max(1, 32 - Integer.numberOfLeadingZeros(Math.max(n, n2) - 1))];
            int n3 = 0;
            int n4 = 1;
            while (n3 < nArray.length) {
                nArray[n3] = n4;
                ++n3;
                n4 <<= 1;
            }
            this.setSubsamplings(nArray);
        }
        dimensionArray = new Dimension[this.subsamplings.length / 2];
        int n5 = 0;
        for (n = 0; n < dimensionArray.length; ++n) {
            dimensionArray[n] = new Dimension(this.subsamplings[n5++], this.subsamplings[n5++]);
        }
        return dimensionArray;
    }

    public synchronized void setSubsamplings(Dimension ... dimensionArray) {
        int[] nArray;
        if (dimensionArray == null) {
            nArray = null;
        } else {
            int n = 0;
            nArray = new int[dimensionArray.length * 2];
            for (int i = 0; i < dimensionArray.length; ++i) {
                Dimension dimension = dimensionArray[i];
                int n2 = dimension.width;
                int n3 = dimension.height;
                if (n2 < 1 || n3 < 1) {
                    throw new IllegalArgumentException(Errors.format((int)72, (Object)("subsamplings[" + i + ']')));
                }
                nArray[n++] = n2;
                nArray[n++] = n3;
            }
        }
        this.subsamplings = nArray;
    }

    public void setSubsamplings(int ... nArray) {
        Dimension[] dimensionArray;
        if (nArray == null) {
            dimensionArray = null;
        } else {
            dimensionArray = new Dimension[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                dimensionArray[i] = new Dimension(n, n);
            }
        }
        this.setSubsamplings(dimensionArray);
    }

    public TileManager build() throws BackingStoreException {
        try {
            return this.createTileManager();
        }
        catch (IOException iOException) {
            throw new BackingStoreException((Throwable)iOException);
        }
    }

    public synchronized TileManager createTileManager() throws IOException {
        return this.createFromInput(null);
    }

    private TileManager createFromInput(TileManager tileManager) throws IOException {
        ImageGeometry imageGeometry;
        TileManager tileManager2;
        this.tileReaderSpi = this.getTileReaderSpi();
        if (this.tileReaderSpi == null) {
            throw new IllegalStateException(Errors.format((int)158));
        }
        this.untiledBounds = this.getUntiledImageBounds();
        if (this.untiledBounds == null) {
            throw new IllegalStateException(Errors.format((int)235));
        }
        this.tileSize = this.getTileSize();
        if (this.tileSize == null) {
            this.tileSize = ImageUtilities.toTileSize((Dimension)this.untiledBounds.getSize());
        }
        this.formatter.initialize(this.tileReaderSpi);
        boolean bl = false;
        switch (this.layout) {
            case CONSTANT_GEOGRAPHIC_AREA: {
                bl = true;
            }
            case CONSTANT_TILE_SIZE: {
                tileManager2 = this.createFromInput(bl, this.canUsePattern(), tileManager);
                break;
            }
            default: {
                throw new IllegalStateException(this.layout.toString());
            }
        }
        if (this.gridToCRS == null && tileManager != null && (imageGeometry = tileManager.getGridGeometry()) != null) {
            this.gridToCRS = imageGeometry.getGridToCRS();
        }
        if (this.gridToCRS != null) {
            tileManager2.setGridToCRS(this.gridToCRS);
        }
        return tileManager2;
    }

    private TileManager createFromInput(boolean bl, boolean bl2, TileManager tileManager) throws IOException {
        TileManager tileManager2;
        TileManager[] tileManagerArray;
        OverviewLevel[] overviewLevelArray;
        ArrayList<Tile> arrayList;
        Dimension dimension = this.tileSize;
        Rectangle rectangle = this.untiledBounds;
        Rectangle rectangle2 = new Rectangle(rectangle);
        Rectangle rectangle3 = new Rectangle(dimension);
        Dimension[] dimensionArray = this.getSubsamplings();
        if (dimensionArray == null || dimensionArray.length == 0) {
            throw new IllegalStateException(Errors.format((int)120, (Object)Vocabulary.format((int)285)));
        }
        if (bl2) {
            arrayList = null;
            overviewLevelArray = new OverviewLevel[dimensionArray.length];
        } else {
            arrayList = new ArrayList<Tile>();
            overviewLevelArray = null;
        }
        Rectangle rectangle4 = new Rectangle();
        this.formatter.computeLevelFieldSize(dimensionArray.length);
        for (int i = 0; i < dimensionArray.length; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            tileManagerArray = dimensionArray[i];
            int n5 = tileManagerArray.width;
            int n6 = tileManagerArray.height;
            rectangle2.setBounds(rectangle.x / n5, rectangle.y / n6, rectangle.width / n5, rectangle.height / n6);
            rectangle3.setBounds(rectangle2);
            rectangle3.setSize(dimension);
            if (bl) {
                rectangle3.width /= n5;
                rectangle3.height /= n6;
            } else {
                if (rectangle3.width > rectangle2.width) {
                    rectangle3.width = rectangle2.width;
                }
                if (rectangle3.height > rectangle2.height) {
                    rectangle3.height = rectangle2.height;
                }
            }
            this.formatter.computeFieldSizes(rectangle2, rectangle3);
            if (bl2) {
                String string = this.formatter.toString();
                string = new File(this.directory, string).getPath();
                string = "File:" + string;
                Tile tile = new Tile(this.tileReaderSpi, (Object)string, 0, rectangle3, (Dimension)tileManagerArray);
                OverviewLevel overviewLevel = new OverviewLevel(tile, rectangle2);
                overviewLevel.createLinkedList(i, i != 0 ? overviewLevelArray[i - 1] : null);
                if (tileManager != null) {
                    n4 = overviewLevel.getNumXTiles();
                    n3 = overviewLevel.getNumYTiles();
                    rectangle4.width = n5 * rectangle3.width;
                    rectangle4.height = n6 * rectangle3.height;
                    rectangle4.y = n6 * rectangle3.y;
                    for (n2 = 0; n2 < n3; ++n2) {
                        rectangle4.x = n5 * rectangle3.x;
                        for (n = 0; n < n4; ++n) {
                            if (!tileManager.intersects(rectangle4, (Dimension)tileManagerArray)) {
                                overviewLevel.removeTile(n, n2);
                            }
                            rectangle4.x += rectangle4.width;
                        }
                        rectangle4.y += rectangle4.height;
                    }
                }
                overviewLevelArray[i] = overviewLevel;
                continue;
            }
            int n7 = rectangle2.x;
            int n8 = rectangle2.y;
            int n9 = rectangle2.width + n7;
            n4 = rectangle2.height + n8;
            n3 = rectangle3.width;
            n2 = rectangle3.height;
            rectangle4.width = n5 * n3;
            rectangle4.height = n6 * n2;
            n = 0;
            rectangle3.y = n8;
            while (rectangle3.y < n4) {
                int n10 = 0;
                rectangle4.y = n6 * rectangle3.y;
                rectangle3.x = n7;
                while (rectangle3.x < n9) {
                    block23: {
                        block22: {
                            if (tileManager == null) break block22;
                            rectangle4.x = n5 * rectangle3.x;
                            if (!tileManager.intersects(rectangle4, (Dimension)tileManagerArray)) break block23;
                        }
                        Rectangle rectangle5 = rectangle3.intersection(rectangle2);
                        File file = new File(this.directory, this.generateFilename(i, n10, n));
                        Tile tile = new Tile(this.tileReaderSpi, (Object)file, 0, rectangle5, (Dimension)tileManagerArray);
                        arrayList.add(tile);
                    }
                    rectangle3.x += n3;
                    ++n10;
                }
                rectangle3.y += n2;
                ++n;
            }
        }
        if (bl2) {
            tileManager2 = new GridTileManager(overviewLevelArray[overviewLevelArray.length - 1]);
            assert (!new ComparedTileManager(tileManager2, this.createFromInput(bl, false, tileManager)).getTiles().isEmpty());
        } else {
            tileManagerArray = this.factory.create(arrayList);
            tileManager2 = tileManagerArray[0];
        }
        return tileManager2;
    }

    public synchronized TileManager createTileManager(Object object) throws IOException {
        MosaicImageWriteParam mosaicImageWriteParam = new MosaicImageWriteParam();
        mosaicImageWriteParam.setTileWritingPolicy(TileWritingPolicy.NO_WRITE);
        return this.writeFromInput(object, 0, mosaicImageWriteParam, true);
    }

    public synchronized TileManager writeFromInput(Object object, MosaicImageWriteParam mosaicImageWriteParam) throws IOException {
        return this.writeFromInput(object, 0, mosaicImageWriteParam, true);
    }

    public synchronized TileManager writeFromInput(Object object, int n, MosaicImageWriteParam mosaicImageWriteParam) throws IOException {
        return this.writeFromInput(object, n, mosaicImageWriteParam, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TileManager writeFromInput(Object object, int n, MosaicImageWriteParam mosaicImageWriteParam, boolean bl) throws IOException {
        this.formatter.ensurePrefixSet(object);
        TileWritingPolicy tileWritingPolicy = mosaicImageWriteParam != null ? mosaicImageWriteParam.getTileWritingPolicy() : TileWritingPolicy.DEFAULT;
        Writer writer = new Writer(n, tileWritingPolicy);
        writer.setLogLevel(this.logLevel);
        try {
            if (!writer.writeFromInput(object, n, mosaicImageWriteParam, bl)) {
                TileManager tileManager = null;
                return tileManager;
            }
        }
        finally {
            writer.dispose();
        }
        TileManager tileManager = writer.outputTiles;
        if (tileManager.getGridGeometry() == null && writer.inputTiles != null) {
            for (TileManager tileManager2 : writer.inputTiles) {
                ImageGeometry imageGeometry = tileManager2.getGridGeometry();
                if (imageGeometry == null) continue;
                tileManager.setGridToCRS((AffineTransform)imageGeometry.getGridToCRS());
                break;
            }
        }
        return tileManager;
    }

    public IIOListeners listeners() {
        return this.listeners;
    }

    private boolean canUsePattern() {
        Object[] objectArray = new Class[3];
        Arrays.fill(objectArray, Integer.TYPE);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        while (true) {
            try {
                Method method = clazz.getDeclaredMethod("generateFilename", (Class<?>[])objectArray);
                return method.getDeclaringClass() == MosaicBuilder.class;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new AssertionError();
            }
            break;
        }
    }

    protected String generateFilename(int n, int n2, int n3) {
        return this.formatter.generateFilename(n, n2, n3);
    }

    protected void onTileWrite(Tile tile, ImageWriteParam imageWriteParam) throws IOException {
    }

    private final class Writer
    extends MosaicImageWriter {
        private final TileWritingPolicy policy;
        private final int inputIndex;
        TileManager[] inputTiles;
        TileManager outputTiles;

        Writer(int n, TileWritingPolicy tileWritingPolicy) {
            this.inputIndex = n;
            this.policy = tileWritingPolicy;
            MosaicBuilder.this.listeners.addListenersTo((ImageWriter)this);
        }

        @Override
        protected boolean isCachingEnabled(ImageReader imageReader, int n) throws IOException {
            for (Dimension dimension : MosaicBuilder.this.getSubsamplings()) {
                if (dimension.width != 1 || dimension.height != 1) continue;
                return super.isCachingEnabled(imageReader, n);
            }
            return false;
        }

        @Override
        protected boolean filter(ImageReader imageReader) throws IOException {
            Object object;
            Rectangle rectangle = new Rectangle();
            rectangle.width = imageReader.getWidth(this.inputIndex);
            rectangle.height = imageReader.getHeight(this.inputIndex);
            TileManager tileManager = null;
            if (imageReader instanceof MosaicImageReader) {
                object = (MosaicImageReader)imageReader;
                this.inputTiles = ((MosaicImageReader)object).getInput();
                if (this.inputTiles.length > this.inputIndex && this.policy != null && !this.policy.includeEmpty) {
                    tileManager = this.inputTiles[this.inputIndex];
                }
                imageReader = ((MosaicImageReader)object).readers.getTileReader();
            }
            if (imageReader != null && (object = imageReader.getOriginatingProvider()) != null && MosaicBuilder.this.getTileReaderSpi() == null) {
                MosaicBuilder.this.setTileReaderSpi((ImageReaderSpi)object);
            }
            MosaicBuilder.this.setUntiledImageBounds(rectangle);
            this.outputTiles = MosaicBuilder.this.createFromInput(tileManager);
            try {
                this.setOutput(this.outputTiles);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Throwable throwable = illegalArgumentException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw illegalArgumentException;
            }
            MosaicBuilder.this.listeners.addListenersTo(imageReader);
            return super.filter(imageReader);
        }

        @Override
        protected void onTileWrite(Tile tile, ImageWriteParam imageWriteParam) throws IOException {
            MosaicBuilder.this.onTileWrite(tile, imageWriteParam);
        }
    }
}

