/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;
import org.geotoolkit.image.io.mosaic.Tile;

final class LargeTile
extends Tile {
    private static final long serialVersionUID = -390809968753673788L;
    private int width;
    private int height;

    public LargeTile(ImageReaderSpi imageReaderSpi, Object object, int n, Point point, Dimension dimension) {
        super(imageReaderSpi, object, n, point, dimension);
    }

    public LargeTile(ImageReaderSpi imageReaderSpi, Object object, int n, Rectangle rectangle, Dimension dimension) {
        super(imageReaderSpi, object, n, rectangle, dimension);
    }

    public LargeTile(ImageReaderSpi imageReaderSpi, Object object, int n, Rectangle rectangle, AffineTransform affineTransform) {
        super(imageReaderSpi, object, n, rectangle, affineTransform);
        try {
            assert (rectangle == null || rectangle.equals(this.getRegion()));
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public LargeTile(ImageReaderSpi imageReaderSpi, Object object, int n, Rectangle rectangle) {
        super(imageReaderSpi, object, n, rectangle);
        try {
            assert (rectangle.equals(this.getRegion()));
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    final void setSize(int n, int n2) throws IllegalArgumentException {
        super.setSize(Math.min(n, 65535), Math.min(n2, 65535));
        this.width = n;
        this.height = n2;
    }

    @Override
    public Dimension getSize() throws IOException {
        Dimension dimension = super.getSize();
        dimension.width = this.width;
        dimension.height = this.height;
        return dimension;
    }

    @Override
    public Rectangle getRegion() throws IOException {
        Rectangle rectangle = super.getRegion();
        rectangle.width = this.width;
        rectangle.height = this.height;
        return rectangle;
    }
}

