/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.image.io.mosaic.GridTileIterator;
import org.geotoolkit.image.io.mosaic.OverviewLevel;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.FrequencySortedSet;

final class GridTileManager
extends TileManager {
    private static final long serialVersionUID = -3140767174475649400L;
    private final OverviewLevel root;
    private final Rectangle region;
    private final int count;
    private transient Collection<Tile> tiles;

    GridTileManager(OverviewLevel overviewLevel) {
        this.root = overviewLevel;
        this.region = new Rectangle(-1, -1);
        int n = 0;
        OverviewLevel overviewLevel2 = overviewLevel;
        do {
            this.region.add(overviewLevel2.getAbsoluteRegion());
            n += overviewLevel2.getNumTiles();
        } while ((overviewLevel2 = overviewLevel2.getFinerLevel()) != null);
        this.count = n;
    }

    protected GridTileManager(Tile[] tileArray) throws IOException, IllegalArgumentException {
        Object object;
        ArgumentChecks.ensureNonNull((String)"tiles", (Object)tileArray);
        Tile[] tileArray2 = tileArray;
        HashMap<Dimension, Object> hashMap = new HashMap<Dimension, Object>();
        for (int i = 0; i < tileArray2.length; ++i) {
            Tile tile = tileArray2[i];
            Dimension dimension = tile.getSubsampling();
            object = (OverviewLevel)hashMap.get(dimension);
            if (object == null) {
                int n = i;
                while (++n < tileArray2.length) {
                    Tile tile2 = tileArray2[n];
                    if (!tile2.isLargerThan(tile)) continue;
                    if (tileArray2 == tileArray) {
                        tileArray2 = (Tile[])tileArray2.clone();
                    }
                    tileArray2[n] = tile;
                    tile = tile2;
                    dimension = tile.getSubsampling();
                }
                object = new OverviewLevel(tile, dimension);
                hashMap.put(dimension, object);
                continue;
            }
            ((OverviewLevel)object).add(tile, dimension);
        }
        Object[] objectArray = hashMap.values().toArray(new OverviewLevel[hashMap.size()]);
        Arrays.sort(objectArray);
        this.region = new Rectangle(-1, -1);
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            ((OverviewLevel)object).createLinkedList(i, (OverviewLevel)(i != 0 ? objectArray[i - 1] : null));
            this.region.add(((OverviewLevel)object).getAbsoluteRegion());
            n += ((OverviewLevel)object).getNumTiles();
        }
        this.count = n;
        this.root = objectArray.length != 0 ? objectArray[objectArray.length - 1] : null;
    }

    @Override
    final Rectangle getRegion() {
        return this.region;
    }

    @Override
    final Dimension getTileSize() {
        for (OverviewLevel overviewLevel = this.root; overviewLevel != null; overviewLevel = overviewLevel.getFinerLevel()) {
            Dimension dimension = overviewLevel.getTileSize();
            if (dimension == null) continue;
            return dimension;
        }
        return this.region.getSize();
    }

    @Override
    final boolean isImageTiled() throws IOException {
        return this.count >= 2;
    }

    @Override
    final Collection<Tile> getInternalTiles() {
        FrequencySortedSet frequencySortedSet = new FrequencySortedSet();
        for (OverviewLevel overviewLevel = this.root; overviewLevel != null; overviewLevel = overviewLevel.getFinerLevel()) {
            overviewLevel.getInternalTiles((FrequencySortedSet<? super Tile>)frequencySortedSet);
        }
        return frequencySortedSet;
    }

    @Override
    public synchronized Collection<Tile> getTiles() {
        if (this.tiles == null) {
            this.tiles = new AbstractSet<Tile>(){

                @Override
                public int size() {
                    return GridTileManager.this.count;
                }

                @Override
                public Iterator<Tile> iterator() {
                    return new GridTileIterator(GridTileManager.this.root);
                }

                @Override
                public boolean contains(Object object) {
                    return object instanceof Tile && OverviewLevel.contains(GridTileManager.this.root, (Tile)object);
                }
            };
        }
        return this.tiles;
    }

    @Override
    public Collection<Tile> getTiles(Rectangle rectangle, Dimension dimension, boolean bl) throws IOException {
        for (OverviewLevel overviewLevel = this.root; overviewLevel != null; overviewLevel = overviewLevel.getFinerLevel()) {
            Tile tile = overviewLevel.getSampleTile();
            Dimension dimension2 = tile.getSubsamplingFloor(dimension);
            if (dimension2 == null || dimension2 != dimension && !bl) continue;
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            overviewLevel.getTiles(arrayList, rectangle, dimension, Long.MAX_VALUE);
            dimension.setSize(dimension2);
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean intersects(Rectangle rectangle, Dimension dimension) throws IOException {
        for (OverviewLevel overviewLevel = this.root; overviewLevel != null; overviewLevel = overviewLevel.getFinerLevel()) {
            int n = overviewLevel.compareTo(dimension);
            if (n > 0 || !overviewLevel.intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean canWriteInPlace(ImageReaderSpi imageReaderSpi) {
        return true;
    }

    public int hashCode() {
        return 0x332BEE88 ^ this.root.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridTileManager gridTileManager = (GridTileManager)object;
            return this.count == gridTileManager.count && Utilities.equals((Object)this.region, (Object)gridTileManager.region) && Utilities.equals((Object)this.root, (Object)gridTileManager.root);
        }
        return false;
    }
}

