/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.sis.math.MathFunctions;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.collection.XCollections;

final class GDALTileManager
extends TileManager
implements Comparator<Rectangle> {
    private static final long serialVersionUID = 7452795743008991530L;
    private static final int THRESHOLD = 8;
    private static final Comparator<Tile> BY_SUBSAMPLING = new Comparator<Tile>(){

        @Override
        public int compare(Tile tile, Tile tile2) {
            Dimension dimension = tile.getSubsampling();
            Dimension dimension2 = tile2.getSubsampling();
            return MathFunctions.sgn((long)((long)dimension2.width * (long)dimension2.height - (long)dimension.width * (long)dimension.height));
        }
    };
    private final Tile[][] tilesByRegion;
    private final Rectangle[] tileRegions;
    private final Rectangle region;
    private final boolean sortedByY;
    private transient Dimension tileSize;

    protected GDALTileManager(Tile[] tileArray) throws IOException, IllegalArgumentException {
        Object object;
        Cloneable cloneable;
        int n = 1;
        int n2 = 1;
        for (Tile tile : tileArray) {
            cloneable = tile.getSubsampling();
            if (((Dimension)cloneable).width > n) {
                n = ((Dimension)cloneable).width;
            }
            if (((Dimension)cloneable).height <= n2) continue;
            n2 = ((Dimension)cloneable).height;
        }
        n <<= 1;
        n2 <<= 1;
        long l = 0L;
        long l2 = 0L;
        cloneable = new HashMap();
        for (Tile object2 : tileArray) {
            Rectangle rectangle = object2.getAbsoluteRegion();
            l += (long)rectangle.width;
            l2 += (long)rectangle.height;
            rectangle.x = GDALTileManager.divide(rectangle.x, n, false);
            rectangle.y = GDALTileManager.divide(rectangle.y, n2, false);
            rectangle.width = GDALTileManager.divide(rectangle.width, n, true);
            rectangle.height = GDALTileManager.divide(rectangle.height, n2, true);
            if (rectangle.width < 8 || rectangle.height < 8) {
                throw new IllegalArgumentException(Errors.format((int)209));
            }
            object = (List)cloneable.get(rectangle);
            if (object == null) {
                object = new ArrayList();
                cloneable.put(rectangle, object);
            }
            object.add(object2);
        }
        int n3 = 0;
        int n4 = cloneable.size();
        this.region = new Rectangle(-1, -1);
        this.tileRegions = new Rectangle[n4];
        this.tilesByRegion = new Tile[n4][];
        for (List list : cloneable.values()) {
            int n5 = list.size();
            if (n5 < 2) {
                throw new IllegalArgumentException(Errors.format((int)91));
            }
            object = list.toArray(new Tile[n5]);
            Arrays.sort(object, BY_SUBSAMPLING);
            Rectangle rectangle = new Rectangle(-1, -1);
            for (Tile tile : object) {
                rectangle.add(tile.getAbsoluteRegion());
            }
            this.tilesByRegion[n3] = object;
            this.tileRegions[n3++] = rectangle;
            this.region.add(rectangle);
        }
        this.sortedByY = (long)tileArray.length * (long)this.region.height / l2 >= (long)tileArray.length * (long)this.region.width / l;
        IdentityHashMap identityHashMap = new IdentityHashMap(XCollections.hashMapCapacity((int)n4));
        for (n3 = 0; n3 < n4; ++n3) {
            identityHashMap.put(this.tileRegions[n3], this.tilesByRegion[n3]);
        }
        Arrays.sort(this.tileRegions, this);
        for (n3 = 0; n3 < n4; ++n3) {
            this.tilesByRegion[n3] = (Tile[])identityHashMap.get(this.tileRegions[n3]);
            if (this.tilesByRegion[n3] == null) {
                throw new AssertionError();
            }
            assert (this.tileRegions[n3].contains(this.tilesByRegion[n3][0].getAbsoluteRegion()));
        }
    }

    private static int divide(int n, int n2, boolean bl) {
        if (bl) {
            if (n >= 0) {
                n += n2 - 1;
            } else if (n < 0) {
                n -= n2 - 1;
            }
        }
        return n / n2;
    }

    @Override
    public int compare(Rectangle rectangle, Rectangle rectangle2) {
        return MathFunctions.sgn((long)this.compare(rectangle, rectangle2.x, rectangle2.y));
    }

    private long compare(Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        if (this.sortedByY) {
            n4 = rectangle.y;
            n3 = n2;
        } else {
            n4 = rectangle.x;
            n3 = n;
        }
        if (n4 == n3) {
            if (this.sortedByY) {
                n4 = rectangle.x;
                n3 = n;
            } else {
                n4 = rectangle.y;
                n3 = n2;
            }
        }
        return (long)n4 - (long)n3;
    }

    @Override
    final Rectangle getRegion() {
        return this.region;
    }

    @Override
    final synchronized Dimension getTileSize() {
        if (this.tileSize == null) {
            FrequencySortedSet frequencySortedSet = new FrequencySortedSet(true);
            for (Rectangle rectangle : this.tileRegions) {
                frequencySortedSet.add((Object)rectangle.getSize());
            }
            this.tileSize = (Dimension)frequencySortedSet.first();
        }
        return this.tileSize;
    }

    @Override
    final boolean isImageTiled() {
        return this.tilesByRegion.length >= 2;
    }

    private static int getTiles(Tile[][] tileArray, Tile[] tileArray2) {
        int n = 0;
        for (Tile[] tileArray3 : tileArray) {
            if (tileArray2 != null) {
                System.arraycopy(tileArray3, 0, tileArray2, n, tileArray3.length);
            }
            n += tileArray3.length;
        }
        return n;
    }

    @Override
    public Collection<Tile> getTiles() {
        Tile[] tileArray = new Tile[GDALTileManager.getTiles(this.tilesByRegion, null)];
        GDALTileManager.getTiles(this.tilesByRegion, tileArray);
        return Arrays.asList(tileArray);
    }

    @Override
    public Collection<Tile> getTiles(Rectangle rectangle, Dimension dimension, boolean bl) throws IOException {
        Cloneable cloneable;
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = 0;
        Tile[][] tileArrayArray = new Tile[Math.min(this.tilesByRegion.length, 4)][];
        for (int i = 0; i < this.tileRegions.length && this.compare((Rectangle)(cloneable = this.tileRegions[i]), n, n2) <= 0L; ++i) {
            if (!rectangle.intersects((Rectangle)cloneable)) continue;
            if (n3 == tileArrayArray.length) {
                tileArrayArray = (Tile[][])Arrays.copyOf(tileArrayArray, n3 << 1);
            }
            tileArrayArray[n3++] = this.tilesByRegion[i];
        }
        int[] nArray = new int[n3];
        cloneable = dimension;
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        block1: for (int i = 0; i < n3; ++i) {
            Tile[] tileArray = tileArrayArray[i];
            for (int j = nArray[i]; j < tileArray.length; ++j) {
                Tile tile = tileArray[j];
                Dimension dimension2 = tile.getSubsamplingFloor((Dimension)cloneable);
                if (dimension2 == null) continue;
                if (dimension2 != cloneable) {
                    if (!bl) continue;
                    boolean bl2 = cloneable != dimension;
                    cloneable = dimension2;
                    if (bl2) {
                        arrayList.clear();
                        nArray[i] = j;
                        i = -1;
                        continue block1;
                    }
                }
                if (tile.getAbsoluteRegion().intersects(rectangle)) {
                    arrayList.add(tile);
                }
                nArray[i] = j + 1;
                continue block1;
            }
        }
        if (cloneable != dimension) {
            dimension.setSize((Dimension)cloneable);
        }
        GDALTileManager.removeOverlaps(arrayList, rectangle);
        return arrayList;
    }

    private static void removeOverlaps(List<Tile> list, Rectangle rectangle) throws IOException {
        int n;
        int n2 = list.size();
        Rectangle[] rectangleArray = new Rectangle[n2];
        for (n = 0; n < n2; ++n) {
            rectangleArray[n] = rectangle.intersection(list.get(n).getAbsoluteRegion());
        }
        for (n = 0; n < n2; ++n) {
            Rectangle rectangle2 = rectangleArray[n];
            int n3 = n2;
            while (--n3 >= 0) {
                if (n == n3 || !rectangle2.contains(rectangleArray[n3])) continue;
                System.arraycopy(rectangleArray, n3 + 1, rectangleArray, n3, --n2 - n3);
                list.remove(n3);
                if (n3 >= n) continue;
                --n;
            }
        }
    }

    @Override
    public boolean intersects(Rectangle rectangle, Dimension dimension) {
        Rectangle rectangle2;
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        for (int i = 0; i < this.tileRegions.length && this.compare(rectangle2 = this.tileRegions[i], n, n2) <= 0L; ++i) {
            if (!rectangle.intersects(rectangle2)) continue;
            Tile[] tileArray = this.tilesByRegion[i];
            int n3 = tileArray.length;
            while (--n3 >= 0) {
                Dimension dimension2 = tileArray[n3].getSubsampling();
                if (dimension2.width > dimension.width || dimension2.height > dimension.height) continue;
                return true;
            }
        }
        return false;
    }
}

