/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import javax.imageio.spi.ImageReaderSpi;
import org.geotoolkit.resources.Errors;

final class FilenameFormatter
implements Serializable {
    private static final long serialVersionUID = 67144666748146079L;
    private static final String DEFAULT_PREFIX = "L";
    private int levelFieldSize;
    private int rowFieldSize;
    private int columnFieldSize;
    private String prefix;
    private String levelSeparator = "_";
    private String locationSeparator = "";
    private String suffix;

    public void initialize(ImageReaderSpi imageReaderSpi) {
        if (this.prefix == null) {
            this.prefix = DEFAULT_PREFIX;
        }
        this.suffix = "";
        String[] stringArray = imageReaderSpi.getFileSuffixes();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.length() <= this.suffix.length()) continue;
                this.suffix = string;
            }
            if (!this.suffix.startsWith(".")) {
                this.suffix = "." + this.suffix;
            }
        }
        this.levelFieldSize = 0;
        this.rowFieldSize = 0;
        this.columnFieldSize = 0;
    }

    public void computeLevelFieldSize(int n) {
        this.levelFieldSize = (int)Math.log10(n) + 1;
    }

    public void computeFieldSizes(Rectangle rectangle, Rectangle rectangle2) {
        StringBuilder stringBuilder = new StringBuilder();
        FilenameFormatter.format26(stringBuilder, rectangle.width / rectangle2.width, 0);
        this.columnFieldSize = stringBuilder.length();
        stringBuilder.setLength(0);
        FilenameFormatter.format10(stringBuilder, rectangle.height / rectangle2.height, 0);
        this.rowFieldSize = stringBuilder.length();
    }

    private static void format10(StringBuilder stringBuilder, int n, int n2) {
        String string = Integer.toString(n + 1);
        int n3 = n2 - string.length();
        while (--n3 >= 0) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    private static void format26(StringBuilder stringBuilder, int n, int n2) {
        if (n2 > 1 || n >= 26) {
            FilenameFormatter.format26(stringBuilder, n / 26, n2 - 1);
            n %= 26;
        }
        stringBuilder.append((char)(65 + n));
    }

    public void ensurePrefixSet(Object object) {
        if (this.prefix == null) {
            int n;
            String string;
            if (object instanceof File) {
                string = ((File)object).getName();
            } else if (object instanceof URI || object instanceof URL || object instanceof CharSequence) {
                string = object.toString();
                string = string.substring(string.lastIndexOf(47) + 1);
            } else {
                string = DEFAULT_PREFIX;
            }
            int n2 = string.lastIndexOf(46);
            if (n2 < 0) {
                n2 = string.length();
            }
            for (n = 0; n < n2 && Character.isLetter(string.charAt(n)); ++n) {
            }
            this.prefix = string.substring(0, n);
        }
    }

    public String generateFilename(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(this.prefix);
        FilenameFormatter.format10(stringBuilder, n, this.levelFieldSize);
        stringBuilder.append(this.levelSeparator);
        FilenameFormatter.format26(stringBuilder, n2, this.columnFieldSize);
        stringBuilder.append(this.locationSeparator);
        FilenameFormatter.format10(stringBuilder, n3, this.rowFieldSize);
        if (this.suffix != null) {
            stringBuilder.append(this.suffix);
        }
        return stringBuilder.toString();
    }

    public String guessPattern(int n, int n2, int n3, String string) {
        int n4 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = 0;
        block10: while (true) {
            char c;
            boolean bl;
            int n6;
            switch (n5) {
                case 0: {
                    n6 = n3;
                    bl = false;
                    break;
                }
                case 1: {
                    n6 = n2;
                    bl = true;
                    break;
                }
                case 2: {
                    n6 = n;
                    bl = false;
                    break;
                }
                default: {
                    break block10;
                }
            }
            stringBuilder.setLength(0);
            if (bl) {
                FilenameFormatter.format26(stringBuilder, n6, 0);
            } else {
                FilenameFormatter.format10(stringBuilder, n6, 0);
            }
            String string2 = stringBuilder.toString();
            int n7 = string2.length();
            int n8 = string.lastIndexOf(string2, n4 - n7);
            if (n8 < 0) {
                return null;
            }
            int n9 = n8 + n7;
            if (n9 < n4) {
                c = string.charAt(n9);
                if (bl ? Character.isLetter(c) : Character.isDigit(c)) {
                    return null;
                }
            }
            char c2 = c = bl ? (char)'A' : '0';
            while (n8 != 0) {
                char c3 = string.charAt(n8 - 1);
                if (c3 != c) {
                    if (!(bl ? Character.isLetter(c3) : Character.isDigit(c3))) break;
                    return null;
                }
                --n8;
            }
            String string3 = string.substring(n9, n4);
            n7 = n9 - n8;
            switch (n5) {
                case 0: {
                    this.suffix = string3;
                    this.rowFieldSize = n7;
                    break;
                }
                case 1: {
                    this.locationSeparator = string3;
                    this.columnFieldSize = n7;
                    break;
                }
                case 2: {
                    this.levelSeparator = string3;
                    this.levelFieldSize = n7;
                }
            }
            n4 = n8;
            ++n5;
        }
        this.prefix = string.substring(0, n4);
        assert (string.equals(this.generateFilename(n, n2, n3))) : string;
        return this.toString();
    }

    public void applyPattern(String string) throws IllegalArgumentException {
        int n = 0;
        NumberFormatException numberFormatException = null;
        int n2 = 0;
        while (true) {
            int n3;
            String string2;
            switch (n2) {
                case 0: {
                    string2 = "{level:";
                    break;
                }
                case 1: {
                    string2 = "{column:";
                    break;
                }
                case 2: {
                    string2 = "{row:";
                    break;
                }
                default: {
                    this.suffix = string.substring(n);
                    return;
                }
            }
            int n4 = string.indexOf(string2, n);
            if (n4 < 0) break;
            String string3 = string.substring(n, n4);
            n = string.indexOf(125, n4 += string2.length());
            if (n < 0) break;
            try {
                n3 = Integer.parseInt(string.substring(n4, n));
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
                break;
            }
            ++n;
            switch (n2) {
                case 0: {
                    this.prefix = string3;
                    this.levelFieldSize = n3;
                    break;
                }
                case 1: {
                    this.levelSeparator = string3;
                    this.columnFieldSize = n3;
                    break;
                }
                case 2: {
                    this.locationSeparator = string3;
                    this.rowFieldSize = n3;
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"pattern", (Object)string), numberFormatException);
    }

    public String toString() {
        return (this.prefix != null ? this.prefix : DEFAULT_PREFIX) + "{level:" + this.levelFieldSize + '}' + this.levelSeparator + "{column:" + this.columnFieldSize + '}' + this.locationSeparator + "{row:" + this.rowFieldSize + '}' + this.suffix;
    }
}

