/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.geotoolkit.image.io.UnsupportedImageFormatException;
import org.geotoolkit.image.io.mosaic.MosaicImageReader;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.internal.image.io.RawFile;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;

final class CachingMosaicReader
extends MosaicImageReader {
    private final Map<Tile, RawFile> temporaryFiles;
    private ImageReader reader;

    public CachingMosaicReader(Map<Tile, RawFile> map, Object object) {
        this.temporaryFiles = map;
        this.setInput(object);
    }

    @Override
    ImageReader getTileReader(Tile tile) throws IOException {
        RawFile rawFile = this.temporaryFiles.get(tile);
        if (rawFile == null) {
            return super.getTileReader(tile);
        }
        if (this.reader == null) {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("raw");
            while (iterator.hasNext()) {
                this.reader = iterator.next();
                if (this.reader.getClass().getName().startsWith("org.geotoolkit.")) continue;
            }
            if (this.reader == null) {
                throw new UnsupportedImageFormatException(Errors.format((int)158));
            }
        }
        IOUtilities.close((Object)this.reader.getInput());
        this.reader.setInput(rawFile.getImageInputStream());
        return this.reader;
    }

    @Override
    public void dispose() {
        if (this.reader != null) {
            try {
                IOUtilities.close((Object)this.reader.getInput());
            }
            catch (IOException iOException) {
                Logging.unexpectedException((Logger)Tile.LOGGER, Tile.class, (String)"close", (Throwable)iOException);
            }
            this.reader.dispose();
            this.reader = null;
        }
        super.dispose();
    }
}

