/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.swing.tree.TreeNode;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.IIONode;
import org.geotoolkit.image.io.metadata.MetadataNodeParser;
import org.geotoolkit.image.io.metadata.MetadataProxy;
import org.geotoolkit.image.io.metadata.ReferencingBuilder;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.measure.RangeFormat;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.logging.LoggedFormat;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Node;

public class SpatialMetadata
extends IIOMetadata
implements WarningProducer {
    private static final int MAIN = 0;
    private static final int ISO = 1;
    private static final int FALLBACK = 2;
    public static final SpatialMetadata EMPTY = new SpatialMetadata();
    public final IIOMetadataFormat format;
    private final Object owner;
    final IIOMetadata fallback;
    private Node root;
    private Node rootISO;
    private transient Map<Class<?>, Object> instances;
    private transient Map<Class<?>, List<?>> lists;
    private transient LoggedFormat<Date> dateFormat;
    private transient LoggedFormat<NumberRange<?>> rangeFormat;
    private Level warningLevel;
    private boolean isReadOnly;

    private SpatialMetadata() {
        this.format = null;
        this.owner = null;
        this.fallback = null;
        this.isReadOnly = true;
    }

    public SpatialMetadata(IIOMetadataFormat iIOMetadataFormat) {
        this(iIOMetadataFormat, false, null, null, null);
    }

    public SpatialMetadata(IIOMetadataFormat iIOMetadataFormat, ImageReader imageReader, IIOMetadata iIOMetadata) {
        this(iIOMetadataFormat, false, imageReader, null, iIOMetadata);
    }

    public SpatialMetadata(boolean bl, ImageReader imageReader, IIOMetadata iIOMetadata) {
        this(bl ? SpatialMetadataFormat.getStreamInstance("geotk-coverageio_3.07") : SpatialMetadataFormat.getImageInstance("geotk-coverageio_3.07"), bl, imageReader, imageReader != null ? imageReader.getOriginatingProvider() : null, iIOMetadata);
    }

    public SpatialMetadata(IIOMetadataFormat iIOMetadataFormat, ImageWriter imageWriter, IIOMetadata iIOMetadata) {
        this(iIOMetadataFormat, false, imageWriter, null, iIOMetadata);
    }

    public SpatialMetadata(boolean bl, ImageWriter imageWriter, IIOMetadata iIOMetadata) {
        this(bl ? SpatialMetadataFormat.getStreamInstance("geotk-coverageio_3.07") : SpatialMetadataFormat.getImageInstance("geotk-coverageio_3.07"), bl, imageWriter, imageWriter != null ? imageWriter.getOriginatingProvider() : null, iIOMetadata);
    }

    private SpatialMetadata(IIOMetadataFormat iIOMetadataFormat, boolean bl, Object object, ImageReaderWriterSpi imageReaderWriterSpi, IIOMetadata iIOMetadata) {
        String string;
        ArgumentChecks.ensureNonNull((String)"format", (Object)iIOMetadataFormat);
        this.format = iIOMetadataFormat;
        this.owner = object;
        this.fallback = iIOMetadata;
        if (imageReaderWriterSpi != null) {
            if (bl) {
                this.standardFormatSupported = imageReaderWriterSpi.isStandardStreamMetadataFormatSupported();
                this.nativeMetadataFormatName = imageReaderWriterSpi.getNativeStreamMetadataFormatName();
                this.extraMetadataFormatNames = imageReaderWriterSpi.getExtraStreamMetadataFormatNames();
            } else {
                this.standardFormatSupported = imageReaderWriterSpi.isStandardImageMetadataFormatSupported();
                this.nativeMetadataFormatName = imageReaderWriterSpi.getNativeImageMetadataFormatName();
                this.extraMetadataFormatNames = imageReaderWriterSpi.getExtraImageMetadataFormatNames();
            }
        }
        if (iIOMetadata != null) {
            if (!this.standardFormatSupported) {
                this.standardFormatSupported = iIOMetadata.isStandardMetadataFormatSupported();
            }
            if (this.nativeMetadataFormatName == null) {
                this.nativeMetadataFormatName = iIOMetadata.getNativeMetadataFormatName();
            }
            this.extraMetadataFormatNames = (String[])ArraysExt.concatenate((Object[][])new String[][]{this.extraMetadataFormatNames, iIOMetadata.getExtraMetadataFormatNames()});
            this.extraMetadataFormatNames = (String[])ArraysExt.resize((Object[])this.extraMetadataFormatNames, (int)ArraysExt.removeDuplicated((Object[])this.extraMetadataFormatNames));
        }
        if (!this.isSupportedFormat(string = iIOMetadataFormat.getRootName())) {
            if (this.nativeMetadataFormatName == null) {
                this.nativeMetadataFormatName = string;
            } else {
                this.extraMetadataFormatNames = this.extraMetadataFormatNames == null ? new String[]{string} : (String[])ArraysExt.append((Object[])this.extraMetadataFormatNames, (Object)string);
            }
        }
    }

    public <T> T getInstanceForType(Class<T> clazz) throws IllegalArgumentException {
        Object object;
        if (this.instances == null) {
            this.instances = new HashMap();
        }
        if ((object = this.instances.get(clazz)) == null) {
            if (CoordinateReferenceSystem.class.isAssignableFrom(clazz)) {
                ReferencingBuilder referencingBuilder;
                try {
                    referencingBuilder = new ReferencingBuilder(new MetadataNodeParser(this, "geotk-coverageio_3.07", "RectifiedGridDomain/CoordinateReferenceSystem", null));
                }
                catch (NoSuchElementException noSuchElementException) {
                    return null;
                }
                object = clazz.cast(referencingBuilder.build());
            } else {
                MetadataNodeParser metadataNodeParser;
                try {
                    metadataNodeParser = new MetadataNodeParser(this, this.getMetadataFormatName(clazz), clazz);
                }
                catch (NoSuchElementException noSuchElementException) {
                    return null;
                }
                object = this.getInstanceForType(clazz, metadataNodeParser);
            }
            this.instances.put(clazz, object);
        }
        return (T)object;
    }

    public <T> T getInstanceForType(Class<T> clazz, String string) throws IllegalArgumentException {
        MetadataNodeParser metadataNodeParser;
        boolean bl = CoordinateReferenceSystem.class.isAssignableFrom(clazz);
        try {
            metadataNodeParser = new MetadataNodeParser(this, this.getMetadataFormatName(clazz), string, bl ? null : "#auto");
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        if (bl) {
            return clazz.cast(new ReferencingBuilder(metadataNodeParser).build());
        }
        return this.getInstanceForType(clazz, metadataNodeParser);
    }

    private <T> T getInstanceForType(Class<T> clazz, MetadataNodeParser metadataNodeParser) {
        T t;
        if (metadataNodeParser.allowsChildren()) {
            List<T> list = this.getListForType(clazz);
            if (list.isEmpty()) {
                return null;
            }
            t = list.get(0);
        } else {
            t = metadataNodeParser.getUserObject(clazz);
            if (t == null) {
                t = metadataNodeParser.newProxyInstance(clazz);
            }
        }
        return t;
    }

    public <T> List<T> getListForType(Class<T> clazz) throws IllegalArgumentException {
        List<Object> list;
        if (this.lists == null) {
            this.lists = new HashMap();
        }
        if ((list = this.lists.get(clazz)) == null) {
            MetadataNodeParser metadataNodeParser;
            try {
                metadataNodeParser = new MetadataNodeParser(this, this.getMetadataFormatName(clazz), clazz);
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
            list = metadataNodeParser.newProxyList(clazz);
            this.lists.put(clazz, list);
        }
        return list;
    }

    public <T> List<T> getListForType(Class<T> clazz, String string, String string2) throws IllegalArgumentException {
        MetadataNodeParser metadataNodeParser;
        try {
            metadataNodeParser = new MetadataNodeParser(this, this.getMetadataFormatName(clazz), string, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        return metadataNodeParser.newProxyList(clazz);
    }

    private String getMetadataFormatName(Class<?> clazz) {
        String[] stringArray;
        String string;
        String string2;
        if (Metadata.class.isAssignableFrom(clazz)) {
            string2 = "ISO-19115_3.0";
            string = "geotk-coverageio_3.07";
        } else {
            string2 = "geotk-coverageio_3.07";
            string = "ISO-19115_3.0";
        }
        String string3 = this.nativeMetadataFormatName;
        if (!string2.equalsIgnoreCase(string3) && (stringArray = this.extraMetadataFormatNames) != null) {
            for (String string4 : stringArray) {
                if (string2.equalsIgnoreCase(string4)) {
                    return string4;
                }
                if (!string.equalsIgnoreCase(string4)) continue;
                string3 = string4;
            }
        }
        return string3;
    }

    private boolean isSupportedFormat(String string) {
        return string.equals(this.nativeMetadataFormatName) || ArraysExt.contains((Object[])this.extraMetadataFormatNames, (Object)string);
    }

    private int getFormatCode(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"formatName", (Object)string);
        if (this.format == null) {
            throw new IllegalStateException(this.getErrorResources().getString(250));
        }
        if (this.format.getRootName().equalsIgnoreCase(string)) {
            return 0;
        }
        if ("ISO-19115_3.0".equalsIgnoreCase(string) && this.isSupportedFormat("ISO-19115_3.0")) {
            return 1;
        }
        if (this.fallback != null) {
            return 2;
        }
        throw new IllegalArgumentException(this.getErrorResources().getString(73, (Object)"formatName", (Object)string));
    }

    @Override
    public IIOMetadataFormat getMetadataFormat(String string) throws IllegalArgumentException {
        switch (this.getFormatCode(string)) {
            case 0: {
                return this.format;
            }
            case 1: {
                return SpatialMetadataFormat.getStreamInstance("ISO-19115_3.0");
            }
        }
        return this.fallback.getMetadataFormat(string);
    }

    final Node getAsTree() {
        if (this.format == null) {
            throw new UnsupportedOperationException();
        }
        if (this.root == null) {
            this.root = new IIONode(this.format.getRootName());
        }
        return this.root;
    }

    @Override
    public Node getAsTree(String string) throws IllegalArgumentException {
        switch (this.getFormatCode(string)) {
            case 0: {
                return this.getAsTree();
            }
            case 1: {
                return this.rootISO;
            }
        }
        return this.fallback.getAsTree(string);
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(this.getErrorResources().getString(230));
        }
        switch (this.getFormatCode(string)) {
            case 0: {
                this.root = node;
                break;
            }
            case 1: {
                this.rootISO = node;
                break;
            }
            default: {
                this.fallback.mergeTree(string, node);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public Locale getLocale() {
        if (this.owner instanceof ImageReader) {
            return ((ImageReader)this.owner).getLocale();
        }
        if (this.owner instanceof ImageWriter) {
            return ((ImageWriter)this.owner).getLocale();
        }
        return null;
    }

    private IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    public Level getWarningLevel() {
        if (this.warningLevel == null) {
            this.warningLevel = Level.WARNING;
        }
        return this.warningLevel;
    }

    public void setWarningLevel(Level level) {
        ArgumentChecks.ensureNonNull((String)"level", (Object)level);
        this.warningLevel = level;
        if (this.instances != null) {
            MetadataProxy.setWarningLevel(this.instances.values(), level);
        }
        if (this.lists != null) {
            MetadataProxy.setWarningLevel(this.lists.values(), level);
        }
        if (this.dateFormat != null) {
            this.dateFormat.setLevel(level);
        }
        if (this.rangeFormat != null) {
            this.rangeFormat.setLevel(level);
        }
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        return Warnings.log(this.owner, logRecord);
    }

    protected <T> LoggedFormat<T> createLoggedFormat(Format format, Class<T> clazz) {
        return new FormatAdapter<T>(format, clazz);
    }

    private <T> LoggedFormat<T> createLoggedFormat(Class<T> clazz, String string) {
        LoggedFormat<T> loggedFormat = this.createLoggedFormat(SpatialMetadata.createFormat(clazz), clazz);
        loggedFormat.setLogger("org.geotoolkit.image.io.metadata");
        loggedFormat.setCaller(MetadataNodeParser.class, string);
        return loggedFormat;
    }

    private static Format createFormat(Class<?> clazz) {
        if (Date.class.isAssignableFrom(clazz)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CANADA);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat;
        }
        if (NumberRange.class.isAssignableFrom(clazz)) {
            RangeFormat rangeFormat = new RangeFormat(Locale.CANADA);
            rangeFormat.setElementPattern("0.######", false);
            return rangeFormat;
        }
        throw new IllegalArgumentException(String.valueOf(clazz));
    }

    static <T> T parse(Class<T> clazz, String string) throws ParseException {
        return clazz.cast(SpatialMetadata.createFormat(clazz).parseObject(string));
    }

    static <T> String format(Class<T> clazz, T t) {
        return SpatialMetadata.createFormat(clazz).format(t);
    }

    final LoggedFormat<Date> dateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.createLoggedFormat(Date.class, "getAttributeAsDate");
        }
        return this.dateFormat;
    }

    final LoggedFormat<NumberRange<?>> rangeFormat() {
        if (this.rangeFormat == null) {
            this.rangeFormat = this.createLoggedFormat(NumberRange.class, "getAttributeAsRange");
        }
        return this.rangeFormat;
    }

    @Override
    public void reset() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(this.getErrorResources().getString(230));
        }
        this.root = null;
        if (this.fallback != null) {
            this.fallback.reset();
        }
    }

    public String toString() {
        if (this.format == null) {
            return "EMPTY";
        }
        return Trees.toString((TreeNode)Trees.xmlToSwing((Node)this.getAsTree(this.format.getRootName())));
    }

    private final class FormatAdapter<T>
    extends LoggedFormat<T> {
        private static final long serialVersionUID = -1108933164506428318L;

        FormatAdapter(Format format, Class<T> clazz) {
            super(format, clazz);
        }

        protected Locale getWarningLocale() {
            return SpatialMetadata.this.getLocale();
        }

        protected void logWarning(LogRecord logRecord) {
            SpatialMetadata.this.warningOccurred(logRecord);
        }
    }
}

