/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOMetadata;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.image.io.metadata.MetadataNodeAccessor;
import org.geotoolkit.image.io.metadata.MetadataNodeParser;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.image.io.DataTypes;
import org.geotoolkit.lang.Builder;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public class ReferencingBuilder
extends Builder<CoordinateReferenceSystem> {
    static final String PATH = "RectifiedGridDomain/CoordinateReferenceSystem";
    private static final double EPS = 1.0E-10;
    private static final boolean OMMIT_DEFAULTS = true;
    private transient ReferencingFactoryContainer factories;
    private final MetadataNodeParser accessor;
    private boolean ignoreUserObject;

    public ReferencingBuilder(IIOMetadata iIOMetadata) throws NoSuchElementException {
        this(new MetadataNodeAccessor(iIOMetadata, "geotk-coverageio_3.07", PATH, null));
    }

    public ReferencingBuilder(MetadataNodeParser metadataNodeParser) {
        this.accessor = metadataNodeParser;
    }

    private ReferencingFactoryContainer factories() {
        if (this.factories == null) {
            this.factories = ReferencingFactoryContainer.instance(null);
        }
        return this.factories;
    }

    private <T extends IdentifiedObject> T getUserObject(MetadataNodeParser metadataNodeParser, Class<T> clazz) {
        return (T)(!this.ignoreUserObject ? (IdentifiedObject)metadataNodeParser.getUserObject(clazz) : null);
    }

    private void setUserObject(MetadataNodeAccessor metadataNodeAccessor, IdentifiedObject identifiedObject) {
        if (!this.ignoreUserObject) {
            try {
                metadataNodeAccessor.setUserObject(identifiedObject);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logging.recoverableException((Logger)MetadataNodeAccessor.LOGGER, ReferencingBuilder.class, (String)"setUserObject", (Throwable)unsupportedOperationException);
            }
        }
    }

    public boolean getIgnoreUserObject() {
        return this.ignoreUserObject;
    }

    public void setIgnoreUserObject(boolean bl) {
        this.ignoreUserObject = bl;
    }

    public CoordinateReferenceSystem build() {
        Throwable throwable;
        try {
            return this.getCoordinateReferenceSystem(CoordinateReferenceSystem.class);
        }
        catch (FactoryException factoryException) {
            throwable = factoryException;
        }
        catch (NoSuchElementException noSuchElementException) {
            throwable = noSuchElementException;
        }
        catch (NullArgumentException nullArgumentException) {
            throwable = nullArgumentException;
        }
        this.accessor.warning(null, ((Object)((Object)this)).getClass(), "build", (Exception)throwable);
        return null;
    }

    public <T extends CoordinateReferenceSystem> T getCoordinateReferenceSystem(Class<T> clazz) throws FactoryException {
        Class<T> clazz2;
        CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)this.getUserObject(this.accessor, clazz);
        if (coordinateReferenceSystem != null) {
            return (T)coordinateReferenceSystem;
        }
        if (!this.accessor.isEmpty() && (clazz2 = this.getInterface("getCoordinateReferenceSystem", clazz, this.accessor)) != null) {
            Map<String, Object> map = ReferencingBuilder.getName(this.accessor);
            CRSFactory cRSFactory = this.factories().getCRSFactory();
            if (GeographicCRS.class.isAssignableFrom(clazz2)) {
                return (T)((CoordinateReferenceSystem)clazz.cast(cRSFactory.createGeographicCRS(map, this.getDatum(GeodeticDatum.class), this.getCoordinateSystem(EllipsoidalCS.class))));
            }
            if (ProjectedCRS.class.isAssignableFrom(clazz2)) {
                GeographicCRS geographicCRS = cRSFactory.createGeographicCRS(Collections.singletonMap("name", ReferencingBuilder.untitled(this.accessor)), this.getDatum(GeodeticDatum.class), (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
                CartesianCS cartesianCS = this.getCoordinateSystem(CartesianCS.class);
                return (T)((CoordinateReferenceSystem)clazz.cast(cRSFactory.createProjectedCRS(map, geographicCRS, this.getConversionFromBase((CoordinateReferenceSystem)geographicCRS, (CoordinateSystem)cartesianCS), cartesianCS)));
            }
            this.warning("getCoordinateReferenceSystem", 226, clazz2);
        }
        return (T)((CoordinateReferenceSystem)this.getDefault("getCoordinateReferenceSystem", this.accessor, clazz));
    }

    private Conversion getConversionFromBase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateSystem coordinateSystem) throws FactoryException {
        MetadataNodeParser metadataNodeParser = this.createNodeReader(this.accessor, "Conversion", null);
        String string = metadataNodeParser.getAttribute("method");
        if (this.isNonNull("getBaseToCRS", "method", string)) {
            MetadataNodeParser metadataNodeParser2;
            Map<String, Object> map = ReferencingBuilder.getName(metadataNodeParser);
            MathTransformFactory mathTransformFactory = this.factories().getMathTransformFactory();
            ParameterValueGroup parameterValueGroup = mathTransformFactory.getDefaultParameters(string);
            try {
                metadataNodeParser2 = this.createNodeReader(metadataNodeParser, "Parameters", "ParameterValue");
                int n = metadataNodeParser2.childCount();
                for (int i = 0; i < n; ++i) {
                    Double d;
                    metadataNodeParser2.selectChild(i);
                    String string2 = metadataNodeParser2.getAttribute("name");
                    if (!this.isNonNull("getBaseToCRS", "name", string2) || !this.isNonNull("getBaseToCRS", "value", d = metadataNodeParser2.getAttributeAsDouble("value"))) continue;
                    try {
                        parameterValueGroup.parameter(string2).setValue(d.doubleValue());
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        metadataNodeParser2.warning(null, ((Object)((Object)this)).getClass(), "getBaseToCRS", illegalArgumentException);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.accessor.warning(null, ((Object)((Object)this)).getClass(), "getConversionFromBase", noSuchElementException);
            }
            metadataNodeParser2 = mathTransformFactory.createBaseToDerived(coordinateReferenceSystem, parameterValueGroup, coordinateSystem);
            return new DefiningConversion(map, mathTransformFactory.getLastMethodUsed(), (MathTransform)metadataNodeParser2);
        }
        return this.getDefault("getBaseToCRS", metadataNodeParser, Conversion.class);
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem;
        MetadataNodeAccessor metadataNodeAccessor;
        try {
            metadataNodeAccessor = (MetadataNodeAccessor)this.accessor;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException(this.accessor.getErrorResources().getString(230), classCastException);
        }
        ReferencingBuilder.setName((IdentifiedObject)coordinateReferenceSystem, metadataNodeAccessor);
        metadataNodeAccessor.setAttribute("type", DataTypes.getType(coordinateReferenceSystem));
        Datum datum = CRS.getDatum((CoordinateReferenceSystem)coordinateReferenceSystem);
        if (datum != null) {
            this.setDatum(datum);
        }
        if ((coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            this.setCoordinateSystem(coordinateSystem);
        }
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            Conversion conversion = ((GeneralDerivedCRS)coordinateReferenceSystem).getConversionFromBase();
            MetadataNodeAccessor metadataNodeAccessor2 = this.createNodeWriter(metadataNodeAccessor, "Conversion", null);
            ReferencingBuilder.setName((IdentifiedObject)conversion, metadataNodeAccessor2);
            ReferencingBuilder.setName((IdentifiedObject)conversion.getMethod(), false, metadataNodeAccessor2, "method");
            this.addParameter(new MetadataNodeAccessor[]{metadataNodeAccessor2, null}, (GeneralParameterValue)conversion.getParameterValues(), CRS.getEllipsoid((CoordinateReferenceSystem)coordinateReferenceSystem));
        }
        this.setUserObject(metadataNodeAccessor, (IdentifiedObject)coordinateReferenceSystem);
    }

    private void addParameter(MetadataNodeAccessor[] metadataNodeAccessorArray, GeneralParameterValue generalParameterValue, Ellipsoid ellipsoid) {
        Object object;
        ParameterValue parameterValue;
        if (generalParameterValue instanceof ParameterValueGroup) {
            parameterValue = ((ParameterValueGroup)generalParameterValue).values().iterator();
            while (parameterValue.hasNext()) {
                object = (GeneralParameterValue)parameterValue.next();
                this.addParameter(metadataNodeAccessorArray, (GeneralParameterValue)object, ellipsoid);
            }
        }
        if (generalParameterValue instanceof ParameterValue && (object = (parameterValue = (ParameterValue)generalParameterValue).getValue()) != null) {
            MetadataNodeAccessor metadataNodeAccessor;
            ParameterDescriptor parameterDescriptor = parameterValue.getDescriptor();
            String string = parameterDescriptor.getName().getCode().trim();
            if (object instanceof Number) {
                double d;
                double d2 = ((Number)object).doubleValue();
                if (ellipsoid != null && (string.equalsIgnoreCase("semi_major") ? ReferencingBuilder.equals(d2, ellipsoid.getSemiMajorAxis()) : string.equalsIgnoreCase("semi_minor") && ReferencingBuilder.equals(d2, ellipsoid.getSemiMinorAxis()))) {
                    return;
                }
                Object object2 = parameterDescriptor.getDefaultValue();
                if (object2 instanceof Number && ReferencingBuilder.equals(d2, d = ((Number)object2).doubleValue()) && d == (double)(string.equalsIgnoreCase("scale_factor") ? 1 : 0)) {
                    return;
                }
            }
            if ((metadataNodeAccessor = metadataNodeAccessorArray[1]) == null) {
                metadataNodeAccessorArray[1] = metadataNodeAccessor = this.createNodeWriter(metadataNodeAccessorArray[0], "Parameters", "ParameterValue");
            }
            metadataNodeAccessor.selectChild(metadataNodeAccessor.appendChild());
            metadataNodeAccessor.setAttribute("name", string);
            metadataNodeAccessor.setAttribute("value", object.toString());
        }
    }

    public <T extends CoordinateSystem> T getCoordinateSystem(Class<T> clazz) throws FactoryException {
        MetadataNodeParser metadataNodeParser;
        block15: {
            Class<T> clazz2;
            block16: {
                metadataNodeParser = this.createNodeReader(this.accessor, "CoordinateSystem", null);
                CoordinateSystem coordinateSystem = (CoordinateSystem)this.getUserObject(metadataNodeParser, clazz);
                if (coordinateSystem != null) {
                    return (T)coordinateSystem;
                }
                clazz2 = this.getInterface("getCoordinateSystem", clazz, metadataNodeParser);
                if (clazz2 == null) break block15;
                Map<String, Object> map = ReferencingBuilder.getName(metadataNodeParser);
                Integer n = metadataNodeParser.getAttributeAsInteger("dimension");
                MetadataNodeParser metadataNodeParser2 = this.createNodeReader(metadataNodeParser, "Axes", "CoordinateSystemAxis");
                int n2 = metadataNodeParser2.childCount();
                if (n != null && n != n2) {
                    this.warning("getCoordinateSystem", 113, new Object[]{"Axes", n2, n});
                }
                CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n2];
                CSFactory cSFactory = this.factories().getCSFactory();
                for (int i = 0; i < n2; ++i) {
                    Unit unit;
                    metadataNodeParser2.selectChild(i);
                    Map<String, Object> map2 = ReferencingBuilder.getName(metadataNodeParser2);
                    String string = metadataNodeParser2.getAttribute("axisAbbrev");
                    AxisDirection axisDirection = metadataNodeParser2.getAttributeAsCode("direction", AxisDirection.class);
                    if (!this.isNonNull("getCoordinateSystem", "direction", axisDirection)) {
                        return null;
                    }
                    if (string == null) {
                        string = map2.get("name").toString();
                        if (string == null) {
                            string = Types.getCodeName((CodeList)axisDirection);
                        }
                        string = Strings.camelCaseToAcronym((String)string);
                    }
                    if (!this.isNonNull("getCoordinateSystem", "unit", unit = metadataNodeParser2.getAttributeAsUnit("unit", null))) {
                        return null;
                    }
                    coordinateSystemAxisArray[i] = cSFactory.createCoordinateSystemAxis(map2, string, axisDirection, unit);
                }
                Boolean bl = null;
                if (EllipsoidalCS.class.isAssignableFrom(clazz2)) {
                    bl = Boolean.TRUE;
                } else if (CartesianCS.class.isAssignableFrom(clazz2)) {
                    bl = Boolean.FALSE;
                }
                if (bl == null) break block16;
                switch (n2) {
                    case 0: 
                    case 1: {
                        this.warning("getCoordinateSystem", 150, n2);
                        break block15;
                    }
                    case 2: {
                        return (T)((CoordinateSystem)clazz.cast(bl != false ? cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]) : cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1])));
                    }
                    default: {
                        this.warning("getCoordinateSystem", 207, clazz2);
                    }
                    case 3: {
                        return (T)((CoordinateSystem)clazz.cast(bl != false ? cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]) : cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2])));
                    }
                }
            }
            this.warning("getCoordinateSystem", 226, clazz2);
        }
        return (T)((CoordinateSystem)this.getDefault("getCoordinateSystem", metadataNodeParser, clazz));
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        MetadataNodeAccessor metadataNodeAccessor = this.createNodeWriter(this.accessor, "CoordinateSystem", null);
        ReferencingBuilder.setName((IdentifiedObject)coordinateSystem, metadataNodeAccessor);
        metadataNodeAccessor.setAttribute("type", DataTypes.getType(coordinateSystem));
        int n = coordinateSystem.getDimension();
        metadataNodeAccessor.setAttribute("dimension", n);
        MetadataNodeAccessor metadataNodeAccessor2 = this.createNodeWriter(metadataNodeAccessor, "Axes", "CoordinateSystemAxis");
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            metadataNodeAccessor2.selectChild(metadataNodeAccessor2.appendChild());
            ReferencingBuilder.setName((IdentifiedObject)coordinateSystemAxis, metadataNodeAccessor2);
            String string = coordinateSystemAxis.getAbbreviation();
            if (!string.equals(coordinateSystemAxis.getName().getCode())) {
                metadataNodeAccessor2.setAttribute("axisAbbrev", string);
            }
            metadataNodeAccessor2.setAttribute("direction", (CodeList<?>)coordinateSystemAxis.getDirection());
            boolean bl = false;
            double d = coordinateSystemAxis.getMinimumValue();
            if (d > Double.NEGATIVE_INFINITY) {
                metadataNodeAccessor2.setAttribute("minimumValue", d);
                bl = true;
            }
            if ((d = coordinateSystemAxis.getMaximumValue()) < Double.POSITIVE_INFINITY) {
                metadataNodeAccessor2.setAttribute("maximumValue", d);
                bl = true;
            }
            if (bl) {
                metadataNodeAccessor2.setAttribute("rangeMeaning", (CodeList<?>)coordinateSystemAxis.getRangeMeaning());
            }
            metadataNodeAccessor2.setAttribute("unit", coordinateSystemAxis.getUnit());
            this.setUserObject(metadataNodeAccessor2, (IdentifiedObject)coordinateSystemAxis);
        }
        this.setUserObject(metadataNodeAccessor, (IdentifiedObject)coordinateSystem);
    }

    public <T extends Datum> T getDatum(Class<T> clazz) throws FactoryException {
        MetadataNodeParser metadataNodeParser = this.createNodeReader(this.accessor, "Datum", null);
        Datum datum = (Datum)this.getUserObject(metadataNodeParser, clazz);
        if (datum != null) {
            return (T)datum;
        }
        Class<T> clazz2 = this.getInterface("getDatum", clazz, metadataNodeParser);
        if (clazz2 != null) {
            Map<String, Object> map = ReferencingBuilder.getName(metadataNodeParser);
            DatumFactory datumFactory = this.factories().getDatumFactory();
            if (GeodeticDatum.class.isAssignableFrom(clazz2)) {
                Ellipsoid ellipsoid = this.getEllipsoid(metadataNodeParser);
                PrimeMeridian primeMeridian = this.getPrimeMeridian(metadataNodeParser);
                return (T)((Datum)clazz.cast(datumFactory.createGeodeticDatum(map, ellipsoid, primeMeridian)));
            }
            if (EngineeringDatum.class.isAssignableFrom(clazz2)) {
                return (T)((Datum)clazz.cast(datumFactory.createEngineeringDatum(map)));
            }
            this.warning("getDatum", 226, clazz2);
        }
        return (T)((Datum)this.getDefault("getDatum", metadataNodeParser, clazz));
    }

    public void setDatum(Datum datum) {
        MetadataNodeAccessor metadataNodeAccessor = this.createNodeWriter(this.accessor, "Datum", null);
        ReferencingBuilder.setName((IdentifiedObject)datum, metadataNodeAccessor);
        metadataNodeAccessor.setAttribute("type", DataTypes.getType(datum));
        if (datum instanceof GeodeticDatum) {
            Object object;
            GeodeticDatum geodeticDatum = (GeodeticDatum)datum;
            Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
            if (ellipsoid != null) {
                object = this.createNodeWriter(metadataNodeAccessor, "Ellipsoid", null);
                ReferencingBuilder.setName((IdentifiedObject)ellipsoid, (MetadataNodeAccessor)object);
                ((MetadataNodeAccessor)object).setAttribute("axisUnit", ellipsoid.getAxisUnit());
                ((MetadataNodeAccessor)object).setAttribute("semiMajorAxis", ellipsoid.getSemiMajorAxis());
                if (ellipsoid.isIvfDefinitive()) {
                    ((MetadataNodeAccessor)object).setAttribute("inverseFlattening", ellipsoid.getInverseFlattening());
                } else {
                    ((MetadataNodeAccessor)object).setAttribute("semiMinorAxis", ellipsoid.getSemiMinorAxis());
                }
                this.setUserObject((MetadataNodeAccessor)object, (IdentifiedObject)ellipsoid);
            }
            if ((object = geodeticDatum.getPrimeMeridian()) != null) {
                MetadataNodeAccessor metadataNodeAccessor2 = this.createNodeWriter(metadataNodeAccessor, "PrimeMeridian", null);
                ReferencingBuilder.setName((IdentifiedObject)object, metadataNodeAccessor2);
                metadataNodeAccessor2.setAttribute("greenwichLongitude", object.getGreenwichLongitude());
                metadataNodeAccessor2.setAttribute("angularUnit", object.getAngularUnit());
                this.setUserObject(metadataNodeAccessor2, (IdentifiedObject)object);
            }
        }
        this.setUserObject(metadataNodeAccessor, (IdentifiedObject)datum);
    }

    protected Ellipsoid getEllipsoid(MetadataNodeParser metadataNodeParser) throws FactoryException {
        MetadataNodeParser metadataNodeParser2 = this.createNodeReader(metadataNodeParser, "Ellipsoid", null);
        Ellipsoid ellipsoid = this.getUserObject(metadataNodeParser2, Ellipsoid.class);
        if (ellipsoid != null) {
            return ellipsoid;
        }
        Unit<Length> unit = metadataNodeParser2.getAttributeAsUnit("axisUnit", Length.class);
        if (this.isNonNull("getEllipsoid", "axisUnit", unit)) {
            Map<String, Object> map = ReferencingBuilder.getName(metadataNodeParser2);
            Double d = metadataNodeParser2.getAttributeAsDouble("semiMajorAxis");
            if (this.isNonNull("getEllipsoid", "semiMajorAxis", d)) {
                DatumFactory datumFactory = this.factories().getDatumFactory();
                Double d2 = metadataNodeParser2.getAttributeAsDouble("semiMinorAxis");
                if (d2 != null) {
                    return datumFactory.createEllipsoid(map, d.doubleValue(), d2.doubleValue(), unit);
                }
                Double d3 = metadataNodeParser2.getAttributeAsDouble("inverseFlattening");
                if (this.isNonNull("getEllipsoid", "inverseFlattening", d3)) {
                    return datumFactory.createFlattenedSphere(map, d.doubleValue(), d3.doubleValue(), unit);
                }
            }
        }
        return this.getDefault("getEllipsoid", metadataNodeParser2, Ellipsoid.class);
    }

    protected PrimeMeridian getPrimeMeridian(MetadataNodeParser metadataNodeParser) throws FactoryException {
        MetadataNodeParser metadataNodeParser2 = this.createNodeReader(metadataNodeParser, "PrimeMeridian", null);
        PrimeMeridian primeMeridian = this.getUserObject(metadataNodeParser2, PrimeMeridian.class);
        if (primeMeridian != null) {
            return primeMeridian;
        }
        Double d = metadataNodeParser2.getAttributeAsDouble("greenwichLongitude");
        if (this.isNonNull("getEllipsoid", "greenwichLongitude", d)) {
            Map<String, Object> map = ReferencingBuilder.getName(metadataNodeParser2);
            Unit<Angle> unit = metadataNodeParser2.getAttributeAsUnit("angularUnit", Angle.class);
            if (this.isNonNull("getPrimeMeridian", "angularUnit", unit)) {
                DatumFactory datumFactory = this.factories().getDatumFactory();
                return datumFactory.createPrimeMeridian(map, d.doubleValue(), unit);
            }
        }
        return this.getDefault("getPrimeMeridian", metadataNodeParser2, PrimeMeridian.class);
    }

    protected <T extends IdentifiedObject> T getDefault(Class<T> clazz) throws FactoryException {
        if (!CoordinateReferenceSystem.class.isAssignableFrom(clazz) && this.accessor.format instanceof SpatialMetadataFormat) {
            return (T)((IdentifiedObject)((SpatialMetadataFormat)this.accessor.format).getDefaultValue(clazz));
        }
        return null;
    }

    private <T extends IdentifiedObject> T getDefault(String string, MetadataNodeParser metadataNodeParser, Class<T> clazz) throws FactoryException {
        Object object = this.getDefault(clazz);
        if (object == null) {
            object = (IdentifiedObject)clazz.cast(metadataNodeParser.format.getObjectDefaultValue(metadataNodeParser.name()));
        }
        if (object != null) {
            this.warning(string, (IndexedResourceBundle)Loggings.getResources((Locale)metadataNodeParser.getLocale()), 58, object.getName());
        }
        return object;
    }

    protected MetadataNodeParser createNodeReader(MetadataNodeParser metadataNodeParser, String string, String string2) {
        return new MetadataNodeParser(metadataNodeParser, string, string2);
    }

    protected MetadataNodeAccessor createNodeWriter(MetadataNodeParser metadataNodeParser, String string, String string2) {
        return new MetadataNodeAccessor(metadataNodeParser, string, string2);
    }

    private <T extends IdentifiedObject> Class<? extends T> getInterface(String string, Class<T> clazz, MetadataNodeParser metadataNodeParser) {
        String string2 = metadataNodeParser.getAttribute("type");
        if (string2 == null) {
            if (clazz.equals(Datum.class) || clazz.equals(CoordinateSystem.class)) {
                this.warning(string, 120, "type");
            }
        } else {
            try {
                Class<T> clazz2 = DataTypes.getInterface(clazz, string2);
                if (clazz2 != null) {
                    return clazz2;
                }
                this.warning(string, 226, string2);
            }
            catch (ClassCastException classCastException) {
                this.warning(string, 76, new Object[]{string2, clazz});
            }
        }
        return clazz;
    }

    private static Map<String, Object> getName(MetadataNodeParser metadataNodeParser) {
        String string = metadataNodeParser.getAttribute("name");
        if (string == null) {
            string = ReferencingBuilder.untitled(metadataNodeParser);
        } else {
            int n = string.indexOf(58);
            if (n >= 0) {
                String string2 = string.substring(0, n).trim();
                if ((string = string.substring(n + 1).trim()).isEmpty()) {
                    string = string2;
                } else if (!string2.isEmpty()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(6);
                    hashMap.put("codespace", string2);
                    hashMap.put("code", string);
                    DefaultReferenceIdentifier defaultReferenceIdentifier = new DefaultReferenceIdentifier(hashMap);
                    return Collections.singletonMap("name", defaultReferenceIdentifier);
                }
            }
        }
        return Collections.singletonMap("name", string);
    }

    private static void setName(IdentifiedObject identifiedObject, MetadataNodeAccessor metadataNodeAccessor) {
        ReferencingBuilder.setName(identifiedObject, true, metadataNodeAccessor, "name");
    }

    private static void setName(IdentifiedObject identifiedObject, boolean bl, MetadataNodeAccessor metadataNodeAccessor, String string) {
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (referenceIdentifier != null) {
            String string2;
            String string3 = referenceIdentifier.getCode();
            if (bl && (string2 = Citations.getIdentifier((Citation)referenceIdentifier.getAuthority())) != null) {
                string3 = string2 + ':' + string3;
            }
            metadataNodeAccessor.setAttribute(string, string3);
        }
    }

    private static String untitled(MetadataNodeParser metadataNodeParser) {
        return Vocabulary.getResources((Locale)metadataNodeParser.getLocale()).getString(311);
    }

    private static boolean equals(double d, double d2) {
        return Math.abs(d - d2) <= Math.abs(d2) * 1.0E-10;
    }

    private boolean isNonNull(String string, String string2, Object object) {
        if (object != null) {
            return true;
        }
        this.warning(string, 120, string2);
        return false;
    }

    private void warning(String string, int n, Object object) {
        this.warning(string, (IndexedResourceBundle)Errors.getResources((Locale)this.accessor.getLocale()), n, object);
    }

    private void warning(String string, IndexedResourceBundle indexedResourceBundle, int n, Object object) {
        this.accessor.warning(((Object)((Object)this)).getClass(), string, indexedResourceBundle, n, object);
    }
}

