/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.util.Locale;
import java.util.Set;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.image.io.metadata.MetadataTreeTable;
import org.geotoolkit.image.io.metadata.ValidValues;
import org.geotoolkit.metadata.ValueRestriction;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.logging.Logging;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MetadataTreeNode
extends NamedTreeNode
implements TreeTableNode {
    private static final long serialVersionUID = 3458235875074371134L;
    private final MetadataTreeTable tree;
    private final String element;
    private final String attribute;
    final Node xmlNode;
    final boolean hasValue;
    private transient String label;
    private transient String description;
    private transient Class<?> valueType;
    private transient NumberRange<Integer> occurrences;
    private transient ValueRestriction validValues;
    private transient Object defaultValue;

    MetadataTreeNode(MetadataTreeTable metadataTreeTable, String string, Node node, boolean bl) {
        super((CharSequence)string);
        this.tree = metadataTreeTable;
        this.element = string;
        this.attribute = null;
        this.xmlNode = node;
        this.hasValue = bl;
        this.setAllowsChildren(true);
    }

    MetadataTreeNode(MetadataTreeNode metadataTreeNode, String string) {
        super((CharSequence)string);
        this.tree = metadataTreeNode.tree;
        this.element = metadataTreeNode.element;
        this.attribute = string;
        this.xmlNode = metadataTreeNode.xmlNode;
        this.hasValue = metadataTreeNode.hasValue;
        this.setAllowsChildren(false);
    }

    public final MetadataTreeNode getParent() {
        return (MetadataTreeNode)((Object)super.getParent());
    }

    public final String getName() {
        return super.toString();
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = Strings.camelCaseToSentence((CharSequence)this.getName());
        }
        return this.label;
    }

    public String getDescription() {
        String string = this.description;
        if (string == null) {
            Locale locale = this.tree.getLocale();
            IIOMetadataFormat iIOMetadataFormat = this.tree.format;
            string = this.attribute == null ? iIOMetadataFormat.getElementDescription(this.element, locale) : iIOMetadataFormat.getAttributeDescription(this.element, this.attribute, locale);
            if (string == null) {
                string = "";
            }
            this.description = string;
        }
        return string.isEmpty() ? null : string;
    }

    public NumberRange<Integer> getOccurrences() {
        if (this.occurrences == null) {
            Integer n = 0;
            Integer n2 = 1;
            IIOMetadataFormat iIOMetadataFormat = this.tree.format;
            if (this.attribute == null) {
                if (this.parent != null) {
                    String string = this.getParent().element;
                    switch (iIOMetadataFormat.getChildPolicy(string)) {
                        case 5: {
                            n = iIOMetadataFormat.getElementMinChildren(string);
                            n2 = iIOMetadataFormat.getElementMaxChildren(string);
                            break;
                        }
                        case 1: {
                            n = 1;
                            break;
                        }
                        case 0: {
                            n2 = 0;
                        }
                    }
                }
            } else {
                switch (iIOMetadataFormat.getAttributeValueType(this.element, this.attribute)) {
                    case 32: {
                        n = iIOMetadataFormat.getAttributeListMinLength(this.element, this.attribute);
                        n2 = iIOMetadataFormat.getAttributeListMaxLength(this.element, this.attribute);
                        break;
                    }
                    default: {
                        if (!iIOMetadataFormat.isAttributeRequired(this.element, this.attribute)) break;
                        n = 1;
                    }
                }
            }
            if (n == Integer.MIN_VALUE) {
                n = null;
            }
            if (n2 == Integer.MAX_VALUE) {
                n2 = null;
            }
            this.occurrences = new NumberRange(Integer.class, (Number)n, (Number)n2);
        }
        return this.occurrences;
    }

    public Class<?> getValueType() {
        Class clazz = this.valueType;
        if (clazz == null) {
            clazz = Void.TYPE;
            boolean bl = false;
            IIOMetadataFormat iIOMetadataFormat = this.tree.format;
            if (this.attribute == null) {
                switch (iIOMetadataFormat.getObjectValueType(this.element)) {
                    case 0: {
                        break;
                    }
                    case 32: {
                        bl = true;
                    }
                    default: {
                        clazz = iIOMetadataFormat.getObjectClass(this.element);
                        break;
                    }
                }
            } else {
                switch (iIOMetadataFormat.getAttributeValueType(this.element, this.attribute)) {
                    case 32: {
                        bl = true;
                    }
                }
                switch (iIOMetadataFormat.getAttributeDataType(this.element, this.attribute)) {
                    case 0: {
                        clazz = String.class;
                        break;
                    }
                    case 2: {
                        clazz = Integer.class;
                        break;
                    }
                    case 4: {
                        clazz = Double.class;
                        break;
                    }
                    case 3: {
                        clazz = Float.class;
                        break;
                    }
                    case 1: {
                        clazz = Boolean.class;
                    }
                }
            }
            if (bl) {
                clazz = Classes.changeArrayDimension((Class)Numbers.wrapperToPrimitive(clazz), (int)1);
            }
            this.valueType = clazz;
        }
        return Void.TYPE.equals(clazz) ? null : clazz;
    }

    public ValueRestriction getValueRestriction() {
        ValueRestriction valueRestriction = this.validValues;
        if (valueRestriction == null) {
            valueRestriction = ValidValues.UNRESTRICTED;
            IIOMetadataFormat iIOMetadataFormat = this.tree.format;
            if (this.attribute == null) {
                int n = iIOMetadataFormat.getObjectValueType(this.element);
                switch (n & 0xFFFFFFF3) {
                    case 2: {
                        Class<?> clazz = iIOMetadataFormat.getObjectClass(this.element);
                        valueRestriction = ValidValues.range(clazz, n, iIOMetadataFormat.getObjectMinValue(this.element), iIOMetadataFormat.getObjectMaxValue(this.element));
                        break;
                    }
                    case 16: {
                        valueRestriction = new ValidValues(iIOMetadataFormat.getObjectEnumerations(this.element));
                    }
                }
            } else {
                int n = iIOMetadataFormat.getAttributeValueType(this.element, this.attribute);
                switch (n & 0xFFFFFFF3) {
                    case 2: {
                        int n2 = iIOMetadataFormat.getAttributeDataType(this.element, this.attribute);
                        valueRestriction = ValidValues.range(n2, n, iIOMetadataFormat.getAttributeMinValue(this.element, this.attribute), iIOMetadataFormat.getAttributeMaxValue(this.element, this.attribute));
                        break;
                    }
                    case 16: {
                        valueRestriction = new ValidValues(iIOMetadataFormat.getAttributeEnumerations(this.element, this.attribute));
                    }
                }
            }
            this.validValues = valueRestriction;
        }
        return valueRestriction.equals((Object)ValidValues.UNRESTRICTED) ? null : valueRestriction;
    }

    public Object getDefaultValue() {
        Object object = this.defaultValue;
        if (object == null) {
            IIOMetadataFormat iIOMetadataFormat = this.tree.format;
            if (this.attribute == null) {
                switch (iIOMetadataFormat.getObjectValueType(this.element)) {
                    case 0: {
                        break;
                    }
                    default: {
                        object = iIOMetadataFormat.getObjectDefaultValue(this.element);
                        break;
                    }
                }
            } else {
                object = iIOMetadataFormat.getAttributeDefaultValue(this.element, this.attribute);
            }
            if ((object = this.convert(object)) == null) {
                object = "";
            }
            this.defaultValue = object;
        }
        return object.equals("") ? null : object;
    }

    public Object getUserObject() {
        Object object = super.getUserObject();
        if (object == null) {
            Node node = this.xmlNode;
            if (node != null) {
                if (this.attribute != null) {
                    if (node instanceof Element) {
                        object = ((Element)node).getAttribute(this.attribute);
                    }
                } else {
                    if (node instanceof IIOMetadataNode) {
                        object = ((IIOMetadataNode)node).getUserObject();
                    }
                    if (object == null) {
                        object = node.getNodeValue();
                    }
                }
            }
            if ((object = this.convert(object)) == null) {
                object = "";
            }
            super.setUserObject(object);
        }
        return object.equals("") ? null : object;
    }

    public void setUserObject(Object object) throws IllegalArgumentException {
        Class<?> clazz = this.getValueType();
        if (clazz == null) {
            throw new IllegalArgumentException(this.error(12, object));
        }
        if (object != null) {
            if (!clazz.isInstance(object = this.convert(object))) {
                throw new IllegalArgumentException(this.error(13, object.getClass()));
            }
            ValueRestriction valueRestriction = this.getValueRestriction();
            if (valueRestriction != null) {
                Set set = valueRestriction.validValues;
                if (set != null && !set.contains(object)) {
                    throw new IllegalArgumentException(this.error(12, object));
                }
                NumberRange numberRange = valueRestriction.range;
                if (numberRange != null && !numberRange.contains((Comparable)object)) {
                    throw new IllegalArgumentException(Errors.getResources((Locale)this.tree.getLocale()).getString(246, object, (Object)numberRange.getMinimum(true), (Object)numberRange.getMaximum(true)));
                }
            }
        } else {
            object = "";
        }
        super.setUserObject(object);
    }

    private void setUserObjectUnsafe(Object object) {
        super.setUserObject(object);
    }

    private String error(int n, Object object) {
        return Errors.getResources((Locale)this.tree.getLocale()).getString(n, (Object)this.getLabel(), object);
    }

    private Object convert(Object object) {
        Class<?> clazz;
        if (object != null && (clazz = this.getValueType()) != null) {
            object = this.tree.converters.tryConvert(object, clazz);
        }
        return object;
    }

    final boolean copyToParent(MetadataTreeNode metadataTreeNode) {
        if (this.getUserObject() != null && metadataTreeNode.getUserObject() == null && metadataTreeNode.getValueType() == null && metadataTreeNode.getDefaultValue() == null && metadataTreeNode.getValueRestriction() == null) {
            metadataTreeNode.setUserObjectUnsafe(super.getUserObject());
            if (this.getValueType() != null) {
                metadataTreeNode.valueType = this.valueType;
            }
            if (this.getDefaultValue() != null) {
                metadataTreeNode.defaultValue = this.defaultValue;
            }
            if (this.getValueRestriction() != null) {
                metadataTreeNode.validValues = this.validValues;
            }
            if (this.getDescription() != null && metadataTreeNode.getDescription() == null) {
                metadataTreeNode.description = this.description;
            }
            return true;
        }
        return false;
    }

    private int canonical(int n) {
        if (!this.hasValue && n >= 4) {
            ++n;
        }
        return n;
    }

    public int getColumnCount() {
        return this.hasValue ? 7 : 6;
    }

    public Class<?> getColumnClass(int n) {
        switch (this.canonical(n)) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 2: {
                return Class.class;
            }
            case 3: {
                return NumberRange.class;
            }
            case 6: {
                return ValueRestriction.class;
            }
            case 4: 
            case 5: {
                Class<?> clazz = this.getValueType();
                if (clazz == null) break;
                return clazz;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n) {
        switch (this.canonical(n)) {
            case 0: {
                return this.getLabel();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getValueType();
            }
            case 3: {
                return this.getOccurrences();
            }
            case 4: {
                return this.getUserObject();
            }
            case 5: {
                return this.getDefaultValue();
            }
            case 6: {
                return this.getValueRestriction();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n) {
        if (this.hasValue && n == 4) {
            try {
                this.setUserObject(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.recoverableException(MetadataTreeNode.class, (String)"setValueAt", (Throwable)illegalArgumentException);
            }
        }
    }

    public boolean isEditable(int n) {
        return this.hasValue && n == 4;
    }
}

