/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.geotoolkit.coverage.grid.GeneralGridCoordinates;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.image.io.metadata.MetadataNodeParser;
import org.geotoolkit.image.io.metadata.MetadataProxyList;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class MetadataProxy<T>
implements InvocationHandler {
    private static final boolean SPECIAL_CASE = true;
    final Class<T> interfaceType;
    final MetadataNodeParser accessor;
    private final int index;
    private final Map<String, String> namesMapping;
    private transient Map<String, Object> childs;

    private MetadataProxy(MetadataProxy<T> metadataProxy, int n) {
        this.interfaceType = metadataProxy.interfaceType;
        this.namesMapping = metadataProxy.namesMapping;
        this.accessor = metadataProxy.accessor;
        this.index = n;
    }

    MetadataProxy(Class<T> clazz, MetadataNodeParser metadataNodeParser) {
        this.interfaceType = clazz;
        this.accessor = metadataNodeParser;
        this.index = -1;
        IIOMetadataFormat iIOMetadataFormat = metadataNodeParser.format;
        this.namesMapping = iIOMetadataFormat instanceof SpatialMetadataFormat ? ((SpatialMetadataFormat)iIOMetadataFormat).getElementNames(metadataNodeParser.name()) : null;
    }

    static <T> T newProxyInstance(Class<T> clazz, MetadataNodeParser metadataNodeParser) {
        return clazz.cast(Proxy.newProxyInstance(MetadataProxy.class.getClassLoader(), new Class[]{clazz}, new MetadataProxy<T>(clazz, metadataNodeParser)));
    }

    final T newProxyInstance(int n) {
        Class<T> clazz = this.interfaceType;
        return clazz.cast(Proxy.newProxyInstance(MetadataProxy.class.getClassLoader(), new Class[]{clazz}, new MetadataProxy<T>(this, n)));
    }

    private String getAttributeName(String string) {
        String string2;
        if (this.namesMapping != null && (string2 = this.namesMapping.get(string)) != null) {
            return string2;
        }
        int n = string.startsWith("is") ? 2 : 3;
        int n2 = string.length();
        switch (n2 - n) {
            default: {
                if (Character.isUpperCase(string.charAt(n)) && Character.isUpperCase(string.charAt(n + 1))) {
                    return string.substring(n);
                }
            }
            case 1: {
                return new StringBuilder(n2 - n).append(Character.toLowerCase(string.charAt(n))).append(string, n + 1, n2).toString();
            }
            case 0: 
        }
        return string;
    }

    private Class<?> getElementClass(String string, Class<?> clazz) throws IllegalArgumentException {
        IIOMetadataFormat iIOMetadataFormat = this.accessor.format;
        int n = iIOMetadataFormat.getObjectValueType(string);
        if (n != 0) {
            Class clazz2 = iIOMetadataFormat.getObjectClass(string);
            if (n == 32) {
                clazz2 = Classes.changeArrayDimension(clazz2, (int)1);
            }
            if (clazz == null || clazz.isAssignableFrom(clazz2)) {
                return clazz2;
            }
        }
        return clazz;
    }

    private int getAttributeLength(String string) {
        int[] nArray = this.accessor.getAttributeAsIntegers(string, false);
        return nArray != null ? nArray.length : 0;
    }

    private int getAttributeAsInteger(String string, int n) {
        int[] nArray = this.accessor.getAttributeAsIntegers(string, false);
        return nArray != null ? nArray[n] : 0;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws UnsupportedOperationException, IllegalArgumentException, IllegalStateException {
        Class<Void> clazz;
        int n;
        String string = method.getName();
        int n2 = n = objectArray != null ? objectArray.length : 0;
        if (!string.startsWith("get") && !string.startsWith("is")) {
            switch (n) {
                case 0: {
                    if (string.equals("toString")) {
                        return this.toProxyString();
                    }
                    if (!string.equals("hashCode")) break;
                    return System.identityHashCode(object);
                }
                case 1: {
                    if (!string.equals("equals")) break;
                    return object == objectArray[0];
                }
            }
            throw new UnsupportedOperationException(Errors.format((int)218, (Object)string));
        }
        if (n != 0) {
            Object object2;
            if (n == 1 && (object2 = objectArray[0]) instanceof Integer) {
                int n3 = (Integer)object2;
                if (object instanceof GridEnvelope) {
                    if (string.equals("getLow")) {
                        return this.getAttributeAsInteger("low", n3);
                    }
                    if (string.equals("getHigh")) {
                        return this.getAttributeAsInteger("high", n3);
                    }
                    if (string.equals("getSpan")) {
                        return this.getAttributeAsInteger("high", n3) - this.getAttributeAsInteger("low", n3) + 1;
                    }
                }
            }
            throw new IllegalArgumentException(Errors.format((int)206, (Object)string));
        }
        MetadataNodeParser metadataNodeParser = this.accessor;
        String string2 = this.getAttributeName(string);
        if (this.index >= 0) {
            metadataNodeParser.selectChild(this.index);
        } else {
            metadataNodeParser.selectParent();
        }
        Class<Object> clazz2 = method.getReturnType();
        if (clazz2.equals(Double.TYPE)) {
            Double d = metadataNodeParser.getAttributeAsDouble(string2);
            if (d == null) {
                d = Double.NaN;
            }
            return d;
        }
        if (clazz2.equals(Float.TYPE)) {
            Float f = metadataNodeParser.getAttributeAsFloat(string2);
            if (f == null) {
                f = Float.valueOf(Float.NaN);
            }
            return f;
        }
        if (clazz2.equals(Long.TYPE)) {
            Integer n4 = metadataNodeParser.getAttributeAsInteger(string2);
            return n4 != null ? n4.longValue() : 0L;
        }
        if (clazz2.equals(Integer.TYPE)) {
            Integer n5 = metadataNodeParser.getAttributeAsInteger(string2);
            if (n5 == null) {
                n5 = 0;
                if (string.equals("getDimension") && object instanceof GridEnvelope) {
                    n5 = Math.max(this.getAttributeLength("low"), this.getAttributeLength("high"));
                }
            }
            return n5;
        }
        if (clazz2.equals(Short.TYPE)) {
            Integer n6 = metadataNodeParser.getAttributeAsInteger(string2);
            return n6 != null ? n6.shortValue() : (short)0;
        }
        if (clazz2.equals(Byte.TYPE)) {
            Integer n7 = metadataNodeParser.getAttributeAsInteger(string2);
            return n7 != null ? n7.byteValue() : (byte)0;
        }
        if (clazz2.equals(Boolean.TYPE)) {
            Boolean bl = metadataNodeParser.getAttributeAsBoolean(string2);
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            return bl;
        }
        if (clazz2.isAssignableFrom(String.class)) {
            return metadataNodeParser.getAttribute(string2);
        }
        if (clazz2.isAssignableFrom(Double.class)) {
            return metadataNodeParser.getAttributeAsDouble(string2);
        }
        if (clazz2.isAssignableFrom(Float.class)) {
            return metadataNodeParser.getAttributeAsFloat(string2);
        }
        if (clazz2.isAssignableFrom(Integer.class)) {
            return metadataNodeParser.getAttributeAsInteger(string2);
        }
        if (clazz2.isAssignableFrom(Boolean.class)) {
            return metadataNodeParser.getAttributeAsBoolean(string2);
        }
        if (clazz2.isAssignableFrom(String[].class)) {
            return metadataNodeParser.getAttributeAsStrings(string2, false);
        }
        if (clazz2.isAssignableFrom(double[].class)) {
            return metadataNodeParser.getAttributeAsDoubles(string2, false);
        }
        if (clazz2.isAssignableFrom(float[].class)) {
            return metadataNodeParser.getAttributeAsFloats(string2, false);
        }
        if (clazz2.isAssignableFrom(int[].class)) {
            return metadataNodeParser.getAttributeAsIntegers(string2, false);
        }
        if (clazz2.isAssignableFrom(Date.class)) {
            return metadataNodeParser.getAttributeAsDate(string2);
        }
        if (clazz2.isAssignableFrom(NumberRange.class)) {
            return metadataNodeParser.getAttributeAsRange(string2);
        }
        if (clazz2.isAssignableFrom(Citation.class)) {
            return metadataNodeParser.getAttributeAsCitation(string2);
        }
        if (clazz2.isAssignableFrom(InternationalString.class)) {
            return SimpleInternationalString.wrap((CharSequence)metadataNodeParser.getAttribute(string2));
        }
        if (clazz2.isAssignableFrom(Unit.class)) {
            Class clazz3 = Classes.boundOfParameterizedAttribute((Method)method);
            return metadataNodeParser.getAttributeAsUnit(string2, Classes.asSubclassOrNull((Class)clazz3, Quantity.class));
        }
        if (Character.isLowerCase(string2.charAt(0))) {
            if (clazz2.isAssignableFrom(GeneralDirectPosition.class)) {
                double[] dArray = metadataNodeParser.getAttributeAsDoubles(string2, false);
                return dArray != null ? new GeneralDirectPosition(dArray) : null;
            }
            if (clazz2.isAssignableFrom(GeneralGridCoordinates.class)) {
                int[] nArray = metadataNodeParser.getAttributeAsIntegers(string2, false);
                return nArray != null ? new GeneralGridCoordinates(nArray) : null;
            }
        }
        if (clazz2.isAssignableFrom(List.class)) {
            List<?> list;
            Class<String> clazz4 = Classes.boundOfParameterizedAttribute((Method)method);
            if (clazz4.isAssignableFrom(String.class)) {
                return UnmodifiableArrayList.wrap((Object[])metadataNodeParser.getAttributeAsStrings(string2, false));
            }
            if (clazz4.isAssignableFrom(InternationalString.class)) {
                return UnmodifiableArrayList.wrap((Object[])SimpleInternationalString.wrap((CharSequence[])metadataNodeParser.getAttributeAsStrings(string2, false)));
            }
            if (clazz4.isAssignableFrom(Citation.class)) {
                return Collections.singletonList(metadataNodeParser.getAttributeAsCitation(string2));
            }
            if (this.childs == null) {
                this.childs = new HashMap<String, Object>();
            }
            if ((list = (List<?>)this.childs.get(string)) == null) {
                MetadataNodeParser metadataNodeParser2;
                String string3 = SpatialMetadataFormat.toElementName(string2);
                try {
                    metadataNodeParser2 = new MetadataNodeParser(metadataNodeParser, string3, "#auto");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.recoverableException((Logger)MetadataNodeParser.LOGGER, this.interfaceType, (String)string, (Throwable)illegalArgumentException);
                    return null;
                }
                catch (NoSuchElementException noSuchElementException) {
                    return Collections.emptyList();
                }
                if (metadataNodeParser2.allowsChildren()) {
                    clazz4 = this.getElementClass(metadataNodeParser2.childPath, clazz4);
                    list = metadataNodeParser2.newProxyList(clazz4);
                } else {
                    clazz4 = this.getElementClass(string3, clazz4);
                    list = Collections.singletonList(metadataNodeParser2.newProxyInstance(clazz4));
                }
                this.childs.put(string, list);
            }
            return list;
        }
        if (CodeList.class.isAssignableFrom(clazz2)) {
            Object obj = metadataNodeParser.getAttributeAsCode(string2, clazz2);
            return obj;
        }
        if (this.childs == null) {
            this.childs = new HashMap<String, Object>();
        }
        if ((clazz = this.childs.get(string)) == null) {
            try {
                String string4 = SpatialMetadataFormat.toElementName(string2);
                Class<?> clazz5 = this.getElementClass(string4, clazz2);
                MetadataNodeParser metadataNodeParser3 = new MetadataNodeParser(metadataNodeParser, string4, "#auto");
                clazz = metadataNodeParser3.isEmpty() ? Void.TYPE : metadataNodeParser3.newProxyInstance(clazz5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                metadataNodeParser.warning(Level.FINE, this.interfaceType, string, illegalArgumentException);
                clazz = Void.TYPE;
            }
            catch (NoSuchElementException noSuchElementException) {
                clazz = Void.TYPE;
            }
            this.childs.put(string, clazz);
        }
        return clazz != Void.TYPE ? clazz : null;
    }

    static void setWarningLevel(Collection<?> collection, Level level) {
        for (Object obj : collection) {
            Map<String, Object> map;
            if (obj instanceof MetadataProxyList) {
                ((MetadataProxyList)obj).setWarningLevel(level);
                continue;
            }
            if (obj instanceof Collection) {
                MetadataProxy.setWarningLevel((Collection)obj, level);
                continue;
            }
            if (obj == null) continue;
            MetadataProxy metadataProxy = (MetadataProxy)Proxy.getInvocationHandler(obj);
            if (level.equals(metadataProxy.accessor.setWarningLevel(level)) || (map = metadataProxy.childs) == null) continue;
            MetadataProxy.setWarningLevel(map.values(), level);
        }
    }

    private String toProxyString() {
        if (this.index >= 0) {
            return Classes.getShortName(this.interfaceType) + '[' + this.index + ']';
        }
        return this.accessor.toString(this.interfaceType);
    }

    public String toString() {
        return this.accessor.toString(this.getClass());
    }
}

