/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.swing.tree.TreeNode;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.gui.swing.tree.TreeFormat;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.IIONode;
import org.geotoolkit.image.io.metadata.MetadataProxy;
import org.geotoolkit.image.io.metadata.MetadataProxyList;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataNodeParser
implements WarningProducer {
    private static final char SEPARATOR = '/';
    static final char NBSP = '\u00a0';
    protected final IIOMetadata metadata;
    final IIOMetadataFormat format;
    final Node parent;
    final String childPath;
    final List<Node> childs;
    private transient Element current;
    private transient Level warningLevel;

    public MetadataNodeParser(MetadataNodeParser metadataNodeParser) {
        this.metadata = metadataNodeParser.metadata;
        this.format = metadataNodeParser.format;
        this.parent = metadataNodeParser.parent;
        this.childPath = metadataNodeParser.childPath;
        this.childs = metadataNodeParser.childs;
        this.current = metadataNodeParser.current;
        this.warningLevel = metadataNodeParser.warningLevel;
    }

    public MetadataNodeParser(MetadataNodeParser metadataNodeParser, String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        this(metadataNodeParser, metadataNodeParser.metadata, null, null, string, string2);
    }

    public MetadataNodeParser(MetadataNodeParser metadataNodeParser, Class<?> clazz) throws IllegalArgumentException, NoSuchElementException {
        this(metadataNodeParser, metadataNodeParser.metadata, null, clazz, null, "#auto");
    }

    public MetadataNodeParser(IIOMetadata iIOMetadata, String string) throws NoSuchElementException {
        this(iIOMetadata, "#auto", string, "#auto");
    }

    public MetadataNodeParser(IIOMetadata iIOMetadata, String string, String string2, String string3) throws NoSuchElementException {
        this(null, iIOMetadata, string, null, string2, string3);
    }

    public MetadataNodeParser(IIOMetadata iIOMetadata, String string, Class<?> clazz) throws IllegalArgumentException, NoSuchElementException {
        this(null, iIOMetadata, string, clazz, null, "#auto");
    }

    private MetadataNodeParser(MetadataNodeParser metadataNodeParser, IIOMetadata iIOMetadata, String string, Class<?> clazz, String string2, String string3) throws IllegalArgumentException, NoSuchElementException {
        Node node;
        IIOMetadataFormat iIOMetadataFormat;
        Object object;
        block23: {
            ArgumentChecks.ensureNonNull((String)"metadata", (Object)iIOMetadata);
            do {
                object = null;
                if (metadataNodeParser != null) {
                    iIOMetadataFormat = metadataNodeParser.format;
                    node = metadataNodeParser.parent;
                    this.warningLevel = metadataNodeParser.warningLevel;
                } else if (string != null && !string.equals("#auto")) {
                    iIOMetadataFormat = iIOMetadata.getMetadataFormat(string);
                    node = iIOMetadata.getAsTree(string);
                } else if (iIOMetadata instanceof SpatialMetadata) {
                    object = (SpatialMetadata)iIOMetadata;
                    iIOMetadataFormat = ((SpatialMetadata)object).format;
                    node = ((SpatialMetadata)object).getAsTree();
                } else {
                    string = iIOMetadata.getMetadataFormatNames()[0];
                    iIOMetadataFormat = iIOMetadata.getMetadataFormat(string);
                    node = iIOMetadata.getAsTree(string);
                }
                if (iIOMetadataFormat == null) {
                    throw new IllegalArgumentException(this.getErrorResources().getString(203, (Object)string));
                }
                if (clazz == null) break block23;
                ArrayList<String> arrayList = new ArrayList<String>(4);
                MetadataNodeParser.listPaths(iIOMetadataFormat, clazz, node.getNodeName(), new StringBuilder(48), arrayList);
                int n = arrayList.size();
                if (n == 1) {
                    string2 = (String)arrayList.get(0);
                    break block23;
                }
                if (n == 0) continue;
                String string4 = System.getProperty("line.separator", "\n");
                StringBuilder stringBuilder = new StringBuilder(this.getErrorResources().getString(1, clazz)).append(string4);
                for (String string5 : arrayList) {
                    stringBuilder.append(" \u2022 ").append(string5).append(string4);
                }
                throw new IllegalArgumentException(stringBuilder.toString());
            } while (object != null && (iIOMetadata = ((SpatialMetadata)object).fallback) != null);
            throw new IllegalArgumentException(this.getErrorResources().getString(226, clazz));
        }
        this.metadata = iIOMetadata;
        this.format = iIOMetadataFormat;
        if (this.warningLevel == null) {
            this.warningLevel = iIOMetadata instanceof SpatialMetadata ? ((SpatialMetadata)iIOMetadata).getWarningLevel() : Level.WARNING;
        }
        object = new ArrayList(4);
        if (string2 != null) {
            MetadataNodeParser.listChilds(node, string2, 0, (List<Node>)object, true);
            int n = object.size();
            switch (n) {
                default: {
                    this.warning("<init>", 202, (Object)string2, n);
                }
                case 1: {
                    this.parent = (Node)object.get(0);
                    object.clear();
                    break;
                }
                case 0: {
                    if (this.isReadOnly()) {
                        throw new NoSuchElementException(this.getErrorResources().getString(166, (Object)string2));
                    }
                    this.parent = MetadataNodeParser.appendChild(node, string2);
                    break;
                }
            }
        } else {
            this.parent = node;
        }
        if ("#auto".equals(string3)) {
            String[] stringArray;
            string3 = null;
            String string6 = this.parent.getNodeName();
            if (iIOMetadataFormat.getChildPolicy(string6) == 5 && (stringArray = iIOMetadataFormat.getChildNames(string6)) != null && stringArray.length == 1) {
                string3 = stringArray[0];
            }
        }
        this.childPath = string3;
        if (string3 != null) {
            String string7 = string2 != null ? string2 + '/' + string3 : string3;
            MetadataNodeParser.listChilds(node, string7, 0, (List<Node>)object, false);
            this.childs = object;
        } else {
            this.childs = Collections.emptyList();
        }
        if (this.parent instanceof Element) {
            this.current = (Element)this.parent;
        }
    }

    private static void listChilds(Node node, String string, int n, List<Node> list, boolean bl) {
        int n2 = string.indexOf(47, n);
        String string2 = (n2 >= 0 ? string.substring(n, n2) : string.substring(n)).trim();
        NodeList nodeList = node.getChildNodes();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            Node node2 = nodeList.item(i);
            if (!string2.equals(node2.getNodeName())) continue;
            if (n2 >= 0) {
                MetadataNodeParser.listChilds(node2, string, n2 + 1, list, bl);
                continue;
            }
            if (!bl && !(node2 instanceof Element)) continue;
            list.add(node2);
        }
    }

    static Node appendChild(Node node, String string) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(47, n2)) >= 0) {
            block2: {
                int n3;
                String string2 = string.substring(n2, n).trim();
                NodeList nodeList = node.getChildNodes();
                int n4 = n3 = nodeList.getLength();
                while (--n4 >= 0) {
                    Node node2 = nodeList.item(n4);
                    if (!string2.equals(node2.getNodeName())) continue;
                    node = node2;
                    break block2;
                }
                node = node.appendChild(new IIONode(string2.intern()));
            }
            n2 = n + 1;
        }
        String string3 = string.substring(n2).trim().intern();
        return node.appendChild(new IIONode(string3));
    }

    public static List<String> listPaths(IIOMetadataFormat iIOMetadataFormat, Class<?> clazz) {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"format", (Object)iIOMetadataFormat);
        ArrayList<String> arrayList = new ArrayList<String>(4);
        MetadataNodeParser.listPaths(iIOMetadataFormat, clazz, iIOMetadataFormat.getRootName(), new StringBuilder(48), arrayList);
        return arrayList;
    }

    private static void listPaths(IIOMetadataFormat iIOMetadataFormat, Class<?> clazz, String string, StringBuilder stringBuilder, List<String> list) {
        String[] stringArray;
        int n = iIOMetadataFormat.getChildPolicy(string);
        if (n != 0 && (stringArray = iIOMetadataFormat.getChildNames(string)) != null) {
            int n2 = stringBuilder.length();
            for (String string2 : stringArray) {
                if (n2 != 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string2);
                if (iIOMetadataFormat.getObjectValueType(string2) != 0) {
                    Class<?> clazz2 = iIOMetadataFormat.getObjectClass(string2);
                    if (clazz != null && clazz.isAssignableFrom(clazz2)) {
                        list.add(n == 5 ? stringBuilder.substring(0, n2) : stringBuilder.toString());
                    }
                }
                MetadataNodeParser.listPaths(iIOMetadataFormat, clazz, string2, stringBuilder, list);
                stringBuilder.setLength(n2);
            }
        }
    }

    public String name() {
        return this.parent.getNodeName();
    }

    boolean isReadOnly() {
        return true;
    }

    public boolean isEmpty() {
        return this.childs.isEmpty() && !this.currentElement().hasAttributes();
    }

    public int childCount() {
        return this.childs.size();
    }

    final boolean allowsChildren() {
        return this.childs != Collections.EMPTY_LIST;
    }

    public void selectChild(int n) throws IndexOutOfBoundsException {
        this.current = (Element)this.childs.get(n);
    }

    public void selectParent() throws NoSuchElementException {
        if (!(this.parent instanceof Element)) {
            throw new NoSuchElementException();
        }
        this.current = (Element)this.parent;
    }

    final Element currentElement() throws IllegalStateException {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return this.current;
    }

    public Object getUserObject() {
        Object object;
        Element element = this.currentElement();
        if (element instanceof IIOMetadataNode && (object = ((IIOMetadataNode)element).getUserObject()) != null) {
            return object;
        }
        return element.getNodeValue();
    }

    public <T> T getUserObject(Class<? extends T> clazz) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        Object object = this.getUserObject();
        if (object instanceof CharSequence) {
            if (String.class.isAssignableFrom(clazz)) {
                object = object.toString();
            } else if (Number.class.isAssignableFrom(clazz)) {
                object = Numbers.valueOf(clazz, (String)object.toString());
            } else if (Date.class.isAssignableFrom(clazz)) {
                object = JDK8.parseDateTime((String)object.toString(), (boolean)false);
            } else if (clazz.isArray()) {
                Class clazz2 = Numbers.primitiveToWrapper(clazz.getComponentType());
                if (clazz2 == Double.class) {
                    object = this.parseSequence(object.toString(), Double.TYPE, false, null);
                } else if (clazz2 == Integer.class) {
                    object = this.parseSequence(object.toString(), Integer.TYPE, false, null);
                }
            }
        }
        return clazz.cast(object);
    }

    public <T> T newProxyInstance(Class<T> clazz) throws IllegalArgumentException {
        return MetadataProxy.newProxyInstance(clazz, this);
    }

    public <T> List<T> newProxyList(Class<T> clazz) throws IllegalArgumentException {
        if (this.allowsChildren()) {
            return MetadataProxyList.create(clazz, this);
        }
        return Collections.singletonList(MetadataProxy.newProxyInstance(clazz, this));
    }

    public String getAttribute(String string) {
        ArgumentChecks.ensureNonNull((String)"attribute", (Object)string);
        String string2 = this.currentElement().getAttribute(string);
        if (string2 != null && (string2 = string2.trim()).isEmpty()) {
            string2 = null;
        }
        return string2;
    }

    public String[] getAttributeAsStrings(String string, boolean bl) {
        return (String[])this.parseSequence(this.getAttribute(string), String.class, bl, "getAttributeAsStrings");
    }

    public <T extends CodeList<T>> T getAttributeAsCode(String string, Class<T> clazz) {
        String string2 = this.getAttribute(string);
        CodeList codeList = Types.forCodeName(clazz, (String)string2, (boolean)false);
        if (codeList == null && string2 != null) {
            this.warning("getAttributeAsCode", 12, (Object)string, string2);
        }
        return (T)codeList;
    }

    public Boolean getAttributeAsBoolean(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on")) {
                return Boolean.TRUE;
            }
            if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("off")) {
                return Boolean.FALSE;
            }
            this.warning("getAttributeAsBoolean", 12, (Object)string, string2);
        }
        return null;
    }

    public Integer getAttributeAsInteger(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            string2 = Strings.trimFractionalPart((String)string2);
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.warning("getAttributeAsInteger", 232, string2);
            }
        }
        return null;
    }

    public int[] getAttributeAsIntegers(String string, boolean bl) {
        return (int[])this.parseSequence(this.getAttribute(string), Integer.TYPE, bl, "getAttributeAsIntegers");
    }

    public Float getAttributeAsFloat(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return Float.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.warning("getAttributeAsFloat", 232, string2);
            }
        }
        return null;
    }

    public float[] getAttributeAsFloats(String string, boolean bl) {
        return (float[])this.parseSequence(this.getAttribute(string), Float.TYPE, bl, "getAttributeAsFloats");
    }

    public Double getAttributeAsDouble(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.warning("getAttributeAsDouble", 232, string2);
            }
        }
        return null;
    }

    public double[] getAttributeAsDoubles(String string, boolean bl) {
        return (double[])this.parseSequence(this.getAttribute(string), Double.TYPE, bl, "getAttributeAsDoubles");
    }

    public Date getAttributeAsDate(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            string2 = Strings.trimFractionalPart((String)string2);
            if (this.metadata instanceof SpatialMetadata) {
                return (Date)((SpatialMetadata)this.metadata).dateFormat().parse(string2);
            }
            try {
                return SpatialMetadata.parse(Date.class, string2);
            }
            catch (ParseException parseException) {
                this.warning(null, MetadataNodeParser.class, "getAttributeAsDate", parseException);
            }
        }
        return null;
    }

    public NumberRange<?> getAttributeAsRange(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            if (this.metadata instanceof SpatialMetadata) {
                return (NumberRange)((SpatialMetadata)this.metadata).rangeFormat().parse(string2);
            }
            try {
                return SpatialMetadata.parse(NumberRange.class, string2);
            }
            catch (ParseException parseException) {
                this.warning(null, MetadataNodeParser.class, "getAttributeAsRange", parseException);
            }
        }
        return null;
    }

    public <Q extends Quantity> Unit<Q> getAttributeAsUnit(String string, Class<Q> clazz) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                Unit unit = Units.valueOf((String)string2);
                if (clazz == null) {
                    return unit;
                }
                try {
                    return unit.asType(clazz);
                }
                catch (ClassCastException classCastException) {
                    this.warning("getAttributeAsUnit", 92, unit);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.warning(null, MetadataNodeParser.class, "getAttributeAsUnit", illegalArgumentException);
            }
        }
        return null;
    }

    public Citation getAttributeAsCitation(String string) {
        return Citations.fromName((String)this.getAttribute(string));
    }

    private Object parseSequence(String string, Class<?> clazz, boolean bl, String string2) throws NumberFormatException {
        Object object;
        if (string == null) {
            return null;
        }
        AbstractCollection abstractCollection = bl ? new LinkedHashSet() : new ArrayList();
        Class clazz2 = Numbers.primitiveToWrapper(clazz);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().replace('\u00a0', ' ').trim();
            try {
                object = Numbers.valueOf((Class)clazz2, (String)string3);
            }
            catch (NumberFormatException numberFormatException) {
                if (string2 == null) {
                    throw numberFormatException;
                }
                this.warning(string2, 232, string3);
                continue;
            }
            abstractCollection.add(object);
        }
        int n = 0;
        object = Array.newInstance(clazz, abstractCollection.size());
        for (Object e : abstractCollection) {
            Array.set(object, n++, e);
        }
        assert (Array.getLength(object) == n);
        return object;
    }

    private void warning(String string, int n, Object object, Object object2) {
        if (!Level.OFF.equals(this.warningLevel)) {
            this.warning(string, n, new Object[]{object, object2});
        }
    }

    private void warning(String string, int n, Object object) {
        if (!Level.OFF.equals(this.warningLevel)) {
            this.warning(MetadataNodeParser.class, string, this.getErrorResources(), n, object);
        }
    }

    final void warning(Class<?> clazz, String string, IndexedResourceBundle indexedResourceBundle, int n, Object object) {
        Level level = this.warningLevel;
        if (!Level.OFF.equals(level)) {
            LogRecord logRecord = indexedResourceBundle.getLogRecord(level, n, object);
            logRecord.setSourceClassName(clazz.getName());
            logRecord.setSourceMethodName(string);
            this.warningOccurred(logRecord);
        }
    }

    final void warning(Level level, Class<?> clazz, String string, Exception exception) {
        Level level2 = this.warningLevel;
        if (!Level.OFF.equals(level2)) {
            if (level == null || level2 != null && level2.intValue() < level.intValue()) {
                level = level2;
            }
            Warnings.log((WarningProducer)this, level, clazz, string, exception);
        }
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        if (!Level.OFF.equals(this.warningLevel)) {
            return Warnings.log(this.metadata, logRecord);
        }
        return false;
    }

    public Level getWarningLevel() {
        return this.warningLevel;
    }

    public Level setWarningLevel(Level level) {
        ArgumentChecks.ensureNonNull((String)"level", (Object)level);
        Level level2 = this.warningLevel;
        this.warningLevel = level;
        return level2;
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    public Locale getLocale() {
        return this.metadata instanceof Localized ? ((Localized)this.metadata).getLocale() : null;
    }

    public String toString() {
        return this.toString(this.getClass());
    }

    final String toString(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortName(clazz)).append("[\"");
        int n = stringBuilder.length();
        TreeFormat treeFormat = new TreeFormat();
        treeFormat.format((TreeNode)Trees.xmlToSwing((Node)this.parent), stringBuilder);
        n = stringBuilder.indexOf(treeFormat.getLineSeparator(), n);
        return stringBuilder.insert(n, "\"]").toString();
    }
}

