/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.NoSuchElementException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.measure.unit.Unit;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.geotoolkit.image.io.metadata.MetadataNodeParser;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.internal.jaxb.XmlUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataNodeAccessor
extends MetadataNodeParser {
    public MetadataNodeAccessor(MetadataNodeParser metadataNodeParser) {
        super(metadataNodeParser);
    }

    public MetadataNodeAccessor(MetadataNodeParser metadataNodeParser, String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        super(metadataNodeParser, string, string2);
    }

    public MetadataNodeAccessor(MetadataNodeParser metadataNodeParser, Class<?> clazz) throws IllegalArgumentException, NoSuchElementException {
        super(metadataNodeParser, clazz);
    }

    public MetadataNodeAccessor(IIOMetadata iIOMetadata, String string) throws NoSuchElementException {
        super(iIOMetadata, string);
    }

    public MetadataNodeAccessor(IIOMetadata iIOMetadata, String string, String string2, String string3) throws NoSuchElementException {
        super(iIOMetadata, string, string2, string3);
    }

    public MetadataNodeAccessor(IIOMetadata iIOMetadata, String string, Class<?> clazz) throws IllegalArgumentException, NoSuchElementException {
        super(iIOMetadata, string, clazz);
    }

    @Override
    public boolean isReadOnly() {
        return this.metadata.isReadOnly();
    }

    public int appendChild() throws UnsupportedOperationException {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(this.getErrorResources().getString(230));
        }
        int n = this.childs.size();
        Node node = MetadataNodeAccessor.appendChild(this.parent, this.childPath);
        if (node instanceof Element) {
            this.childs.add((Element)node);
            return n;
        }
        throw new UnsupportedImplementationException(node.getClass());
    }

    private static boolean isFormattable(Class<?> clazz) {
        return clazz != null && (CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(Numbers.primitiveToWrapper(clazz)));
    }

    private static String formatSequence(Object object) {
        String string = null;
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder(48);
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2;
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                if ((object2 = Array.get(object, i)) == null) continue;
                String string2 = object2.toString().trim();
                int n2 = string2.length();
                for (int j = 0; j < n2; ++j) {
                    char c = string2.charAt(j);
                    stringBuilder.append(Character.isWhitespace(c) ? (char)'\u00a0' : (char)c);
                }
            }
            string = stringBuilder.length() != 0 ? stringBuilder.toString() : null;
        }
        return string;
    }

    public void setUserObject(Object object) throws UnsupportedImplementationException {
        Element element = this.currentElement();
        String string = null;
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (Date.class.isAssignableFrom(clazz)) {
                string = XmlUtilities.printDateTime((Date)((Date)object));
            } else if (MetadataNodeAccessor.isFormattable(clazz)) {
                string = object.toString();
            } else if (MetadataNodeAccessor.isFormattable(clazz.getComponentType())) {
                string = MetadataNodeAccessor.formatSequence(object);
            }
        }
        if (element instanceof IIOMetadataNode) {
            ((IIOMetadataNode)element).setUserObject(object);
        } else if (object != null && string == null) {
            throw new UnsupportedImplementationException(this.getErrorResources().getString(76, (Object)Classes.getClass((Object)element), IIOMetadataNode.class));
        }
        element.setNodeValue(string);
    }

    public void setAttribute(String string, String string2) {
        ArgumentChecks.ensureNonNull((String)"attribute", (Object)string);
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(this.getErrorResources().getString(230));
        }
        Element element = this.currentElement();
        if (string2 == null || (string2 = string2.trim()).isEmpty()) {
            if (element.hasAttribute(string)) {
                element.removeAttribute(string);
            }
        } else {
            element.setAttribute(string, string2);
        }
    }

    public void setAttribute(String string, String ... stringArray) {
        this.setAttribute(string, MetadataNodeAccessor.formatSequence(stringArray));
    }

    public void setAttribute(String string, CodeList<?> codeList) {
        this.setAttribute(string, Types.getCodeName(codeList));
    }

    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, Boolean.toString(bl));
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, Integer.toString(n));
    }

    public void setAttribute(String string, int ... nArray) {
        this.setAttribute(string, MetadataNodeAccessor.formatSequence(nArray));
    }

    public void setAttribute(String string, float f) {
        String string2 = null;
        if (!Float.isNaN(f) && !Float.isInfinite(f)) {
            string2 = Float.toString(f);
        }
        this.setAttribute(string, string2);
    }

    public void setAttribute(String string, float ... fArray) {
        this.setAttribute(string, MetadataNodeAccessor.formatSequence(fArray));
    }

    public void setAttribute(String string, double d) {
        String string2 = null;
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            string2 = Double.toString(d);
        }
        this.setAttribute(string, string2);
    }

    public void setAttribute(String string, double ... dArray) {
        this.setAttribute(string, MetadataNodeAccessor.formatSequence(dArray));
    }

    public void setAttribute(String string, Date date) {
        String string2 = null;
        if (date != null) {
            string2 = this.metadata instanceof SpatialMetadata ? ((SpatialMetadata)this.metadata).dateFormat().format((Object)date) : SpatialMetadata.format(Date.class, date);
        }
        this.setAttribute(string, string2);
    }

    public void setAttribute(String string, NumberRange<?> numberRange) {
        String string2 = null;
        if (numberRange != null) {
            string2 = this.metadata instanceof SpatialMetadata ? ((SpatialMetadata)this.metadata).rangeFormat().format(numberRange) : SpatialMetadata.format(NumberRange.class, numberRange);
        }
        this.setAttribute(string, string2);
    }

    public void setAttribute(String string, Unit<?> unit) {
        this.setAttribute(string, unit != null ? unit.toString() : null);
    }

    public void setAttribute(String string, Citation citation) {
        this.setAttribute(string, Citations.getIdentifier((Citation)citation));
    }
}

