/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import javax.imageio.stream.ImageInputStream;
import org.geotoolkit.image.io.StreamImageReader;
import org.geotoolkit.image.io.TestReader;
import org.geotoolkit.internal.io.LineReader;
import org.geotoolkit.io.LineFormat;
import org.geotoolkit.resources.Vocabulary;

public abstract class TextImageReader
extends StreamImageReader {
    private BufferedReader reader;

    protected TextImageReader(Spi spi) {
        super(spi);
    }

    protected Charset getCharset(InputStream inputStream) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).charset : null;
    }

    final Locale getDataLocale() {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).locale : null;
    }

    protected LineFormat getLineFormat(int n) throws IOException {
        Locale locale = this.getDataLocale();
        if (locale != null) {
            return new LineFormat(locale);
        }
        return new LineFormat();
    }

    protected double getPadValue(int n) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).padValue : Double.NaN;
    }

    protected BufferedReader getReader() throws IllegalStateException, IOException {
        if (this.reader == null) {
            Object object = this.getInput();
            if (object instanceof BufferedReader) {
                this.reader = (BufferedReader)object;
                this.closeOnReset = null;
            } else if (object instanceof Reader) {
                this.reader = new LineReader((Reader)object);
                this.closeOnReset = null;
            } else {
                InputStream inputStream = this.getInputStream();
                this.reader = new LineReader(this.getInputStreamReader(inputStream));
                if (this.closeOnReset == inputStream) {
                    this.closeOnReset = this.reader;
                }
            }
        }
        return this.reader;
    }

    final Reader getInputStreamReader(InputStream inputStream) throws IOException {
        Charset charset = this.getCharset(inputStream);
        return charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream);
    }

    protected boolean isComment(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isSpaceChar(c)) continue;
            return c == '#';
        }
        return true;
    }

    protected String getPositionString(String string) {
        Object object = this.getInput();
        String string2 = object instanceof File ? ((File)object).getName() : (object instanceof URL ? ((URL)object).getFile() : null);
        Integer n = this.reader instanceof LineNumberReader ? Integer.valueOf(((LineNumberReader)this.reader).getLineNumber()) : null;
        Vocabulary vocabulary = Vocabulary.getResources((Locale)this.getLocale());
        String string3 = string2 != null ? (n != null ? vocabulary.getString(110, (Object)string2, (Object)n) : vocabulary.getString(109, (Object)string2)) : (n != null ? vocabulary.getString(175, (Object)n) : null);
        if (string3 != null) {
            if (string != null) {
                return string3 + ": " + string;
            }
            return string3;
        }
        return string;
    }

    @Override
    protected void close() throws IOException {
        this.reader = null;
        super.close();
    }

    protected static abstract class Spi
    extends StreamImageReader.Spi {
        private static final Class<?>[] INPUT_TYPES = new Class[]{File.class, URI.class, URL.class, URLConnection.class, Reader.class, InputStream.class, ImageInputStream.class, ReadableByteChannel.class, String.class};
        static final String[] SUFFIXES = new String[]{"txt", "TXT", "asc", "ASC", "dat", "DAT"};
        protected Charset charset;
        protected Locale locale;
        protected double padValue;

        protected Spi() {
            this.inputTypes = INPUT_TYPES;
            this.suffixes = SUFFIXES;
            this.padValue = Double.NaN;
        }

        @Override
        public boolean canDecodeInput(Object object) throws IOException {
            return this.canDecodeInput(object, 2048);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean canDecodeInput(Object object, int n) throws IOException {
            TestReader testReader = new TestReader(this);
            testReader.setInput(object);
            try {
                boolean bl = testReader.canDecode(n);
                return bl;
            }
            finally {
                testReader.close();
            }
        }

        protected boolean isValidHeader(Set<String> set) {
            return set.isEmpty();
        }

        protected boolean isValidContent(double[][] dArray) {
            if (dArray.length == 0) {
                return false;
            }
            int n = dArray[0].length;
            for (int i = 1; i < dArray.length; ++i) {
                if (dArray[i].length == n) continue;
                return false;
            }
            return this.isValidColumnCount(n);
        }

        protected boolean isValidColumnCount(int n) {
            return n > 0;
        }
    }
}

