/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import javax.media.jai.iterator.RectIter;

final class SubsampledRectIter
implements RectIter {
    private final RectIter iterator;
    private int bandIndex;
    private final int[] sourceBands;
    private final int dx;
    private final int dy;

    public SubsampledRectIter(RectIter rectIter, int n, int n2, int[] nArray) {
        this.iterator = rectIter;
        this.dx = n - 1;
        this.dy = n2 - 1;
        this.sourceBands = nArray;
    }

    public void startLines() {
        this.iterator.startLines();
    }

    public void nextLine() {
        this.nextLineDone();
    }

    public boolean nextLineDone() {
        if (this.iterator.nextLineDone()) {
            return true;
        }
        this.iterator.jumpLines(this.dy);
        return false;
    }

    public void jumpLines(int n) {
        this.iterator.jumpLines(n * (this.dy + 1));
    }

    public boolean finishedLines() {
        return this.iterator.finishedLines();
    }

    public void startPixels() {
        this.iterator.startPixels();
    }

    public void nextPixel() {
        this.nextPixelDone();
    }

    public boolean nextPixelDone() {
        if (this.iterator.nextPixelDone()) {
            return true;
        }
        this.iterator.jumpPixels(this.dx);
        return false;
    }

    public void jumpPixels(int n) {
        this.iterator.jumpPixels(n * (this.dx + 1));
    }

    public boolean finishedPixels() {
        return this.iterator.finishedPixels();
    }

    public void startBands() {
        this.bandIndex = 0;
        this.iterator.startBands();
        int n = this.sourceBands[0];
        while (--n >= 0) {
            this.iterator.nextBand();
        }
    }

    public void nextBand() {
        this.nextBandDone();
    }

    public boolean nextBandDone() {
        int n = this.sourceBands[this.bandIndex];
        if (++this.bandIndex >= this.sourceBands.length) {
            return true;
        }
        if ((n = this.sourceBands[this.bandIndex] - n) < 0) {
            this.iterator.startBands();
            n = this.sourceBands[this.bandIndex];
        }
        while (--n >= 0) {
            if (!this.iterator.nextBandDone()) continue;
            return true;
        }
        return false;
    }

    public boolean finishedBands() {
        return this.iterator.finishedBands();
    }

    public int getSample() {
        return this.iterator.getSample();
    }

    public int getSample(int n) {
        return this.iterator.getSample(this.sourceBands[n]);
    }

    public float getSampleFloat() {
        return this.iterator.getSampleFloat();
    }

    public float getSampleFloat(int n) {
        return this.iterator.getSampleFloat(this.sourceBands[n]);
    }

    public double getSampleDouble() {
        return this.iterator.getSampleDouble();
    }

    public double getSampleDouble(int n) {
        return this.iterator.getSampleDouble(this.sourceBands[n]);
    }

    public int[] getPixel(int[] nArray) {
        int n = this.sourceBands.length;
        if (nArray == null) {
            nArray = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getSample(i);
        }
        return nArray;
    }

    public float[] getPixel(float[] fArray) {
        int n = this.sourceBands.length;
        if (fArray == null) {
            fArray = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.getSampleFloat(i);
        }
        return fArray;
    }

    public double[] getPixel(double[] dArray) {
        int n = this.sourceBands.length;
        if (dArray == null) {
            dArray = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getSampleDouble(i);
        }
        return dArray;
    }
}

