/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageOutputStream;
import org.geotoolkit.image.io.OutputStreamAdapter;
import org.geotoolkit.image.io.SpatialImageWriter;

public abstract class StreamImageWriter
extends SpatialImageWriter {
    protected Closeable closeOnReset;
    private OutputStream stream;

    protected StreamImageWriter(Spi spi) {
        super(spi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
    }

    protected OutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.stream == null) {
            Object object = this.getOutput();
            if (object == null) {
                throw new IllegalStateException(this.getErrorResources().getString(157));
            }
            if (object instanceof OutputStream) {
                this.stream = (OutputStream)object;
                this.closeOnReset = null;
            } else if (object instanceof ImageOutputStream) {
                this.stream = new OutputStreamAdapter((ImageOutputStream)object);
                this.closeOnReset = null;
            } else if (object instanceof String) {
                this.stream = new FileOutputStream((String)object);
                this.closeOnReset = this.stream;
            } else if (object instanceof File) {
                this.stream = new FileOutputStream((File)object);
                this.closeOnReset = this.stream;
            } else if (object instanceof URI) {
                this.stream = ((URI)object).toURL().openConnection().getOutputStream();
                this.closeOnReset = this.stream;
            } else if (object instanceof URL) {
                this.stream = ((URL)object).openConnection().getOutputStream();
                this.closeOnReset = this.stream;
            } else if (object instanceof URLConnection) {
                this.stream = ((URLConnection)object).getOutputStream();
                this.closeOnReset = this.stream;
            } else if (object instanceof WritableByteChannel) {
                this.stream = Channels.newOutputStream((WritableByteChannel)object);
            } else {
                throw new IllegalStateException(this.getErrorResources().getString(76, object.getClass(), OutputStream.class));
            }
        }
        return this.stream;
    }

    @Override
    protected void close() throws IOException {
        if (this.closeOnReset != null) {
            this.closeOnReset.close();
        }
        this.closeOnReset = null;
        this.stream = null;
        super.close();
    }

    protected void finalize() throws Throwable {
        this.closeSilently();
        super.finalize();
    }

    protected static abstract class Spi
    extends SpatialImageWriter.Spi {
        private static final Class<?>[] OUTPUT_TYPES = new Class[]{File.class, URL.class, URLConnection.class, OutputStream.class, ImageOutputStream.class, String.class};

        protected Spi() {
            this.outputTypes = OUTPUT_TYPES;
        }

        @Override
        public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
            return true;
        }
    }
}

