/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import org.geotoolkit.image.io.InputStreamAdapter;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.util.logging.Logging;

public abstract class StreamImageReader
extends SpatialImageReader {
    protected Closeable closeOnReset;
    private ReadableByteChannel channel;
    private InputStream stream;
    private long streamOrigin;

    protected StreamImageReader(Spi spi) {
        super(spi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object instanceof ImageInputStream) {
            try {
                this.streamOrigin = ((ImageInputStream)object).getStreamPosition();
            }
            catch (IOException iOException) {
                Logging.unexpectedException((Logger)LOGGER, StreamImageReader.class, (String)"setInput", (Throwable)iOException);
            }
        }
    }

    protected long getStreamLength() throws IOException {
        Object object = this.getInput();
        if (object instanceof ImageInputStream) {
            long l = ((ImageInputStream)object).length();
            if (l >= 0L) {
                l -= this.streamOrigin;
            }
            return l;
        }
        if (object instanceof File) {
            return ((File)object).length();
        }
        if (object instanceof URL) {
            return ((URL)object).openConnection().getContentLength();
        }
        if (object instanceof URLConnection) {
            return ((URLConnection)object).getContentLength();
        }
        return -1L;
    }

    protected InputStream getInputStream() throws IllegalStateException, IOException {
        if (this.stream == null) {
            Object object = this.getInput();
            if (object == null) {
                throw new IllegalStateException(this.getErrorResources().getString(156));
            }
            if (object instanceof InputStream) {
                this.stream = (InputStream)object;
                this.closeOnReset = null;
            } else if (object instanceof ImageInputStream) {
                this.stream = new InputStreamAdapter((ImageInputStream)object);
                this.closeOnReset = null;
            } else if (object instanceof String) {
                this.stream = new FileInputStream((String)object);
                this.closeOnReset = this.stream;
            } else if (object instanceof File) {
                this.stream = new FileInputStream((File)object);
                this.closeOnReset = this.stream;
            } else if (object instanceof URI) {
                this.stream = ((URI)object).toURL().openStream();
                this.closeOnReset = this.stream;
            } else if (object instanceof URL) {
                this.stream = ((URL)object).openStream();
                this.closeOnReset = this.stream;
            } else if (object instanceof URLConnection) {
                this.stream = ((URLConnection)object).getInputStream();
                this.closeOnReset = this.stream;
            } else if (object instanceof ReadableByteChannel) {
                this.stream = Channels.newInputStream((ReadableByteChannel)object);
            } else {
                throw new IllegalStateException(this.getErrorResources().getString(76, object.getClass(), InputStream.class));
            }
        }
        return this.stream;
    }

    protected ReadableByteChannel getChannel() throws IllegalStateException, IOException {
        if (this.channel == null) {
            InputStream inputStream;
            Object object = this.getInput();
            this.channel = object instanceof ReadableByteChannel ? (ReadableByteChannel)object : ((inputStream = this.getInputStream()) instanceof FileInputStream ? ((FileInputStream)inputStream).getChannel() : Channels.newChannel(inputStream));
        }
        return this.channel;
    }

    @Override
    protected void close() throws IOException {
        super.close();
        if (this.closeOnReset != null) {
            if (this.channel != null) {
                this.channel.close();
            }
            this.closeOnReset.close();
            this.closeOnReset = null;
        }
        this.channel = null;
        this.stream = null;
    }

    protected void finalize() throws Throwable {
        this.closeSilently();
        super.finalize();
    }

    protected static abstract class Spi
    extends SpatialImageReader.Spi {
        private static final Class<?>[] INPUT_TYPES = new Class[]{File.class, URI.class, URL.class, URLConnection.class, InputStream.class, ImageInputStream.class, ReadableByteChannel.class, String.class};

        protected Spi() {
            this.inputTypes = INPUT_TYPES;
        }
    }
}

