/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import net.jcip.annotations.Immutable;
import org.apache.sis.math.MathFunctions;
import org.geotoolkit.util.converter.Classes;

@Immutable
public abstract class SampleConverter {
    public static final SampleConverter IDENTITY = new Identity();

    protected SampleConverter() {
    }

    public static SampleConverter createPadValueMask(double d) {
        return Double.isNaN(d) ? IDENTITY : new PadValueMask(d);
    }

    public static SampleConverter createPadValuesMask(double[] dArray) {
        if (dArray != null) {
            switch (dArray.length) {
                default: {
                    return new PadValuesMask(dArray);
                }
                case 1: {
                    return SampleConverter.createPadValueMask(dArray[0]);
                }
                case 0: 
            }
        }
        return IDENTITY;
    }

    public static SampleConverter createOffset(double d, double d2) {
        return d == 0.0 ? SampleConverter.createPadValueMask(d2) : new Offset(d, d2);
    }

    public static SampleConverter createOffset(double d, double[] dArray) {
        if (d == 0.0) {
            return SampleConverter.createPadValuesMask(dArray);
        }
        if (dArray != null) {
            switch (dArray.length) {
                default: {
                    return new MaskAndOffset(d, dArray);
                }
                case 1: {
                    return SampleConverter.createOffset(d, dArray[0]);
                }
                case 0: 
            }
        }
        return SampleConverter.createOffset(d, Double.NaN);
    }

    public abstract double convert(double var1);

    public abstract float convert(float var1);

    public abstract int convert(int var1);

    public void convert(double[] dArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            dArray[n] = this.convert(dArray[n]);
            ++n;
        }
    }

    public void convert(float[] fArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            fArray[n] = this.convert(fArray[n]);
            ++n;
        }
    }

    public void convert(int[] nArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            nArray[n] = this.convert(nArray[n]);
            ++n;
        }
    }

    public void convert(short[] sArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            sArray[n] = (short)this.convert(sArray[n]);
            ++n;
        }
    }

    public void convertUnsigned(short[] sArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            sArray[n] = (short)this.convert(sArray[n] & 0xFFFF);
            ++n;
        }
    }

    public void convertUnsigned(byte[] byArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            byArray[n] = (byte)this.convert(byArray[n] & 0xFF);
            ++n;
        }
    }

    public double getOffset() {
        return 0.0;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + "[offset=" + this.getOffset() + ']';
    }

    @Immutable
    private static final class MaskAndOffset
    extends PadValuesMask {
        private final double doubleOffset;
        private final float floatOffset;

        MaskAndOffset(double d, double[] dArray) {
            super(dArray);
            this.doubleOffset = d;
            this.floatOffset = (float)d;
        }

        @Override
        public double convert(double d) {
            return super.convert(d) + this.doubleOffset;
        }

        @Override
        public float convert(float f) {
            return super.convert(f) + this.floatOffset;
        }

        @Override
        public double getOffset() {
            return this.doubleOffset;
        }
    }

    @Immutable
    private static class PadValuesMask
    extends SampleConverter {
        private final double[] doubleValues;
        private final float[] floatValues;
        private final float[] NaNs;

        PadValuesMask(double[] dArray) {
            this.doubleValues = new double[dArray.length];
            this.floatValues = new float[dArray.length];
            this.NaNs = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.doubleValues[i] = dArray[i];
                this.floatValues[i] = (float)this.doubleValues[i];
                this.NaNs[i] = MathFunctions.toNanFloat((int)i);
            }
        }

        @Override
        public double convert(double d) {
            for (int i = 0; i < this.doubleValues.length; ++i) {
                if (d != this.doubleValues[i]) continue;
                return this.NaNs[i];
            }
            return d;
        }

        @Override
        public float convert(float f) {
            for (int i = 0; i < this.floatValues.length; ++i) {
                if (f != this.floatValues[i]) continue;
                return this.NaNs[i];
            }
            return f;
        }

        @Override
        public final int convert(int n) {
            return (int)this.convert((double)n);
        }
    }

    @Immutable
    private static final class Offset
    extends PadValueMask {
        private final double doubleOffset;
        private final float floatOffset;
        private final int integerOffset;

        Offset(double d, double d2) {
            super(d2);
            this.doubleOffset = d;
            this.floatOffset = (float)d;
            this.integerOffset = (int)Math.round(d);
        }

        @Override
        public double convert(double d) {
            return d == this.doubleValue ? Double.NaN : d + this.doubleOffset;
        }

        @Override
        public float convert(float f) {
            return f == this.floatValue ? Float.NaN : f + this.floatOffset;
        }

        @Override
        public int convert(int n) {
            return n == this.integerValue ? 0 : n + this.integerOffset;
        }

        @Override
        public double getOffset() {
            return this.doubleOffset;
        }
    }

    @Immutable
    private static class PadValueMask
    extends SampleConverter {
        final double doubleValue;
        final float floatValue;
        final int integerValue;

        PadValueMask(double d) {
            this.doubleValue = d;
            this.floatValue = (float)d;
            int n = (int)d;
            this.integerValue = (double)n == d ? n : 0;
        }

        @Override
        public double convert(double d) {
            return d == this.doubleValue ? Double.NaN : d;
        }

        @Override
        public float convert(float f) {
            return f == this.floatValue ? Float.NaN : f;
        }

        @Override
        public int convert(int n) {
            return n == this.integerValue ? 0 : n;
        }
    }

    @Immutable
    private static final class Identity
    extends SampleConverter {
        private Identity() {
        }

        @Override
        public double convert(double d) {
            return d;
        }

        @Override
        public float convert(float f) {
            return f;
        }

        @Override
        public int convert(int n) {
            return n;
        }

        @Override
        public void convert(double[] dArray, int n, int n2) {
        }

        @Override
        public void convert(float[] fArray, int n, int n2) {
        }

        @Override
        public void convert(int[] nArray, int n, int n2) {
        }

        @Override
        public void convert(short[] sArray, int n, int n2) {
        }

        @Override
        public void convertUnsigned(short[] sArray, int n, int n2) {
        }

        @Override
        public void convertUnsigned(byte[] byArray, int n, int n2) {
        }
    }
}

