/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Point;
import java.awt.Rectangle;
import javax.imageio.IIOParam;
import javax.imageio.ImageWriteParam;
import org.geotoolkit.image.io.DimensionIdentification;
import org.geotoolkit.image.io.DimensionSet;
import org.geotoolkit.image.io.MultidimensionalImageStore;
import org.geotoolkit.image.io.SpatialImageReadParam;
import org.geotoolkit.image.io.SpatialImageWriteParam;

public class DimensionSlice
extends DimensionIdentification {
    private int index;

    DimensionSlice(DimensionSet dimensionSet) {
        super(dimensionSet);
    }

    protected DimensionSlice(DimensionSlice dimensionSlice) {
        super(dimensionSlice);
        this.index = dimensionSlice.index;
    }

    private IIOParam getParameters() {
        return (IIOParam)this.owner.owner;
    }

    private API getAPI() {
        IIOParam iIOParam = this.getParameters();
        Object object = null;
        if (iIOParam instanceof SpatialImageReadParam) {
            object = ((SpatialImageReadParam)iIOParam).reader;
        } else if (iIOParam instanceof SpatialImageWriteParam) {
            object = ((SpatialImageWriteParam)iIOParam).writer;
        }
        if (object instanceof MultidimensionalImageStore) {
            return ((MultidimensionalImageStore)object).getAPIForDimension(this.getDimensionIds());
        }
        return API.NONE;
    }

    public int getSliceIndex() {
        boolean bl;
        switch (this.getAPI()) {
            case COLUMNS: {
                bl = false;
                break;
            }
            case ROWS: {
                bl = true;
                break;
            }
            case BANDS: {
                IIOParam iIOParam = this.getParameters();
                if (!(iIOParam instanceof ImageWriteParam)) {
                    int[] nArray = iIOParam.getSourceBands();
                    return nArray != null && nArray.length != 0 ? nArray[0] : 0;
                }
            }
            default: {
                return this.index;
            }
        }
        IIOParam iIOParam = this.getParameters();
        if (iIOParam instanceof ImageWriteParam) {
            Point point = iIOParam.getDestinationOffset();
            if (point != null) {
                return bl ? point.y : point.x;
            }
        } else {
            Rectangle rectangle = iIOParam.getSourceRegion();
            if (rectangle != null) {
                return bl ? rectangle.y : rectangle.x;
            }
        }
        return 0;
    }

    public void setSliceIndex(int n) {
        boolean bl;
        switch (this.getAPI()) {
            case COLUMNS: {
                bl = false;
                break;
            }
            case ROWS: {
                bl = true;
                break;
            }
            case BANDS: {
                IIOParam iIOParam = this.getParameters();
                if (!(iIOParam instanceof ImageWriteParam)) {
                    iIOParam.setSourceBands(new int[]{n});
                    return;
                }
            }
            default: {
                this.index = n;
                return;
            }
        }
        IIOParam iIOParam = this.getParameters();
        if (iIOParam instanceof ImageWriteParam) {
            Point point = iIOParam.getDestinationOffset();
            if (bl) {
                point.y = n;
            } else {
                point.x = n;
            }
            iIOParam.setDestinationOffset(point);
        } else {
            Rectangle rectangle = iIOParam.getSourceRegion();
            if (rectangle == null) {
                rectangle = new Rectangle(1, 1);
            }
            if (bl) {
                rectangle.y = n;
                rectangle.height = 1;
            } else {
                rectangle.x = n;
                rectangle.width = 1;
            }
            iIOParam.setSourceRegion(rectangle);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder().append("}, sliceIndex=").append(this.getSliceIndex());
        API aPI = this.getAPI();
        if (aPI != API.NONE) {
            stringBuilder.append(", API=").append(aPI.name());
        }
        return stringBuilder.append(']').toString();
    }

    public static enum API {
        COLUMNS,
        ROWS,
        BANDS,
        IMAGES,
        NONE;

        static final API[] VALIDS;

        static {
            VALIDS = new API[]{COLUMNS, ROWS, BANDS, IMAGES};
        }
    }
}

