/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.LogRecord;
import javax.imageio.IIOParam;
import org.apache.sis.util.Localized;
import org.geotoolkit.image.io.DimensionIdentification;
import org.geotoolkit.image.io.DimensionSlice;
import org.geotoolkit.image.io.MultidimensionalImageStore;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.collection.XCollections;

public class DimensionSet
extends AbstractSet<DimensionIdentification>
implements WarningProducer {
    final Object owner;
    private Map<Object, DimensionIdentification> identifiersMap;
    APIs apiMapping;
    private transient Set<DimensionIdentification> dimensions;

    public DimensionSet(MultidimensionalImageStore multidimensionalImageStore) {
        this.owner = multidimensionalImageStore;
    }

    DimensionSet(IIOParam iIOParam) {
        this.owner = iIOParam;
    }

    @Override
    public void clear() {
        XCollections.clear(this.identifiersMap);
        this.dimensions = null;
    }

    final Map<Object, DimensionIdentification> identifiersMap() {
        return this.identifiersMap != null ? this.identifiersMap : Collections.emptyMap();
    }

    @Override
    public boolean isEmpty() {
        return XCollections.isNullOrEmpty(this.identifiersMap);
    }

    @Override
    public int size() {
        return this.dimensions().size();
    }

    @Override
    public Iterator<DimensionIdentification> iterator() {
        return this.dimensions().iterator();
    }

    @Override
    public boolean contains(Object object) {
        return this.dimensions().contains(object);
    }

    private Set<DimensionIdentification> dimensions() {
        if (this.dimensions == null) {
            this.dimensions = this.identifiersMap != null ? XCollections.unmodifiableSet(new LinkedHashSet<DimensionIdentification>(this.identifiersMap.values())) : Collections.emptySet();
        }
        return this.dimensions;
    }

    public DimensionIdentification get(DimensionSlice.API aPI) {
        if (aPI == null) {
            throw new NullArgumentException(Warnings.message((Localized)this, 172, "api"));
        }
        if (aPI != DimensionSlice.API.NONE && this.apiMapping != null) {
            return this.apiMapping.dimensions[aPI.ordinal()];
        }
        return null;
    }

    public DimensionIdentification getOrCreate(DimensionSlice.API aPI) {
        DimensionIdentification dimensionIdentification = this.get(aPI);
        if (dimensionIdentification == null) {
            dimensionIdentification = new DimensionIdentification(this, aPI);
        }
        return dimensionIdentification;
    }

    public DimensionSlice.API getAPI(Object ... objectArray) {
        DimensionIdentification dimensionIdentification;
        if (this.apiMapping != null && (dimensionIdentification = this.find(DimensionSet.class, "getAPI", objectArray)) != null) {
            DimensionIdentification[] dimensionIdentificationArray = this.apiMapping.dimensions;
            int n = dimensionIdentificationArray.length;
            while (--n >= 0) {
                if (dimensionIdentificationArray[n] != dimensionIdentification) continue;
                return DimensionSlice.API.VALIDS[n];
            }
        }
        return DimensionSlice.API.NONE;
    }

    public Set<DimensionSlice.API> getAPIs() {
        if (this.apiMapping == null) {
            this.apiMapping = new APIs();
        }
        return this.apiMapping;
    }

    final DimensionIdentification[] apiMapping() {
        if (this.apiMapping == null) {
            this.apiMapping = new APIs();
        }
        return this.apiMapping.dimensions;
    }

    public Locale getLocale() {
        return this.owner instanceof Localized ? ((Localized)this.owner).getLocale() : null;
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        return Warnings.log(this.owner, logRecord);
    }

    final void addDimensionId(DimensionIdentification dimensionIdentification, Object object) throws IllegalArgumentException {
        DimensionIdentification dimensionIdentification2;
        if (this.identifiersMap == null) {
            this.identifiersMap = new LinkedHashMap<Object, DimensionIdentification>();
        }
        if ((dimensionIdentification2 = this.identifiersMap.put(object, dimensionIdentification)) != null && !dimensionIdentification2.equals(dimensionIdentification)) {
            this.identifiersMap.put(object, dimensionIdentification2);
            throw new IllegalArgumentException(Errors.getResources((Locale)this.getLocale()).getString(245, object));
        }
        this.dimensions = null;
    }

    final void removeDimensionId(DimensionIdentification dimensionIdentification, Object[] objectArray) {
        if (this.identifiersMap != null) {
            for (Object object : objectArray) {
                DimensionIdentification dimensionIdentification2 = this.identifiersMap.remove(object);
                if (dimensionIdentification2 == null || dimensionIdentification2.equals(dimensionIdentification)) continue;
                this.identifiersMap.put(object, dimensionIdentification2);
            }
            this.dimensions = null;
        }
    }

    final int getSliceIndex(Class<? extends WarningProducer> clazz, Object[] objectArray) {
        if (this.identifiersMap != null) {
            LinkedHashMap<Integer, Object> linkedHashMap = null;
            for (Object object : objectArray) {
                Object object2;
                DimensionSlice dimensionSlice = (DimensionSlice)this.identifiersMap.get(object);
                if (dimensionSlice == null) continue;
                Integer n = dimensionSlice.getSliceIndex();
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<Integer, Object>(4);
                }
                if ((object2 = linkedHashMap.put(n, object)) == null) continue;
                linkedHashMap.put(n, object2);
            }
            Integer n = (Integer)DimensionSet.first(linkedHashMap, this, clazz, "getSliceIndex");
            if (n != null) {
                return n;
            }
        }
        return 0;
    }

    final DimensionIdentification getDimensionSlice(Class<? extends WarningProducer> clazz, Object[] objectArray) {
        return this.find(clazz, "getDimensionSlice", objectArray);
    }

    private DimensionIdentification find(Class<? extends WarningProducer> clazz, String string, Object[] objectArray) {
        if (this.identifiersMap != null) {
            LinkedHashMap<DimensionIdentification, Object> linkedHashMap = null;
            for (Object object : objectArray) {
                Object object2;
                DimensionIdentification dimensionIdentification = this.identifiersMap.get(object);
                if (dimensionIdentification == null) continue;
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<DimensionIdentification, Object>(4);
                }
                if ((object2 = linkedHashMap.put(dimensionIdentification, object)) == null) continue;
                linkedHashMap.put(dimensionIdentification, object2);
            }
            DimensionIdentification dimensionIdentification = (DimensionIdentification)DimensionSet.first(linkedHashMap, this, clazz, string);
            if (dimensionIdentification != null) {
                return dimensionIdentification;
            }
        }
        return null;
    }

    static <T> T first(Map<T, ?> map, WarningProducer warningProducer, Class<? extends WarningProducer> clazz, String string) {
        int n;
        if (map != null && (n = map.size()) != 0) {
            if (n > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object : map.values()) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(" | ");
                    }
                    stringBuilder.append(object);
                }
                Object object = Warnings.message((Localized)warningProducer, 1, stringBuilder);
                stringBuilder.setLength(0);
                stringBuilder.append((String)object);
                for (Object e : map.keySet()) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ').append(e);
                }
                object = stringBuilder.toString();
                Warnings.log(warningProducer, null, clazz, string, (String)object);
            }
            return map.keySet().iterator().next();
        }
        return null;
    }

    private static final class Iter
    implements Iterator<DimensionSlice.API> {
        private final DimensionIdentification[] dimensions;
        private int index;
        private DimensionSlice.API next;

        Iter(DimensionIdentification[] dimensionIdentificationArray) {
            this.dimensions = dimensionIdentificationArray;
            this.search();
        }

        private void search() {
            while (this.index < this.dimensions.length) {
                int n;
                ++this.index;
                DimensionIdentification dimensionIdentification = this.dimensions[n];
                if (dimensionIdentification == null || !dimensionIdentification.hasDimensionIds()) continue;
                this.next = DimensionSlice.API.VALIDS[n];
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DimensionSlice.API next() {
            DimensionSlice.API aPI = this.next;
            if (aPI == null) {
                throw new NoSuchElementException();
            }
            this.search();
            return aPI;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class APIs
    extends AbstractSet<DimensionSlice.API> {
        final DimensionIdentification[] dimensions = new DimensionIdentification[DimensionSlice.API.VALIDS.length];

        APIs() {
        }

        @Override
        public int size() {
            int n = 0;
            Iterator<DimensionSlice.API> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
            }
            return n;
        }

        @Override
        public boolean contains(Object object) {
            DimensionIdentification dimensionIdentification;
            if (object instanceof DimensionSlice.API && (dimensionIdentification = this.dimensions[((DimensionSlice.API)((Object)object)).ordinal()]) != null) {
                return dimensionIdentification.hasDimensionIds();
            }
            return false;
        }

        @Override
        public Iterator<DimensionSlice.API> iterator() {
            return new Iter(this.dimensions);
        }
    }
}

