/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GeneralGridGeometry;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageReadParam;
import org.geotoolkit.coverage.io.GridCoverageReader;
import org.geotoolkit.coverage.io.ImageCoverageReader;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ImageReaderAdapter
extends SpatialImageReader {
    private static final int VISIBLE_BAND = 0;
    protected final GridCoverageReader reader;
    private int numImages;
    private final Map<Integer, Dimension> imageSizes = new HashMap<Integer, Dimension>();
    private final Map<Integer, ImageTypeSpecifier> imageTypes = new HashMap<Integer, ImageTypeSpecifier>();

    public ImageReaderAdapter(GridCoverageReader gridCoverageReader) {
        super(null);
        if (gridCoverageReader == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"reader"));
        }
        this.reader = gridCoverageReader;
    }

    @Override
    public ImageReaderSpi getOriginatingProvider() {
        ImageReader imageReader;
        if (this.reader instanceof ImageCoverageReader && (imageReader = ((ImageCoverageReader)this.reader).imageReader) != null) {
            return imageReader.getOriginatingProvider();
        }
        return super.getOriginatingProvider();
    }

    private static IOException convert(CoverageStoreException coverageStoreException) {
        Throwable throwable = coverageStoreException.getCause();
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IIOException(coverageStoreException.getLocalizedMessage(), (Throwable)((Object)coverageStoreException));
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        this.input = null;
        this.numImages = 0;
        this.imageSizes.clear();
        this.imageTypes.clear();
        super.dispose();
        try {
            this.reader.setInput(object);
        }
        catch (CoverageStoreException coverageStoreException) {
            throw new IllegalArgumentException((Throwable)((Object)coverageStoreException));
        }
        this.input = object;
        this.seekForwardOnly = bl;
        this.ignoreMetadata = bl2;
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        if (this.numImages == 0) {
            try {
                this.numImages = this.reader.getCoverageNames().size();
            }
            catch (CoverageStoreException coverageStoreException) {
                throw ImageReaderAdapter.convert(coverageStoreException);
            }
        }
        return this.numImages;
    }

    @Override
    public int getNumBands(int n) throws IOException {
        List<GridSampleDimension> list;
        try {
            list = this.reader.getSampleDimensions(n);
        }
        catch (CoverageStoreException coverageStoreException) {
            throw ImageReaderAdapter.convert(coverageStoreException);
        }
        return list != null ? list.size() : 1;
    }

    @Override
    public int getDimension(int n) throws IOException {
        try {
            return this.reader.getGridGeometry(n).getDimension();
        }
        catch (CoverageStoreException coverageStoreException) {
            throw ImageReaderAdapter.convert(coverageStoreException);
        }
    }

    @Override
    public GridEnvelope getGridEnvelope(int n) throws IOException {
        try {
            return this.reader.getGridGeometry(n).getExtent();
        }
        catch (CoverageStoreException coverageStoreException) {
            throw ImageReaderAdapter.convert(coverageStoreException);
        }
    }

    protected Dimension getSize(int n) throws IOException {
        Integer n2 = n;
        Dimension dimension = this.imageSizes.get(n2);
        if (dimension == null) {
            GeneralGridGeometry generalGridGeometry;
            try {
                generalGridGeometry = this.reader.getGridGeometry(n);
            }
            catch (CoverageStoreException coverageStoreException) {
                throw ImageReaderAdapter.convert(coverageStoreException);
            }
            GridEnvelope gridEnvelope = generalGridGeometry.getExtent();
            dimension = new Dimension(gridEnvelope.getSpan(0), gridEnvelope.getSpan(1));
            this.imageSizes.put(n2, dimension);
        }
        return dimension;
    }

    @Override
    public final int getWidth(int n) throws IOException {
        return this.getSize((int)n).width;
    }

    @Override
    public final int getHeight(int n) throws IOException {
        return this.getSize((int)n).height;
    }

    @Override
    protected int getRawDataType(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        return imageTypeSpecifier != null ? imageTypeSpecifier.getSampleModel().getDataType() : super.getRawDataType(n);
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        Integer n2 = n;
        ImageTypeSpecifier imageTypeSpecifier = this.imageTypes.get(n2);
        if (imageTypeSpecifier == null) {
            int n3;
            List<GridSampleDimension> list;
            try {
                list = this.reader.getSampleDimensions(n);
            }
            catch (CoverageStoreException coverageStoreException) {
                throw ImageReaderAdapter.convert(coverageStoreException);
            }
            if (list != null && (n3 = list.size()) > 0) {
                Dimension dimension = this.getSize(n);
                ColorModel colorModel = list.get(0).getColorModel(0, list.size());
                SampleModel sampleModel = colorModel.createCompatibleSampleModel(dimension.width, dimension.height);
                imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
            }
            this.imageTypes.put(n2, imageTypeSpecifier);
        }
        return imageTypeSpecifier;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        Set<Object> set = imageTypeSpecifier != null ? Collections.singleton(imageTypeSpecifier) : Collections.emptySet();
        return set.iterator();
    }

    @Override
    protected SpatialMetadata createMetadata(int n) throws IOException {
        try {
            return n < 0 ? this.reader.getStreamMetadata() : this.reader.getCoverageMetadata(n);
        }
        catch (CoverageStoreException coverageStoreException) {
            throw ImageReaderAdapter.convert(coverageStoreException);
        }
    }

    @Override
    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        GridCoverage gridCoverage;
        GridCoverageReadParam gridCoverageReadParam = null;
        if (imageReadParam != null) {
            gridCoverageReadParam = new GridCoverageReadParam();
            gridCoverageReadParam.setSourceBands(imageReadParam.getSourceBands());
            gridCoverageReadParam.setDestinationBands(imageReadParam.getDestinationBands());
            try {
                gridCoverage = this.reader.getGridGeometry(n);
            }
            catch (CoverageStoreException coverageStoreException) {
                throw ImageReaderAdapter.convert(coverageStoreException);
            }
            GridEnvelope gridEnvelope = gridCoverage.getExtent();
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            ImageReaderAdapter.computeRegions(imageReadParam, gridEnvelope.getSpan(0), gridEnvelope.getSpan(1), null, rectangle, rectangle2);
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(gridEnvelope.getDimension());
            int n2 = generalEnvelope.getDimension();
            while (--n2 >= 0) {
                double d;
                double d2;
                switch (n2) {
                    case 0: {
                        d2 = rectangle.getMinX();
                        d = rectangle.getMaxX();
                        break;
                    }
                    case 1: {
                        d2 = rectangle.getMinY();
                        d = rectangle.getMaxY();
                        break;
                    }
                    default: {
                        d2 = 0.0;
                        d = 1.0;
                    }
                }
                generalEnvelope.setRange(n2, d2, d);
            }
            try {
                generalEnvelope = Envelopes.transform((MathTransform)gridCoverage.getGridToCRS(PixelInCell.CELL_CORNER), (Envelope)generalEnvelope);
            }
            catch (TransformException transformException) {
                throw new IIOException(transformException.getLocalizedMessage(), transformException);
            }
            gridCoverageReadParam.setEnvelope((Envelope)generalEnvelope);
            n2 = imageReadParam.getSourceXSubsampling();
            int n3 = imageReadParam.getSourceYSubsampling();
            if (n2 != 1 || n3 != 1) {
                double[] dArray = new double[generalEnvelope.getDimension()];
                dArray[0] = (double)n2 * generalEnvelope.getSpan(0) / rectangle.getWidth();
                dArray[1] = (double)n3 * generalEnvelope.getSpan(1) / rectangle.getHeight();
                gridCoverageReadParam.setResolution(dArray);
            }
        }
        return (gridCoverage = this.read(n, gridCoverageReadParam)) == null ? null : gridCoverage.getRenderableImage(0, 1).createDefaultRendering();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        RenderedImage renderedImage = this.readAsRenderedImage(n, imageReadParam);
        while (renderedImage instanceof RenderedImageAdapter) {
            renderedImage = ((RenderedImageAdapter)renderedImage).getWrappedImage();
        }
        if (renderedImage instanceof PlanarImage) {
            return ((PlanarImage)renderedImage).getAsBufferedImage();
        }
        return (BufferedImage)renderedImage;
    }

    protected GridCoverage read(int n, GridCoverageReadParam gridCoverageReadParam) throws IOException {
        try {
            return this.reader.read(n, gridCoverageReadParam);
        }
        catch (CoverageStoreException coverageStoreException) {
            throw ImageReaderAdapter.convert(coverageStoreException);
        }
        catch (CancellationException cancellationException) {
            return null;
        }
    }

    @Override
    public void abort() {
        this.reader.abort();
    }

    @Override
    public void dispose() {
        try {
            this.reader.dispose();
        }
        catch (CoverageStoreException coverageStoreException) {
            Logging.unexpectedException(this.getClass(), (String)"dispose", (Throwable)((Object)coverageStoreException));
        }
        super.dispose();
    }
}

