/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.BackingStoreException;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridCoverageBuilder;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageReadParam;
import org.geotoolkit.coverage.io.GridCoverageReader;
import org.geotoolkit.coverage.io.ImageCoverageStore;
import org.geotoolkit.coverage.io.NameList;
import org.geotoolkit.coverage.io.SampleDimensionPalette;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.image.io.DimensionSlice;
import org.geotoolkit.image.io.ImageMetadataException;
import org.geotoolkit.image.io.NamedImageStore;
import org.geotoolkit.image.io.SampleConversionType;
import org.geotoolkit.image.io.SpatialImageReadParam;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.XImageIO;
import org.geotoolkit.image.io.metadata.MetadataHelper;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.mosaic.MosaicImageReadParam;
import org.geotoolkit.internal.image.io.CheckedImageInputStream;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultImageCRS;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.RectifiedGrid;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;

public class ImageCoverageReader
extends GridCoverageReader {
    private static final Set<String> METADATA_NODES;
    protected ImageReader imageReader;
    protected Boolean seekForwardOnly;
    protected Boolean ignoreMetadata;
    private transient List<? extends GenericName> coverageNames;
    private transient Map<Integer, GridGeometry2D> gridGeometries;
    private transient Map<Integer, List<GridSampleDimension>> sampleDimensions;
    private transient SpatialMetadata imageMetadata;
    private transient int imageMetadataIndex;
    private transient MetadataHelper helper;
    private final GridCoverageBuilder coverageBuilder;
    protected final NameFactory nameFactory;

    public ImageCoverageReader() {
        this(null);
    }

    public ImageCoverageReader(Hints hints) {
        this.coverageBuilder = new GridCoverageBuilder(hints);
        this.nameFactory = FactoryFinder.getNameFactory((Hints)hints);
        this.imageMetadataIndex = -1;
    }

    @Override
    public void setLogLevel(Level level) {
        super.setLogLevel(level);
        this.copyLevel(this.imageReader);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        ImageCoverageReader.setLocale(this.imageReader, locale);
        this.helper = null;
    }

    private static void setLocale(ImageReader imageReader, Locale locale) {
        if (imageReader != null) {
            imageReader.setLocale(ImageCoverageReader.select(locale, imageReader.getAvailableLocales()));
        }
    }

    @Override
    public void setInput(Object object) throws CoverageStoreException {
        ImageReader imageReader = this.imageReader;
        try {
            this.close();
            assert (imageReader == null || imageReader.getInput() == null) : imageReader;
            if (object != null) {
                ImageReader imageReader2 = null;
                if (object instanceof ImageReader) {
                    imageReader2 = (ImageReader)object;
                } else {
                    Object object2;
                    if (imageReader != null && (object2 = imageReader.getOriginatingProvider()) != null && this.canReuseImageReader((ImageReaderSpi)object2, object)) {
                        imageReader2 = imageReader;
                    }
                    if (imageReader2 == null) {
                        imageReader2 = this.createImageReader(object);
                    }
                    if (imageReader2 != object && imageReader2.getInput() == null) {
                        object2 = object;
                        ImageReaderSpi imageReaderSpi = imageReader2.getOriginatingProvider();
                        if (imageReaderSpi != null) {
                            boolean bl = false;
                            for (Class<ImageInputStream> clazz : imageReaderSpi.getInputTypes()) {
                                if (clazz.isInstance(object2)) {
                                    bl = false;
                                    break;
                                }
                                if (!clazz.isAssignableFrom(ImageInputStream.class)) continue;
                                bl = true;
                            }
                            if (bl) {
                                object2 = ImageIO.createImageInputStream(object);
                                assert (CheckedImageInputStream.isValid((ImageInputStream)(object2 = CheckedImageInputStream.wrap((ImageInputStream)object2))));
                                if (object2 == null) {
                                    Object object3;
                                    int n;
                                    if (IOUtilities.canProcessAsPath((Object)object)) {
                                        n = 31;
                                        object3 = IOUtilities.name((Object)object);
                                    } else {
                                        n = 226;
                                        object3 = object.getClass();
                                    }
                                    throw new CoverageStoreException(Errors.getResources((Locale)this.locale).getString(n, object3));
                                }
                            }
                        }
                        if (this.seekForwardOnly != null) {
                            if (this.ignoreMetadata != null) {
                                imageReader2.setInput(object2, this.seekForwardOnly, this.ignoreMetadata);
                            } else {
                                imageReader2.setInput(object2, this.seekForwardOnly);
                            }
                        } else {
                            imageReader2.setInput(object2);
                        }
                    }
                }
                if (imageReader2 != imageReader) {
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    this.copyLevel(imageReader2);
                    ImageCoverageReader.setLocale(imageReader2, this.locale);
                    if (LOGGER.isLoggable(this.getFineLevel())) {
                        ImageCoverageStore.logCodecCreation(this, ImageCoverageReader.class, imageReader2, imageReader2.getOriginatingProvider());
                    }
                }
                this.imageReader = imageReader2;
            }
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(object, iOException, false), iOException);
        }
        super.setInput(object);
    }

    protected boolean canReuseImageReader(ImageReaderSpi imageReaderSpi, Object object) throws IOException {
        if (IOUtilities.canProcessAsPath((Object)object)) {
            String[] stringArray = imageReaderSpi.getFileSuffixes();
            return stringArray != null && ArraysExt.containsIgnoreCase((String[])stringArray, (String)IOUtilities.extension((Object)object));
        }
        return imageReaderSpi.canDecodeInput(object);
    }

    protected ImageReader createImageReader(Object object) throws IOException {
        return XImageIO.getReaderBySuffix(object, this.seekForwardOnly, this.ignoreMetadata);
    }

    protected ImageReadParam createImageReadParam(int n) throws IOException {
        return this.imageReader.getDefaultReadParam();
    }

    @Override
    public List<? extends GenericName> getCoverageNames() throws CoverageStoreException {
        if (this.coverageNames == null) {
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                throw new IllegalStateException(this.formatErrorMessage(156));
            }
            try {
                List<String> list = null;
                if (imageReader instanceof NamedImageStore) {
                    list = ((NamedImageStore)((Object)imageReader)).getImageNames();
                }
                this.coverageNames = list != null ? new NameList(this.nameFactory, list) : new NameList(this.nameFactory, this.getInputName(), imageReader.getNumImages(true));
            }
            catch (IOException iOException) {
                throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
            }
        }
        return this.coverageNames;
    }

    private MetadataHelper getMetadataHelper() {
        if (this.helper == null) {
            this.helper = new MetadataHelper((Localized)this);
        }
        return this.helper;
    }

    public GridGeometry2D getGridGeometry(int n) throws CoverageStoreException {
        GridGeometry2D gridGeometry2D = ImageCoverageReader.getCached(this.gridGeometries, n);
        if (gridGeometry2D == null) {
            Object object;
            Object object2;
            int n2;
            int n3;
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                throw new IllegalStateException(this.formatErrorMessage(156));
            }
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            MathTransform mathTransform = null;
            PixelOrientation pixelOrientation = null;
            try {
                n3 = imageReader.getWidth(n);
                n2 = imageReader.getHeight(n);
                SpatialMetadata spatialMetadata = this.getImageMetadata(imageReader, n);
                if (spatialMetadata != null) {
                    coordinateReferenceSystem = spatialMetadata.getInstanceForType(CoordinateReferenceSystem.class);
                    if (coordinateReferenceSystem instanceof GridGeometry) {
                        mathTransform = ((GridGeometry)coordinateReferenceSystem).getGridToCRS();
                    } else {
                        object2 = spatialMetadata.getInstanceForType(RectifiedGrid.class);
                        if (object2 != null) {
                            mathTransform = this.getMetadataHelper().getGridToCRS((RectifiedGrid)object2);
                        }
                        if ((object = (Object)spatialMetadata.getInstanceForType(Georectified.class)) != null) {
                            pixelOrientation = object.getPointInPixel();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
            }
            if (coordinateReferenceSystem == null) {
                coordinateReferenceSystem = DefaultImageCRS.GRID_2D;
            }
            int n4 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            if (mathTransform == null) {
                mathTransform = MathTransforms.identity((int)n4);
            }
            if (pixelOrientation == null) {
                pixelOrientation = PixelOrientation.CENTER;
            }
            object2 = new int[n4];
            object = new int[n4];
            Arrays.fill(object, 1);
            object[0] = n3;
            object[1] = n2;
            GeneralGridEnvelope generalGridEnvelope = new GeneralGridEnvelope((int[])object2, object, false);
            gridGeometry2D = new GridGeometry2D((GridEnvelope)generalGridEnvelope, pixelOrientation, mathTransform, coordinateReferenceSystem, null);
            Map.Entry<Map<Integer, GridGeometry2D>, GridGeometry2D> entry = ImageCoverageReader.setCached(gridGeometry2D, this.gridGeometries, n);
            this.gridGeometries = entry.getKey();
            gridGeometry2D = entry.getValue();
        }
        return gridGeometry2D;
    }

    private static <T> T getCached(Map<Integer, T> map, int n) {
        return map != null ? (T)map.get(n) : null;
    }

    private static <T> Map.Entry<Map<Integer, T>, T> setCached(T t, Map<Integer, T> map, int n) {
        if (t != null) {
            if (map == null) {
                map = new HashMap<Integer, T>();
            }
            for (T t2 : map.values()) {
                if (!t2.equals(t)) continue;
                t = t2;
                break;
            }
            map.put(n, t);
        }
        return new AbstractMap.SimpleEntry<Map<Integer, T>, T>(map, t);
    }

    @Override
    public List<GridSampleDimension> getSampleDimensions(int n) throws CoverageStoreException {
        List<GridSampleDimension> list = ImageCoverageReader.getCached(this.sampleDimensions, n);
        if (list == null) {
            Object object;
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                throw new IllegalStateException(this.formatErrorMessage(156));
            }
            List<org.geotoolkit.image.io.metadata.SampleDimension> list2 = null;
            try {
                object = this.getImageMetadata(imageReader, n);
                if (object != null) {
                    list2 = ((SpatialMetadata)object).getListForType(org.geotoolkit.image.io.metadata.SampleDimension.class);
                }
            }
            catch (IOException iOException) {
                throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
            }
            if (XCollections.isNullOrEmpty(list2)) {
                list = Collections.emptyList();
            } else {
                try {
                    list = this.getMetadataHelper().getGridSampleDimensions(list2);
                }
                catch (ImageMetadataException imageMetadataException) {
                    throw new CoverageStoreException(this.formatErrorMessage(imageMetadataException), imageMetadataException);
                }
            }
            object = ImageCoverageReader.setCached(list, this.sampleDimensions, n);
            this.sampleDimensions = (Map)object.getKey();
            list = (List<GridSampleDimension>)object.getValue();
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private GridSampleDimension[] getSampleDimensions(int n, int[] nArray, int[] nArray2) throws CoverageStoreException {
        int n2;
        List<GridSampleDimension> list = this.getSampleDimensions(n);
        if (list != null && (n2 = list.size()) != 0) {
            if (nArray != null && nArray.length < n2) {
                n2 = nArray.length;
            }
            if (nArray2 != null && nArray2.length < n2) {
                n2 = nArray2.length;
            }
            GridSampleDimension[] gridSampleDimensionArray = new GridSampleDimension[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray != null ? nArray[i] : i;
                int n4 = nArray2 != null ? nArray2[i] : i;
                gridSampleDimensionArray[n4] = list.get(n3 % n2);
            }
            return gridSampleDimensionArray;
        }
        return null;
    }

    private static boolean isRangeSigned(GridSampleDimension[] gridSampleDimensionArray) {
        if (gridSampleDimensionArray != null) {
            for (GridSampleDimension gridSampleDimension : gridSampleDimensionArray) {
                if (gridSampleDimension == null || !gridSampleDimension.isRangeSigned()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SpatialMetadata getStreamMetadata() throws CoverageStoreException {
        ImageReader imageReader = this.imageReader;
        if (imageReader == null) {
            throw new IllegalStateException(this.formatErrorMessage(156));
        }
        try {
            IIOMetadata iIOMetadata = imageReader.getStreamMetadata();
            if (iIOMetadata instanceof SpatialMetadata) {
                return (SpatialMetadata)iIOMetadata;
            }
            if (iIOMetadata != null) {
                return new SpatialMetadata(true, imageReader, iIOMetadata);
            }
            return null;
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
    }

    @Override
    public SpatialMetadata getCoverageMetadata(int n) throws CoverageStoreException {
        ImageReader imageReader = this.imageReader;
        if (imageReader == null) {
            throw new IllegalStateException(this.formatErrorMessage(156));
        }
        try {
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(n);
            if (iIOMetadata instanceof SpatialMetadata) {
                return (SpatialMetadata)iIOMetadata;
            }
            if (iIOMetadata != null) {
                return new SpatialMetadata(false, imageReader, iIOMetadata);
            }
            return null;
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
    }

    private SpatialMetadata getImageMetadata(ImageReader imageReader, int n) throws IOException {
        if (this.imageMetadataIndex != n) {
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(n, "geotk-coverageio_3.07", METADATA_NODES);
            if (iIOMetadata == null || iIOMetadata instanceof SpatialMetadata) {
                this.imageMetadata = (SpatialMetadata)iIOMetadata;
            } else if (iIOMetadata != null) {
                this.imageMetadata = new SpatialMetadata(false, imageReader, iIOMetadata);
            }
            this.imageMetadataIndex = n;
        }
        return this.imageMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D read(int n, GridCoverageReadParam gridCoverageReadParam) throws CoverageStoreException, CancellationException {
        Level level;
        String string;
        Object object;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        int[] nArray;
        int[] nArray2;
        ImageReadParam imageReadParam;
        boolean bl = this.isLoggable();
        long l = bl ? System.nanoTime() : 0L;
        this.ignoreGridTransforms = !bl;
        this.abortRequested = false;
        ImageReader imageReader = this.imageReader;
        if (imageReader == null) {
            throw new IllegalStateException(this.formatErrorMessage(156));
        }
        GridGeometry2D gridGeometry2D = this.getGridGeometry(n);
        this.checkAbortState();
        try {
            imageReadParam = this.createImageReadParam(n);
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        MathTransform2D mathTransform2D = null;
        if (gridCoverageReadParam != null) {
            nArray2 = gridCoverageReadParam.getSourceBands();
            nArray = gridCoverageReadParam.getDestinationBands();
            if (nArray2 != null && nArray != null && nArray2.length != nArray.length) {
                throw new IllegalArgumentException(Errors.getResources((Locale)this.locale).getString(110, (Object)"sourceBands", (Object)"destinationBands"));
            }
            mathTransform2D = this.geodeticToPixelCoordinates(gridGeometry2D, gridCoverageReadParam, imageReadParam);
            imageReadParam.setSourceBands(nArray2);
            imageReadParam.setDestinationBands(nArray);
        } else {
            nArray2 = null;
            nArray = null;
        }
        if (imageReadParam instanceof MosaicImageReadParam) {
            ((MosaicImageReadParam)imageReadParam).setSubsamplingChangeAllowed(true);
        }
        boolean bl2 = false;
        GridSampleDimension[] gridSampleDimensionArray = this.getSampleDimensions(n, nArray2, nArray);
        if (imageReadParam instanceof SpatialImageReadParam) {
            int n3;
            int n4;
            object4 = (SpatialImageReadParam)imageReadParam;
            if (!ImageCoverageReader.isRangeSigned(gridSampleDimensionArray)) {
                ((SpatialImageReadParam)object4).setSampleConversionAllowed(SampleConversionType.SHIFT_SIGNED_INTEGERS, true);
            }
            ((SpatialImageReadParam)object4).setSampleConversionAllowed(SampleConversionType.REPLACE_FILL_VALUES, true);
            if (gridSampleDimensionArray != null && imageReader instanceof SpatialImageReader) {
                try {
                    bl2 = !((SpatialImageReader)imageReader).hasColors(n);
                }
                catch (IOException iOException) {
                    throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
                }
            }
            if (gridCoverageReadParam != null && !((SpatialImageReadParam)object4).hasDimensionSlices() && (n4 = gridGeometry2D.getDimension()) > 2 && (n3 = (object3 = gridGeometry2D.getCoordinateReferenceSystem()).getCoordinateSystem().getDimension()) > 2 && (object2 = gridCoverageReadParam.getEnvelope()) != null && object2.getDimension() > 2) {
                try {
                    if (object3 instanceof CompoundCRS) {
                        object2 = CRSUtilities.appendMissingDimensions((Envelope)object2, (CompoundCRS)((CompoundCRS)object3));
                    }
                    object2 = CRS.transform((Envelope)object2, (CoordinateReferenceSystem)object3);
                    double[] dArray = new double[n3];
                    for (int i = 0; i < n3; ++i) {
                        dArray[i] = object2.getMedian(i);
                    }
                    double[] dArray2 = new double[n4];
                    gridGeometry2D.getGridToCRS().inverse().transform(dArray, 0, dArray2, 0, 1);
                    GridEnvelope gridEnvelope = object3 instanceof GridGeometry ? ((GridGeometry)object3).getExtent() : null;
                    for (n2 = 0; n2 < n4; ++n2) {
                        double d;
                        if (n2 == gridGeometry2D.gridDimensionX || n2 == gridGeometry2D.gridDimensionY || Double.isNaN(d = dArray2[n2])) continue;
                        DimensionSlice dimensionSlice = ((SpatialImageReadParam)object4).newDimensionSlice();
                        dimensionSlice.addDimensionId(n2);
                        dimensionSlice.setSliceIndex((int)Math.round(Math.max(gridEnvelope != null ? (double)gridEnvelope.getLow(n2) : -2.147483648E9, Math.min(gridEnvelope != null ? (double)gridEnvelope.getHigh(n2) : 2.147483647E9, d))));
                    }
                }
                catch (TransformException transformException) {
                    throw new CoverageStoreException(this.formatErrorMessage(transformException), transformException);
                }
            }
        }
        object4 = this.getProperties(n);
        this.checkAbortState();
        try {
            object = this.getCoverageNames();
            try {
                object2 = n < object.size() ? object.get(n) : null;
                string = object2 != null ? object2.toString() : null;
            }
            catch (BackingStoreException backingStoreException) {
                throw (IOException)backingStoreException.unwrapOrRethrow(IOException.class);
            }
            if (bl2) {
                SampleDimensionPalette.BANDS.set(gridSampleDimensionArray);
                ((SpatialImageReadParam)imageReadParam).setPaletteFactory(SampleDimensionPalette.FACTORY);
            }
            object3 = imageReader.read(n, imageReadParam);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CoverageStoreException(this.formatErrorMessage(illegalArgumentException), illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        finally {
            if (bl2) {
                SampleDimensionPalette.BANDS.remove();
            }
        }
        if (gridCoverageReadParam != null) {
            Object object5;
            MathTransform mathTransform;
            object = imageReadParam.getSourceRegion();
            object2 = AffineTransform.getTranslateInstance(((Rectangle)object).x, ((Rectangle)object).y);
            ((AffineTransform)object2).scale(imageReadParam.getSourceXSubsampling(), imageReadParam.getSourceYSubsampling());
            int n5 = object3.getMinX();
            int n6 = object3.getMinY();
            int n7 = gridGeometry2D.gridDimensionX;
            n2 = gridGeometry2D.gridDimensionY;
            MathTransform mathTransform2 = mathTransform = gridGeometry2D.getGridToCRS(PixelInCell.CELL_CORNER);
            if (!((AffineTransform)object2).isIdentity()) {
                int n8 = mathTransform.getSourceDimensions();
                object5 = Matrices.create((int)(n8 + 1));
                object5.setElement(n7, n7, ((AffineTransform)object2).getScaleX());
                object5.setElement(n2, n2, ((AffineTransform)object2).getScaleY());
                object5.setElement(n7, n8, ((AffineTransform)object2).getTranslateX() - (double)n5);
                object5.setElement(n2, n8, ((AffineTransform)object2).getTranslateY() - (double)n6);
                mathTransform2 = MathTransforms.concatenate((MathTransform)MathTransforms.linear((Matrix)object5), (MathTransform)mathTransform);
            }
            GridEnvelope gridEnvelope = gridGeometry2D.getExtent();
            object5 = gridEnvelope.getLow().getCoordinateValues();
            int[] nArray3 = gridEnvelope.getHigh().getCoordinateValues();
            object5[n7] = n5;
            nArray3[n7] = n5 + object3.getWidth() - 1;
            object5[n2] = n6;
            nArray3[n2] = n6 + object3.getHeight() - 1;
            GeneralGridEnvelope generalGridEnvelope = new GeneralGridEnvelope(object5, nArray3, true);
            if (mathTransform2 != mathTransform || !generalGridEnvelope.equals(gridEnvelope)) {
                gridGeometry2D = new GridGeometry2D((GridEnvelope)generalGridEnvelope, PixelInCell.CELL_CORNER, mathTransform2, gridGeometry2D.getCoordinateReferenceSystem(), null);
            }
        }
        object2 = this.coverageBuilder;
        try {
            object2.setName((CharSequence)string);
            object2.setRenderedImage((RenderedImage)object3);
            object2.setSampleDimensions((SampleDimension[])gridSampleDimensionArray);
            object2.setGridGeometry((GridGeometry)gridGeometry2D);
            object2.setProperties((Map)object4);
            object = object2.getGridCoverage2D();
        }
        finally {
            object2.reset();
        }
        if (bl && LOGGER.isLoggable(level = this.getLogLevel(l = System.nanoTime() - l))) {
            ImageCoverageStore.logOperation(level, this.locale, ImageCoverageReader.class, false, this.input, n, (GridCoverage)object, null, null, mathTransform2D, l);
        }
        return object;
    }

    @Override
    public void abort() {
        super.abort();
        ImageReader imageReader = this.imageReader;
        if (imageReader != null) {
            imageReader.abort();
        }
    }

    @Override
    final String formatErrorMessage(Throwable throwable) {
        return this.formatErrorMessage(this.input, throwable, false);
    }

    private void close() throws IOException {
        Object object = this.input;
        this.input = null;
        this.coverageNames = null;
        XCollections.clear(this.gridGeometries);
        XCollections.clear(this.sampleDimensions);
        ImageReader imageReader = this.imageReader;
        if (imageReader != null) {
            if (imageReader.getInput() != object) {
                XImageIO.close(imageReader);
            } else {
                imageReader.setInput(null);
            }
        }
    }

    @Override
    public void reset() throws CoverageStoreException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        if (this.imageReader != null) {
            this.imageReader.reset();
        }
        this.helper = null;
        this.imageMetadata = null;
        this.imageMetadataIndex = -1;
        super.reset();
    }

    @Override
    public void dispose() throws CoverageStoreException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        if (this.imageReader != null) {
            this.imageReader.dispose();
            this.imageReader = null;
        }
        this.helper = null;
        super.dispose();
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(25);
        hashSet.add("Dimensions");
        hashSet.add("Dimension");
        hashSet.add("RangeElementDescriptions");
        hashSet.add("RangeElementDescription");
        hashSet.add("SpatialRepresentation");
        hashSet.add("RectifiedGridDomain");
        hashSet.add("Limits");
        hashSet.add("OffsetVectors");
        hashSet.add("OffsetVector");
        hashSet.add("CoordinateReferenceSystem");
        hashSet.add("CoordinateSystem");
        hashSet.add("Axes");
        hashSet.add("CoordinateSystemAxis");
        hashSet.add("Datum");
        hashSet.add("Ellipsoid");
        hashSet.add("PrimeMeridian");
        hashSet.add("Conversion");
        hashSet.add("Parameters");
        hashSet.add("ParameterValue");
        METADATA_NODES = Collections.unmodifiableSet(hashSet);
    }
}

