/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageReader;
import org.geotoolkit.coverage.io.ImageCoverageReader;

@ThreadSafe
public class GridCoverageStorePool {
    private final GridCoverageReader[] readers;
    private int readerCount;

    public GridCoverageStorePool(int n) {
        this.readers = new GridCoverageReader[n];
    }

    protected GridCoverageReader createReader() throws CoverageStoreException {
        return new ImageCoverageReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverageReader acquireReader() throws CoverageStoreException {
        GridCoverageReader[] gridCoverageReaderArray = this.readers;
        synchronized (this.readers) {
            int n = this.readerCount;
            if (n != 0) {
                this.readerCount = --n;
                GridCoverageReader gridCoverageReader = this.readers[n];
                this.readers[n] = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return gridCoverageReader;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.createReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(GridCoverageReader gridCoverageReader) throws CoverageStoreException {
        gridCoverageReader.reset();
        GridCoverageReader[] gridCoverageReaderArray = this.readers;
        synchronized (this.readers) {
            if (this.readerCount != this.readers.length) {
                this.readers[this.readerCount++] = gridCoverageReader;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            gridCoverageReader.dispose();
            return;
        }
    }
}

