/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.measure.unit.Unit;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GeneralGridGeometry;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageReadParam;
import org.geotoolkit.coverage.io.GridCoverageStore;
import org.geotoolkit.coverage.io.UniqueExtents;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.geotoolkit.metadata.iso.identification.DefaultResolution;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.w3c.dom.Node;

public abstract class GridCoverageReader
extends GridCoverageStore {
    Object input;

    protected GridCoverageReader() {
        this.ignoreGridTransforms = true;
    }

    public void setInput(Object object) throws CoverageStoreException {
        this.input = object;
        this.abortRequested = false;
    }

    public Object getInput() throws CoverageStoreException {
        return this.input;
    }

    final String getInputName() {
        Object object = this.input;
        if (IOUtilities.canProcessAsPath((Object)object)) {
            return IOUtilities.name((Object)object);
        }
        return Vocabulary.getResources((Locale)this.locale).getString(311);
    }

    public abstract List<? extends GenericName> getCoverageNames() throws CoverageStoreException, CancellationException;

    public abstract GeneralGridGeometry getGridGeometry(int var1) throws CoverageStoreException, CancellationException;

    public abstract List<GridSampleDimension> getSampleDimensions(int var1) throws CoverageStoreException, CancellationException;

    @Deprecated
    public List<MeasurementRange<?>> getSampleValueRanges(int n) throws CoverageStoreException, CancellationException {
        List<GridSampleDimension> list = this.getSampleDimensions(n);
        if (list == null) {
            return null;
        }
        MeasurementRange[] measurementRangeArray = new MeasurementRange[list.size()];
        for (int i = 0; i < measurementRangeArray.length; ++i) {
            GridSampleDimension gridSampleDimension = list.get(i);
            if (gridSampleDimension == null) continue;
            gridSampleDimension = gridSampleDimension.geophysics(true);
            measurementRangeArray[i] = MeasurementRange.createBestFit((Number)gridSampleDimension.getMinimumValue(), (boolean)true, (Number)gridSampleDimension.getMaximumValue(), (boolean)true, (Unit)gridSampleDimension.getUnits());
        }
        return Arrays.asList(measurementRangeArray);
    }

    private static DefaultMetadata createMetadata(IIOMetadata iIOMetadata) throws CoverageStoreException {
        if (iIOMetadata != null) {
            try {
                Object object;
                Node node;
                if (ArraysExt.contains((Object[])iIOMetadata.getExtraMetadataFormatNames(), (Object)"ISO-19115_3.0") && (node = iIOMetadata.getAsTree("ISO-19115_3.0")) instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof Metadata) {
                    return new DefaultMetadata((Metadata)object);
                }
            }
            catch (BackingStoreException backingStoreException) {
                Throwable throwable = backingStoreException.getCause();
                if (throwable instanceof IOException) {
                    throw new CoverageStoreException(throwable);
                }
                throw (CoverageStoreException)((Object)backingStoreException.unwrapOrRethrow(CoverageStoreException.class));
            }
        }
        return new DefaultMetadata();
    }

    public Metadata getMetadata() throws CoverageStoreException {
        DefaultDataIdentification defaultDataIdentification;
        boolean bl;
        Collection collection;
        Object object;
        SpatialMetadata spatialMetadata = this.getStreamMetadata();
        DefaultMetadata defaultMetadata = GridCoverageReader.createMetadata(spatialMetadata);
        DataIdentification dataIdentification = null;
        if (spatialMetadata != null) {
            Collection collection2;
            Collection collection3 = defaultMetadata.getDataQualityInfo();
            if (collection3.isEmpty()) {
                XCollections.addIfNonNull((Collection)collection3, (Object)spatialMetadata.getInstanceForType(DataQuality.class));
            }
            if ((collection2 = defaultMetadata.getAcquisitionInformation()).isEmpty()) {
                XCollections.addIfNonNull((Collection)collection2, (Object)spatialMetadata.getInstanceForType(AcquisitionInformation.class));
            }
            Iterator iterator = defaultMetadata.getIdentificationInfo().iterator();
            while (iterator.hasNext()) {
                object = (Identification)iterator.next();
                if (!(object instanceof DataIdentification)) continue;
                dataIdentification = (DataIdentification)object;
                iterator.remove();
                break;
            }
            if (dataIdentification == null) {
                dataIdentification = spatialMetadata.getInstanceForType(DataIdentification.class);
            }
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        object = null;
        ArrayList<Extent> arrayList = null;
        LinkedHashSet<DefaultResolution> linkedHashSet = null;
        if (dataIdentification != null) {
            bl4 = XCollections.isNullOrEmpty((Collection)dataIdentification.getSpatialResolutions());
            collection = dataIdentification.getExtents();
            if (!XCollections.isNullOrEmpty((Collection)collection) && (object = UniqueExtents.getIncomplete(arrayList = new ArrayList<Extent>(collection))) == null) {
                bl3 = false;
                arrayList = null;
            }
        }
        collection = defaultMetadata.getContentInfo();
        Collection collection4 = defaultMetadata.getSpatialRepresentationInfo();
        boolean bl5 = collection != null && collection.isEmpty();
        boolean bl6 = bl = collection4 != null && collection4.isEmpty();
        if (bl5 || bl || bl4 || bl3) {
            defaultDataIdentification = this.getCoverageNames();
            int n = defaultDataIdentification.size();
            for (int i = 0; i < n; ++i) {
                ImageDescription imageDescription;
                SpatialMetadata spatialMetadata2;
                if ((bl5 || bl) && (spatialMetadata2 = this.getCoverageMetadata(i)) != null) {
                    if (bl5 && (imageDescription = spatialMetadata2.getInstanceForType(ImageDescription.class)) != null) {
                        collection.add(imageDescription);
                    }
                    if (bl && (imageDescription = spatialMetadata2.getInstanceForType(Georectified.class)) != null) {
                        defaultMetadata.getSpatialRepresentationInfo().add(imageDescription);
                    }
                }
                if (!bl4 && !bl3) continue;
                spatialMetadata2 = this.getGridGeometry(i);
                if (bl4 && (imageDescription = CRSUtilities.getHorizontalResolution((CoordinateReferenceSystem)spatialMetadata2.getCoordinateReferenceSystem(), (double[])spatialMetadata2.getResolution())) != null) {
                    DefaultResolution defaultResolution = new DefaultResolution();
                    defaultResolution.setDistance(Double.valueOf(imageDescription.doubleValue()));
                    if (linkedHashSet == null) {
                        linkedHashSet = new LinkedHashSet<DefaultResolution>();
                    }
                    linkedHashSet.add(defaultResolution);
                }
                if (!bl3 || !spatialMetadata2.isDefined(2)) continue;
                if (object == null) {
                    object = new UniqueExtents();
                }
                try {
                    object.addElements(spatialMetadata2.getEnvelope());
                    continue;
                }
                catch (TransformException transformException) {
                    if (bl2) continue;
                    bl2 = true;
                    Logging.recoverableException((Logger)LOGGER, GridCoverageReader.class, (String)"getMetadata", (Throwable)transformException);
                }
            }
        }
        if (object != null || linkedHashSet != null) {
            defaultDataIdentification = new DefaultDataIdentification(dataIdentification);
            if (object != null) {
                if (arrayList != null) {
                    defaultDataIdentification.setExtents(arrayList);
                } else {
                    defaultDataIdentification.getExtents().add(object);
                }
            }
            if (linkedHashSet != null) {
                defaultDataIdentification.setSpatialResolutions(linkedHashSet);
            }
            dataIdentification = defaultDataIdentification;
        }
        if (dataIdentification != null) {
            defaultMetadata.getIdentificationInfo().add(dataIdentification);
        }
        return defaultMetadata;
    }

    public SpatialMetadata getStreamMetadata() throws CoverageStoreException {
        return null;
    }

    public SpatialMetadata getCoverageMetadata(int n) throws CoverageStoreException {
        return null;
    }

    public Map<?, ?> getProperties(int n) throws CoverageStoreException, CancellationException {
        return null;
    }

    public abstract GridCoverage read(int var1, GridCoverageReadParam var2) throws CoverageStoreException, CancellationException;

    @Override
    public void reset() throws CoverageStoreException {
        this.input = null;
        super.reset();
    }

    @Override
    public void dispose() throws CoverageStoreException {
        this.input = null;
        super.dispose();
    }
}

