/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.io.File;
import java.util.Collections;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageReader;
import org.geotoolkit.coverage.io.GridCoverageWriteParam;
import org.geotoolkit.coverage.io.GridCoverageWriter;
import org.geotoolkit.coverage.io.ImageCoverageReader;
import org.geotoolkit.coverage.io.ImageCoverageWriter;
import org.geotoolkit.coverage.io.MosaicCoverageReader;
import org.geotoolkit.lang.Static;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class CoverageIO
extends Static {
    private CoverageIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridCoverage read(Object object) throws CoverageStoreException {
        GridCoverageReader gridCoverageReader = CoverageIO.createSimpleReader(object);
        try {
            GridCoverage gridCoverage = gridCoverageReader.read(0, null);
            return gridCoverage;
        }
        finally {
            gridCoverageReader.dispose();
        }
    }

    public static void write(GridCoverage gridCoverage, String string, Object object) throws CoverageStoreException {
        ArgumentChecks.ensureNonNull((String)"coverage", (Object)gridCoverage);
        CoverageIO.write(Collections.singleton(gridCoverage), string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Iterable<? extends GridCoverage> iterable, String string, Object object) throws CoverageStoreException {
        ArgumentChecks.ensureNonNull((String)"coverages", iterable);
        ArgumentChecks.ensureNonNull((String)"output", (Object)object);
        GridCoverageWriteParam gridCoverageWriteParam = null;
        if (string != null) {
            gridCoverageWriteParam = new GridCoverageWriteParam();
            gridCoverageWriteParam.setFormatName(string);
        }
        ImageCoverageWriter imageCoverageWriter = new ImageCoverageWriter();
        try {
            ((GridCoverageWriter)imageCoverageWriter).setOutput(object);
            ((GridCoverageWriter)imageCoverageWriter).write(iterable, gridCoverageWriteParam);
        }
        finally {
            ((GridCoverageWriter)imageCoverageWriter).dispose();
        }
    }

    public static GridCoverageReader createSimpleReader(Object object) throws CoverageStoreException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        ImageCoverageReader imageCoverageReader = new ImageCoverageReader();
        imageCoverageReader.setInput(object);
        return imageCoverageReader;
    }

    public static GridCoverageWriter createSimpleWriter(Object object) throws CoverageStoreException {
        ArgumentChecks.ensureNonNull((String)"output", (Object)object);
        ImageCoverageWriter imageCoverageWriter = new ImageCoverageWriter();
        imageCoverageWriter.setOutput(object);
        return imageCoverageWriter;
    }

    public static GridCoverageReader createMosaicReader(Object object, CoordinateReferenceSystem coordinateReferenceSystem) throws CoverageStoreException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        if (coordinateReferenceSystem == null && object instanceof File) {
            return new MosaicCoverageReader((File)object, false);
        }
        ArgumentChecks.ensureNonNull((String)"crs", (Object)coordinateReferenceSystem);
        return new MosaicCoverageReader(object, coordinateReferenceSystem);
    }

    public static GridCoverageReader writeOrReuseMosaic(File file) throws CoverageStoreException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)file);
        return new MosaicCoverageReader(file, true);
    }
}

