/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.geom.Point2D;
import java.awt.image.RasterFormatException;
import javax.media.jai.Warp;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

@Immutable
final class WarpAdapter
extends Warp {
    private static final long serialVersionUID = -8679060848877065181L;
    private static final AffineTransform2D PRE_TRANSFORM = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    private static final AffineTransform2D POST_TRANSFORM = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, -0.5, -0.5);
    private final CharSequence name;
    private final MathTransform2D inverse;

    public WarpAdapter(CharSequence charSequence, MathTransform2D mathTransform2D) {
        this.name = charSequence;
        this.inverse = MathTransforms.concatenate((MathTransform2D)PRE_TRANSFORM, (MathTransform2D)mathTransform2D, (MathTransform2D)POST_TRANSFORM);
    }

    public MathTransform2D getTransform() {
        return this.inverse;
    }

    public float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (n5 < 1) {
            throw new IllegalArgumentException(String.valueOf(n5));
        }
        if (n6 < 1) {
            throw new IllegalArgumentException(String.valueOf(n6));
        }
        int n7 = n + n3;
        int n8 = n2 + n4;
        int n9 = (n3 + (n5 - 1)) / n5 * ((n4 + (n6 - 1)) / n6);
        if (fArray == null) {
            fArray = new float[2 * n9];
        }
        int n10 = 0;
        for (int i = n2; i < n8; i += n6) {
            for (int j = n; j < n7; j += n5) {
                fArray[n10++] = j;
                fArray[n10++] = i;
            }
        }
        try {
            this.inverse.transform(fArray, 0, fArray, 0, n9);
        }
        catch (TransformException transformException) {
            RasterFormatException rasterFormatException = new RasterFormatException(Errors.format((int)37, (Object)this.name));
            rasterFormatException.initCause(transformException);
            throw rasterFormatException;
        }
        return fArray;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        try {
            return this.inverse.transform(point2D, null);
        }
        catch (TransformException transformException) {
            throw new IllegalArgumentException(Errors.format((int)12, (Object)"destPt", (Object)point2D), transformException);
        }
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        try {
            return this.inverse.inverse().transform(point2D, null);
        }
        catch (TransformException transformException) {
            throw new IllegalArgumentException(Errors.format((int)12, (Object)"sourcePt", (Object)point2D), transformException);
        }
    }
}

