/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpCubic;
import javax.media.jai.WarpGeneralPolynomial;
import javax.media.jai.WarpQuadratic;
import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.referencing.operation.transform.WarpTransform2D;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Transformation;

@Immutable
public class WarpPolynomial
extends MathTransformProvider {
    private static final long serialVersionUID = -7949539694656719923L;
    public static final ParameterDescriptor<Integer> DEGREE = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "degree", Integer.class, null, (Object)2, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7), null, true);
    public static final ParameterDescriptor<float[]> X_COEFFS = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "xCoeffs", float[].class, null, null, null, null, null, true);
    public static final ParameterDescriptor<float[]> Y_COEFFS = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "yCoeffs", float[].class, null, null, null, null, null, true);
    public static final ParameterDescriptor<Float> PRE_SCALE_X;
    public static final ParameterDescriptor<Float> PRE_SCALE_Y;
    public static final ParameterDescriptor<Float> POST_SCALE_X;
    public static final ParameterDescriptor<Float> POST_SCALE_Y;
    public static final ParameterDescriptorGroup PARAMETERS;

    public WarpPolynomial() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        WarpAffine warpAffine;
        int n = Parameters.integerValue(DEGREE, (ParameterValueGroup)parameterValueGroup);
        float[] fArray = (float[])Parameters.value(X_COEFFS, (ParameterValueGroup)parameterValueGroup);
        float[] fArray2 = (float[])Parameters.value(Y_COEFFS, (ParameterValueGroup)parameterValueGroup);
        float f = WarpPolynomial.scale(PRE_SCALE_X, parameterValueGroup);
        float f2 = WarpPolynomial.scale(PRE_SCALE_Y, parameterValueGroup);
        float f3 = WarpPolynomial.scale(POST_SCALE_X, parameterValueGroup);
        float f4 = WarpPolynomial.scale(POST_SCALE_Y, parameterValueGroup);
        switch (n) {
            case 1: {
                warpAffine = new WarpAffine(fArray, fArray2, f, f2, f3, f4);
                break;
            }
            case 2: {
                warpAffine = new WarpQuadratic(fArray, fArray2, f, f2, f3, f4);
                break;
            }
            case 3: {
                warpAffine = new WarpCubic(fArray, fArray2, f, f2, f3, f4);
                break;
            }
            default: {
                warpAffine = new WarpGeneralPolynomial(fArray, fArray2, f, f2, f3, f4);
            }
        }
        return WarpTransform2D.create((Warp)warpAffine);
    }

    private static float scale(ParameterDescriptor<Float> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Object object = Parameters.value(parameterDescriptor, (ParameterValueGroup)parameterValueGroup);
        return object != null ? ((Number)object).floatValue() : 1.0f;
    }

    static {
        Float f = Float.valueOf(1.0f);
        Class<Float> clazz = Float.class;
        PRE_SCALE_X = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "preScaleX", clazz, null, (Object)f, null, null, null, false);
        PRE_SCALE_Y = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "preScaleY", clazz, null, (Object)f, null, null, null, false);
        POST_SCALE_X = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "postScaleX", clazz, null, (Object)f, null, null, null, false);
        POST_SCALE_Y = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "postScaleY", clazz, null, (Object)f, null, null, null, false);
        PARAMETERS = UniversalParameters.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLKIT, "WarpPolynomial")}, null, (ParameterDescriptor[])new ParameterDescriptor[]{DEGREE, X_COEFFS, Y_COEFFS, PRE_SCALE_X, PRE_SCALE_Y, POST_SCALE_X, POST_SCALE_Y}, (int)0);
    }
}

