/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.builder;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.io.Serializable;
import java.util.Arrays;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.GridTransform;
import org.geotoolkit.referencing.operation.transform.GridType;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

@Immutable
final class LocalizationGridTransform2D
extends GridTransform
implements MathTransform2D {
    private static final long serialVersionUID = 1067560328828441295L;
    private static final int MAX_ITER = 40;
    private static final boolean CONSERVATIVE = true;
    private static final boolean MASK_NON_CONVERGENCE;
    private final AffineTransform global;
    private MathTransform2D inverse;

    protected LocalizationGridTransform2D(int n, int n2, double[] dArray, double[] dArray2, AffineTransform affineTransform) {
        this(n, n2, new DataBufferDouble(new double[][]{dArray, dArray2}, n * n2), affineTransform);
    }

    protected LocalizationGridTransform2D(int n, int n2, DataBuffer dataBuffer, AffineTransform affineTransform) {
        super(GridType.LOCALIZATION, dataBuffer, new Dimension(n, n2), null);
        this.global = affineTransform;
    }

    private void getAffineTransform(double d, double d2, AffineTransform affineTransform) {
        int n;
        int n2;
        int n3 = (int)d;
        int n4 = (int)d2;
        if (n3 > this.width - 2) {
            n3 = this.width - 2;
        }
        if (n4 > this.height - 2) {
            n4 = this.height - 2;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (d - (double)n3 > 0.5) {
            n2 = -1;
            ++n3;
        } else {
            n2 = 1;
        }
        if (d2 - (double)n4 > 0.5) {
            n = -1;
            ++n4;
        } else {
            n = 1;
        }
        int n5 = n3 + n4 * this.width;
        int n6 = n5 + n * this.width;
        int n7 = n5 + n2;
        d = this.grid.getElemDouble(0, n5);
        d2 = this.grid.getElemDouble(1, n5);
        double d3 = (this.grid.getElemDouble(0, n7) - d) * (double)n2;
        double d4 = (this.grid.getElemDouble(1, n7) - d2) * (double)n2;
        double d5 = (this.grid.getElemDouble(0, n6) - d) * (double)n;
        double d6 = (this.grid.getElemDouble(1, n6) - d2) * (double)n;
        affineTransform.setTransform(d3, d4, d5, d6, d - d3 * (double)n3 - d5 * (double)n4, d2 - d4 * (double)n3 - d6 * (double)n4);
        assert (this.distance(new Point(n3, n4), affineTransform) < 1.0E-5);
        assert (this.distance(new Point(n3 + n2, n4), affineTransform) < 1.0E-5);
        assert (this.distance(new Point(n3, n4 + n), affineTransform) < 1.0E-5);
    }

    private double distance(Point2D point2D, AffineTransform affineTransform) {
        try {
            Point2D point2D2 = this.transform(point2D, null);
            point2D2 = affineTransform.inverseTransform(point2D2, point2D2);
            return point2D2.distance(point2D);
        }
        catch (TransformException transformException) {
            throw new AssertionError((Object)transformException);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new AssertionError((Object)noninvertibleTransformException);
        }
    }

    final void inverseTransform(Point2D point2D, Point2D.Double double_, AffineTransform affineTransform) throws TransformException {
        affineTransform.setTransform(this.global);
        try {
            double d;
            double d2;
            int n;
            int n2;
            affineTransform.inverseTransform(point2D, double_);
            int n3 = (int)double_.x;
            int n4 = (int)double_.y;
            for (n2 = 0; n2 < 40; ++n2) {
                this.getAffineTransform(double_.x, double_.y, affineTransform);
                affineTransform.inverseTransform(point2D, double_);
                n = (int)double_.x;
                int n5 = (int)double_.y;
                if (n3 == n && n4 == n5) {
                    if (double_.x >= 0.0 && double_.x < (double)this.width && double_.y >= 0.0 && double_.y < (double)this.height) {
                        assert (this.transform(double_, null).distanceSq(point2D) < 0.001) : double_;
                    } else {
                        this.inverseTransform(point2D, double_);
                    }
                    return;
                }
                n3 = n;
                n4 = n5;
            }
            n2 = n3;
            n = n4;
            this.global.inverseTransform(point2D, double_);
            double d3 = d2 = double_.x;
            double d4 = d = double_.y;
            double d5 = Double.POSITIVE_INFINITY;
            for (int i = -39; i < 40; ++i) {
                n3 = (int)d2;
                n4 = (int)d;
                this.getAffineTransform(d2, d, affineTransform);
                affineTransform.inverseTransform(point2D, double_);
                d2 = double_.x;
                d = double_.y;
                int n6 = (int)d2;
                int n7 = (int)d;
                if (n3 == n6 && n4 == n7) {
                    assert (i >= 0);
                    if (d2 >= 0.0 && d2 < (double)this.width && d >= 0.0 && d < (double)this.height) {
                        assert (this.transform(double_, null).distanceSq(point2D) < 0.001) : double_;
                    } else {
                        this.inverseTransform(point2D, double_);
                    }
                    return;
                }
                if (i == 0) {
                    assert (n2 == n6 && n == n7);
                } else if (n2 == n6 && n == n7) {
                    if (d3 >= 0.0 && d3 < (double)this.width && d4 >= 0.0 && d4 < (double)this.height) {
                        double_.x = d3;
                        double_.y = d4;
                    } else {
                        this.inverseTransform(point2D, double_);
                    }
                    return;
                }
                this.transform(double_, double_);
                double d6 = double_.distanceSq(point2D);
                if (!(d6 < d5)) continue;
                d5 = d6;
                d3 = d2;
                d4 = d;
            }
            if (MASK_NON_CONVERGENCE) {
                Logging.getLogger(LocalizationGridTransform2D.class).fine(Errors.format((int)152));
                if (d3 >= 0.0 && d3 < (double)this.width && d4 >= 0.0 && d4 < (double)this.height) {
                    double_.x = d3;
                    double_.y = d4;
                } else {
                    this.inverseTransform(point2D, double_);
                }
                return;
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new TransformException(Errors.format((int)126), (Throwable)noninvertibleTransformException);
        }
        throw new TransformException(Errors.format((int)152));
    }

    private void inverseTransform(Point2D point2D, Point2D.Double double_) throws NoninvertibleTransformException {
        if (this.global.inverseTransform(point2D, double_) != double_) {
            throw new AssertionError();
        }
        double d = double_.x;
        double d2 = double_.y;
        if (d >= 0.0 && d < (double)this.width && d2 >= 0.0 && d2 < (double)this.height) {
            d -= 0.5 * (double)this.width;
            d2 -= 0.5 * (double)this.height;
            if (Math.abs(d) < Math.abs(d2)) {
                double_.x = d > 0.0 ? (double)this.width : -1.0;
            } else {
                double_.y = d2 > 0.0 ? (double)this.height : -1.0;
            }
        }
    }

    public MathTransform2D inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    protected int computeHashCode() {
        return Utilities.hash((Object)this.global, (int)super.computeHashCode());
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            LocalizationGridTransform2D localizationGridTransform2D = (LocalizationGridTransform2D)((Object)object);
            return Utilities.equals((Object)this.global, (Object)localizationGridTransform2D.global);
        }
        return false;
    }

    static {
        String string;
        try {
            string = System.getProperty("org.geotoolkit.referencing.forceConvergence", "false");
        }
        catch (SecurityException securityException) {
            string = "false";
        }
        MASK_NON_CONVERGENCE = string.equalsIgnoreCase("true");
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D,
    Serializable {
        private static final long serialVersionUID = 4876426825123740986L;

        public Inverse() {
            super((AbstractMathTransform)LocalizationGridTransform2D.this);
        }

        public Point2D transform(Point2D point2D, Point2D point2D2) throws TransformException {
            AffineTransform affineTransform = new AffineTransform(LocalizationGridTransform2D.this.global);
            if (point2D2 == null) {
                Point2D.Double double_ = new Point2D.Double();
                LocalizationGridTransform2D.this.inverseTransform(point2D, double_, affineTransform);
                return double_;
            }
            if (point2D2 != point2D && point2D2 instanceof Point2D.Double) {
                LocalizationGridTransform2D.this.inverseTransform(point2D, (Point2D.Double)point2D2, affineTransform);
                return point2D2;
            }
            Point2D.Double double_ = new Point2D.Double();
            LocalizationGridTransform2D.this.inverseTransform(point2D, double_, affineTransform);
            point2D2.setLocation(double_);
            return point2D2;
        }

        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            Matrix matrix = bl ? this.derivative(new Point2D.Double(dArray[n], dArray[n + 1])) : null;
            this.transform(dArray, n, dArray2, n2, 1);
            return matrix;
        }

        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            int n4 = 0;
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest((int)n, (int)n, (int)n2, (int)n2, (int)n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        n += (n3 - 1) * 2;
                        n2 += (n3 - 1) * 2;
                        n4 = -4;
                        break;
                    }
                    default: {
                        dArray = Arrays.copyOfRange(dArray, n, n + n3 * 2);
                        n = 0;
                    }
                }
            }
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            AffineTransform affineTransform = new AffineTransform(LocalizationGridTransform2D.this.global);
            while (--n3 >= 0) {
                double_.x = dArray[n++];
                double_.y = dArray[n++];
                LocalizationGridTransform2D.this.inverseTransform(double_, double_2, affineTransform);
                dArray2[n2++] = double_2.x;
                dArray2[n2++] = double_2.y;
                n += n4;
                n2 += n4;
            }
        }

        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
            int n4 = 0;
            if (fArray == fArray2) {
                switch (IterationStrategy.suggest((int)n, (int)n, (int)n2, (int)n2, (int)n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        n += (n3 - 1) * 2;
                        n2 += (n3 - 1) * 2;
                        n4 = -4;
                        break;
                    }
                    default: {
                        fArray = Arrays.copyOfRange(fArray, n, n + n3 * 2);
                        n = 0;
                    }
                }
            }
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            AffineTransform affineTransform = new AffineTransform(LocalizationGridTransform2D.this.global);
            while (--n3 >= 0) {
                double_.x = fArray[n++];
                double_.y = fArray[n++];
                LocalizationGridTransform2D.this.inverseTransform(double_, double_2, affineTransform);
                fArray2[n2++] = (float)double_2.x;
                fArray2[n2++] = (float)double_2.y;
                n += n4;
                n2 += n4;
            }
        }

        public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            AffineTransform affineTransform = new AffineTransform(LocalizationGridTransform2D.this.global);
            while (--n3 >= 0) {
                double_.x = dArray[n++];
                double_.y = dArray[n++];
                LocalizationGridTransform2D.this.inverseTransform(double_, double_2, affineTransform);
                fArray[n2++] = (float)double_2.x;
                fArray[n2++] = (float)double_2.y;
            }
        }

        public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            AffineTransform affineTransform = new AffineTransform(LocalizationGridTransform2D.this.global);
            while (--n3 >= 0) {
                double_.x = fArray[n++];
                double_.y = fArray[n++];
                LocalizationGridTransform2D.this.inverseTransform(double_, double_2, affineTransform);
                dArray[n2++] = double_2.x;
                dArray[n2++] = double_2.y;
            }
        }

        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }
    }
}

