/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.builder;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.builder.LocalizationGridTransform2D;
import org.geotoolkit.referencing.operation.transform.WarpTransform2D;
import org.opengis.referencing.operation.MathTransform2D;

@ThreadSafe
public class LocalizationGrid {
    private final int width;
    private final int height;
    private double[] gridX;
    private double[] gridY;
    private transient AffineTransform global;
    private transient MathTransform2D[] transforms;
    private static final int INCREASING = 1;
    private static final int DECREASING = 2;
    private static final int EQUALS = 4;

    public LocalizationGrid(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        this.width = n;
        this.height = n2;
        int n3 = n * n2;
        this.gridX = new double[n3];
        this.gridY = new double[n3];
        Arrays.fill(this.gridX, Double.NaN);
        Arrays.fill(this.gridY, Double.NaN);
    }

    private int computeOffset(int n, int n2) {
        if (n < 0 || n >= this.width) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 >= this.height) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return n + n2 * this.width;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public synchronized Point2D getLocalizationPoint(Point point) {
        int n = this.computeOffset(point.x, point.y);
        return new Point2D.Double(this.gridX[n], this.gridY[n]);
    }

    public void setLocalizationPoint(Point point, Point2D point2D) {
        this.setLocalizationPoint(point.x, point.y, point2D.getX(), point2D.getY());
    }

    public synchronized void setLocalizationPoint(int n, int n2, double d, double d2) {
        int n3 = this.computeOffset(n, n2);
        this.notifyChange();
        this.global = null;
        this.gridX[n3] = d;
        this.gridY[n3] = d2;
    }

    public synchronized void transform(AffineTransform affineTransform, Rectangle rectangle) {
        Point2D.Double double_ = new Point2D.Double();
        if (rectangle == null) {
            rectangle = new Rectangle(this.width, this.height);
        }
        this.computeOffset(rectangle.x, rectangle.y);
        int n = rectangle.y + rectangle.height;
        while (--n >= rectangle.y) {
            int n2 = rectangle.x + rectangle.width;
            while (--n2 >= rectangle.x) {
                int n3 = this.computeOffset(n2, n);
                this.notifyChange();
                double_.x = this.gridX[n3];
                double_.y = this.gridY[n3];
                affineTransform.transform(double_, double_);
                this.gridX[n3] = double_.x;
                this.gridY[n3] = double_.y;
            }
        }
        this.global = null;
    }

    public synchronized boolean isNaN() {
        int n = this.gridY.length;
        while (--n >= 0) {
            if (!Double.isNaN(this.gridY[n])) continue;
            return true;
        }
        n = this.gridX.length;
        while (--n >= 0) {
            if (!Double.isNaN(this.gridX[n])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMonotonic(boolean bl) {
        int n;
        int n2;
        int n3 = 3;
        int n4 = 3;
        if (!bl) {
            n3 |= 4;
            n4 |= 4;
        }
        for (n2 = 0; n2 < this.width; ++n2) {
            n = this.computeOffset(n2, 0);
            n3 = LocalizationGrid.testOrder(this.gridX, n, this.height, this.width, n3);
            if (n3 == 0) {
                return false;
            }
            if ((n4 = LocalizationGrid.testOrder(this.gridY, n, this.height, this.width, n4)) != 0) continue;
            return false;
        }
        n3 = 3;
        n4 = 3;
        if (!bl) {
            n3 |= 4;
            n4 |= 4;
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            n = this.computeOffset(0, n2);
            n3 = LocalizationGrid.testOrder(this.gridX, n, this.width, 1, n3);
            if (n3 == 0) {
                return false;
            }
            if ((n4 = LocalizationGrid.testOrder(this.gridY, n, this.width, 1, n4)) != 0) continue;
            return false;
        }
        return true;
    }

    private static int testOrder(double[] dArray, int n, int n2, int n3, int n4) {
        --n2;
        while (--n2 >= 0) {
            double d = dArray[n];
            if (!Double.isNaN(d)) {
                int n5;
                int n6;
                while (true) {
                    double d2;
                    if (d == (d2 = dArray[n + n3])) {
                        n6 = 4;
                        n5 = -1;
                        break;
                    }
                    if (d2 > d) {
                        n6 = 1;
                        n5 = -3;
                        break;
                    }
                    if (d2 < d) {
                        n6 = 2;
                        n5 = -2;
                        break;
                    }
                    if (--n2 < 0) {
                        return n4;
                    }
                    n += n3;
                }
                if ((n4 & n6) == 0) {
                    return 0;
                }
                n4 &= n5;
            }
            n += n3;
        }
        return n4;
    }

    public void removeSingularities() {
        this.removeSingularities(this.gridX, false);
        this.removeSingularities(this.gridX, true);
        this.removeSingularities(this.gridY, false);
        this.removeSingularities(this.gridY, true);
    }

    private void removeSingularities(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        if (bl) {
            n3 = this.width;
            n2 = this.width;
            n = this.height;
        } else {
            n3 = 1;
            n2 = this.height;
            n = this.width;
        }
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            int n6 = bl ? this.computeOffset(i, 0) : this.computeOffset(0, i);
            int n7 = -1;
            for (n5 = 1; n5 < n; ++n5) {
                n4 = n6 + n3 * (n5 - 1);
                int n8 = n4 + n3;
                if (dArray[n4] == dArray[n8]) {
                    if (n7 != -1) continue;
                    n7 = n4;
                    if (n4 == n6) continue;
                    n7 -= n3;
                    continue;
                }
                if (n7 == -1) continue;
                int n9 = (n8 - n7) / n3 + 1;
                LocalizationGrid.replaceSingularity(dArray, n7, n9, n3);
                n7 = -1;
            }
            if (n7 == -1) continue;
            n5 = n6 + n3 * (n - 1);
            n4 = (n5 - n7) / n3 + 1;
            LocalizationGrid.replaceSingularity(dArray, n7, n4, n3);
        }
    }

    private static void replaceSingularity(double[] dArray, int n, int n2, int n3) {
        double d = (dArray[n + (n2 - 1) * n3] - dArray[n]) / (double)(n2 - 1);
        double d2 = dArray[n];
        n += n3;
        int n4 = 0;
        while (n4 < n2 - 2) {
            dArray[n] = d2 + d * (double)(n4 + 1);
            ++n4;
            n += n3;
        }
    }

    public synchronized AffineTransform getAffineTransform() {
        if (this.global == null) {
            double[] dArray = new double[6];
            this.fitPlane(this.gridX, 0, dArray);
            this.fitPlane(this.gridY, 1, dArray);
            this.global = new AffineTransform(dArray);
        }
        return new AffineTransform(this.global);
    }

    private void fitPlane(double[] dArray, int n, double[] dArray2) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                assert (this.computeOffset(j, i) == n2) : n2;
                d = dArray[n2];
                d4 += d;
                d3 += d * (double)j;
                d2 += d * (double)i;
                ++n2;
            }
        }
        assert (n2 == this.width * this.height) : n2;
        double d5 = (double)n2 * (double)(this.width - 1) / 2.0;
        double d6 = (double)n2 * (double)(this.height - 1) / 2.0;
        double d7 = (double)n2 * ((double)this.width - 0.5) * (double)(this.width - 1) / 3.0;
        double d8 = (double)n2 * ((double)this.height - 0.5) * (double)(this.height - 1) / 3.0;
        double d9 = (double)n2 * (double)((this.height - 1) * (this.width - 1)) / 4.0;
        double d10 = (d9 -= d5 * d6 / (double)n2) * d9 - (d7 -= d5 * d5 / (double)n2) * (d8 -= d6 * d6 / (double)n2);
        d = ((d3 -= d4 * d5 / (double)n2) * d9 - (d2 -= d4 * d6 / (double)n2) * d7) / d10;
        double d11 = (d2 * d9 - d3 * d8) / d10;
        double d12 = (d4 - (d11 * d5 + d * d6)) / (double)n2;
        dArray2[0 + n] = d11;
        dArray2[2 + n] = d;
        dArray2[4 + n] = d12;
    }

    private MathTransform2D fitWarps(int n) {
        float[] fArray = new float[this.width * this.height * 2];
        float[] fArray2 = new float[fArray.length];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                assert (n2 == this.computeOffset(j, i));
                float f = (float)this.gridX[n2];
                float f2 = (float)this.gridY[n2];
                if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                    fArray[n3] = j;
                    fArray[n3 + 1] = i;
                    fArray2[n3] = f;
                    fArray2[n3 + 1] = f2;
                    n3 += 2;
                }
                ++n2;
            }
        }
        return new WarpTransform2D(null, fArray, 0, null, fArray2, 0, n3 / 2, n);
    }

    public synchronized MathTransform2D getPolynomialTransform(int n) {
        ArgumentChecks.ensureBetween((String)"degree", (int)0, (int)7, (int)n);
        if (this.transforms == null) {
            this.transforms = new MathTransform2D[8];
        }
        if (this.transforms[n] == null) {
            MathTransform2D mathTransform2D;
            switch (n) {
                case 0: {
                    mathTransform2D = new LocalizationGridTransform2D(this.width, this.height, this.gridX, this.gridY, this.getAffineTransform());
                    break;
                }
                case 1: {
                    mathTransform2D = (MathTransform2D)MathTransforms.linear((AffineTransform)this.getAffineTransform());
                    break;
                }
                default: {
                    mathTransform2D = this.fitWarps(n);
                }
            }
            this.transforms[n] = mathTransform2D;
        }
        return this.transforms[n];
    }

    public final MathTransform2D getMathTransform() {
        return this.getPolynomialTransform(0);
    }

    private void notifyChange() {
        if (this.transforms != null) {
            if (this.transforms[0] != null) {
                this.gridX = (double[])this.gridX.clone();
                this.gridY = (double[])this.gridY.clone();
            }
            this.transforms = null;
        }
    }
}

