/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Arrays;
import java.util.Date;
import org.geotoolkit.coverage.grid.GeneralGridGeometry;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.cs.DiscreteAxis;
import org.geotoolkit.referencing.cs.DiscreteCRS;
import org.geotoolkit.referencing.cs.DiscreteCS;
import org.geotoolkit.referencing.cs.DiscreteCompoundCRS;
import org.geotoolkit.referencing.cs.DiscreteCoordinateSystemAxis;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public final class DiscreteReferencingFactory
extends Static {
    private DiscreteReferencingFactory() {
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)string));
        }
    }

    public static DiscreteCoordinateSystemAxis<?> createDiscreteAxis(CoordinateSystemAxis coordinateSystemAxis, double ... dArray) {
        DiscreteReferencingFactory.ensureNonNull("axis", coordinateSystemAxis);
        if (DiscreteReferencingFactory.canReuse(coordinateSystemAxis, dArray)) {
            return (DiscreteCoordinateSystemAxis)coordinateSystemAxis;
        }
        if (coordinateSystemAxis instanceof DiscreteAxis && DiscreteReferencingFactory.canReuse(coordinateSystemAxis = ((DiscreteAxis)coordinateSystemAxis).axis, dArray)) {
            return (DiscreteCoordinateSystemAxis)coordinateSystemAxis;
        }
        DiscreteReferencingFactory.ensureNonNull("ordinates", dArray);
        return new DiscreteAxis(coordinateSystemAxis, dArray);
    }

    public static CoordinateSystem createDiscreteCS(CoordinateSystem coordinateSystem, double[] ... dArray) throws IllegalArgumentException {
        DiscreteReferencingFactory.ensureNonNull("cs", coordinateSystem);
        DiscreteReferencingFactory.ensureNonNull("ordinates", dArray);
        if (DiscreteReferencingFactory.canReuse(coordinateSystem, dArray)) {
            return coordinateSystem;
        }
        if (coordinateSystem instanceof DiscreteCS && DiscreteReferencingFactory.canReuse(coordinateSystem = ((DiscreteCS)coordinateSystem).cs, dArray)) {
            return coordinateSystem;
        }
        if (coordinateSystem instanceof CartesianCS) {
            return new DiscreteCS.Cartesian((CartesianCS)coordinateSystem, dArray);
        }
        if (coordinateSystem instanceof EllipsoidalCS) {
            return new DiscreteCS.Ellipsoidal((EllipsoidalCS)coordinateSystem, dArray);
        }
        if (coordinateSystem instanceof VerticalCS) {
            return new DiscreteCS.Vertical((VerticalCS)coordinateSystem, dArray);
        }
        if (coordinateSystem instanceof TimeCS) {
            return new DiscreteCS.Time((TimeCS)coordinateSystem, dArray);
        }
        return new DiscreteCS(coordinateSystem, dArray);
    }

    public static CoordinateReferenceSystem createDiscreteCRS(CoordinateReferenceSystem object, double[] ... dArray) throws IllegalArgumentException {
        DiscreteReferencingFactory.ensureNonNull("crs", object);
        DiscreteReferencingFactory.ensureNonNull("ordinates", dArray);
        if (object instanceof CompoundCRS) {
            dArray = DiscreteReferencingFactory.replaceNulls((CompoundCRS)object, dArray, dArray, 0);
        }
        if (DiscreteReferencingFactory.canReuse(object.getCoordinateSystem(), dArray)) {
            return object;
        }
        if (object instanceof DiscreteCRS && DiscreteReferencingFactory.canReuse((object = ((DiscreteCRS)object).crs).getCoordinateSystem(), dArray)) {
            return object;
        }
        if (object instanceof GeographicCRS) {
            return new DiscreteCRS.Geographic((GeographicCRS)object, dArray);
        }
        if (object instanceof ProjectedCRS) {
            return new DiscreteCRS.Projected((ProjectedCRS)object, dArray);
        }
        if (object instanceof VerticalCRS) {
            return new DiscreteCRS.Vertical((VerticalCRS)object, dArray);
        }
        if (object instanceof TemporalCRS) {
            return new DiscreteCRS.Temporal((TemporalCRS)object, dArray);
        }
        if (object instanceof SingleCRS) {
            return new DiscreteCRS.Single((SingleCRS)object, dArray);
        }
        if (object instanceof CompoundCRS) {
            return DiscreteCompoundCRS.create((CompoundCRS)object, dArray);
        }
        return new DiscreteCRS<CoordinateReferenceSystem>((CoordinateReferenceSystem)object, new DiscreteCS(object.getCoordinateSystem(), dArray));
    }

    private static boolean canReuse(CoordinateSystem coordinateSystem, double[][] dArray) {
        int n = coordinateSystem.getDimension();
        if (dArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (DiscreteReferencingFactory.canReuse(coordinateSystem.getAxis(i), dArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean canReuse(CoordinateSystemAxis coordinateSystemAxis, double[] dArray) {
        if (!(coordinateSystemAxis instanceof DiscreteCoordinateSystemAxis)) {
            return false;
        }
        if (dArray != null) {
            if (coordinateSystemAxis instanceof DiscreteAxis) {
                return Arrays.equals(((DiscreteAxis)coordinateSystemAxis).ordinates, dArray);
            }
            DiscreteCoordinateSystemAxis discreteCoordinateSystemAxis = (DiscreteCoordinateSystemAxis)coordinateSystemAxis;
            if (discreteCoordinateSystemAxis.length() != dArray.length) {
                return false;
            }
            for (int i = 0; i < dArray.length; ++i) {
                Comparable comparable = discreteCoordinateSystemAxis.getOrdinateAt(i);
                if (comparable instanceof Number && Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(((Number)((Object)comparable)).doubleValue())) continue;
                return false;
            }
        }
        return true;
    }

    private static double[][] replaceNulls(CompoundCRS compoundCRS, double[][] dArray, double[][] dArray2, int n) {
        block0: for (CoordinateReferenceSystem coordinateReferenceSystem : compoundCRS.getComponents()) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            int n2 = coordinateSystem.getDimension();
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                dArray = DiscreteReferencingFactory.replaceNulls((CompoundCRS)coordinateReferenceSystem, dArray, dArray2, n);
            }
            for (int i = 0; i < n2; ++i) {
                CoordinateSystemAxis coordinateSystemAxis;
                if (n == dArray.length) break block0;
                if (dArray[n] == null && (coordinateSystemAxis = coordinateSystem.getAxis(i)) instanceof DiscreteAxis) {
                    if (dArray == dArray2) {
                        dArray = (double[][])dArray.clone();
                    }
                    dArray[n] = ((DiscreteAxis)coordinateSystemAxis).ordinates;
                }
                ++n;
            }
        }
        return dArray;
    }

    public static XMatrix getAffineTransform(DiscreteCoordinateSystemAxis<?> ... discreteCoordinateSystemAxisArray) {
        DiscreteReferencingFactory.ensureNonNull("axes", discreteCoordinateSystemAxisArray);
        return DiscreteReferencingFactory.getAffineTransform(null, discreteCoordinateSystemAxisArray);
    }

    public static Matrix getAffineTransform(CoordinateReferenceSystem coordinateReferenceSystem) {
        Matrix matrix;
        DiscreteReferencingFactory.ensureNonNull("crs", coordinateReferenceSystem);
        if (coordinateReferenceSystem instanceof GridGeometry && (matrix = Matrices.getMatrix((MathTransform)((GridGeometry)coordinateReferenceSystem).getGridToCRS())) != null) {
            return matrix;
        }
        return DiscreteReferencingFactory.createAffineTransform(coordinateReferenceSystem);
    }

    private static Matrix createAffineTransform(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        DiscreteCoordinateSystemAxis[] discreteCoordinateSystemAxisArray = new DiscreteCoordinateSystemAxis[coordinateSystem.getDimension()];
        for (int i = 0; i < discreteCoordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            if (!(coordinateSystemAxis instanceof DiscreteCoordinateSystemAxis)) continue;
            discreteCoordinateSystemAxisArray[i] = (DiscreteCoordinateSystemAxis)coordinateSystemAxis;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            return DiscreteReferencingFactory.getAffineTransform((CompoundCRS)coordinateReferenceSystem, discreteCoordinateSystemAxisArray);
        }
        return DiscreteReferencingFactory.getAffineTransform(coordinateReferenceSystem, discreteCoordinateSystemAxisArray);
    }

    static XMatrix getAffineTransform(CoordinateReferenceSystem coordinateReferenceSystem, DiscreteCoordinateSystemAxis<?>[] discreteCoordinateSystemAxisArray) {
        int n = discreteCoordinateSystemAxisArray.length;
        XMatrix xMatrix = Matrices.create((int)(n + 1));
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            int n2;
            DiscreteCoordinateSystemAxis<?> discreteCoordinateSystemAxis = discreteCoordinateSystemAxisArray[i];
            if (discreteCoordinateSystemAxis == null || (n2 = discreteCoordinateSystemAxis.length() - 1) < 0) {
                return null;
            }
            Comparable<?> comparable = discreteCoordinateSystemAxis.getOrdinateAt(0);
            Comparable<?> comparable2 = discreteCoordinateSystemAxis.getOrdinateAt(n2);
            if (comparable instanceof Number && comparable2 instanceof Number) {
                d2 = ((Number)((Object)comparable)).doubleValue();
                d = ((Number)((Object)comparable2)).doubleValue();
            } else if (comparable instanceof Date && comparable2 instanceof Date) {
                Object object = CRS.getSubCRS((CoordinateReferenceSystem)coordinateReferenceSystem, (int)i, (int)(i + 1));
                if (object instanceof DiscreteCRS) {
                    object = ((DiscreteCRS)object).crs;
                }
                if (!(object instanceof TemporalCRS)) {
                    return null;
                }
                DefaultTemporalCRS defaultTemporalCRS = DefaultTemporalCRS.castOrCopy((TemporalCRS)((TemporalCRS)object));
                d2 = defaultTemporalCRS.toValue((Date)comparable);
                d = defaultTemporalCRS.toValue((Date)comparable2);
            } else {
                return null;
            }
            if (n2 != 0) {
                double d3 = (d - d2) / (double)n2;
                if (Double.isNaN(d3) || d3 == 0.0) {
                    return null;
                }
                xMatrix.setElement(i, i, d3);
            }
            xMatrix.setElement(i, n, d2);
        }
        return xMatrix;
    }

    static XMatrix getAffineTransform(CompoundCRS compoundCRS, DiscreteCoordinateSystemAxis<?>[] discreteCoordinateSystemAxisArray) {
        XMatrix xMatrix = DiscreteReferencingFactory.getAffineTransform((CoordinateReferenceSystem)compoundCRS, discreteCoordinateSystemAxisArray);
        if (xMatrix != null) {
            int n = xMatrix.getNumCol() - 1;
            int n2 = 0;
            for (CoordinateReferenceSystem coordinateReferenceSystem : compoundCRS.getComponents()) {
                int n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                if (!(coordinateReferenceSystem instanceof DiscreteCRS) && coordinateReferenceSystem instanceof GridGeometry) {
                    int n4;
                    MathTransform mathTransform = ((GridGeometry)coordinateReferenceSystem).getGridToCRS();
                    if (mathTransform instanceof LinearTransform) {
                        int n5;
                        Matrix matrix = ((LinearTransform)mathTransform).getMatrix();
                        n4 = mathTransform.getSourceDimensions();
                        int n6 = n5 = n4 == n3 ? n2 : 0;
                        assert (matrix.getNumRow() == n3 + 1) : mathTransform;
                        assert (matrix.getNumCol() == n4 + 1) : mathTransform;
                        for (int i = 0; i < n3; ++i) {
                            int n7 = i + n2;
                            for (int j = 0; j < n4; ++j) {
                                xMatrix.setElement(n7, j + n5, matrix.getElement(i, j));
                            }
                            xMatrix.setElement(n7, n, matrix.getElement(i, n4));
                        }
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            n4 = i + n2;
                            xMatrix.setElement(n4, n4, Double.NaN);
                        }
                    }
                }
                n2 += n3;
            }
        }
        return xMatrix;
    }

    public static Matrix getAffineTransform(GridGeometry gridGeometry, PixelInCell pixelInCell) {
        double d;
        MathTransform mathTransform;
        DiscreteReferencingFactory.ensureNonNull("geometry", gridGeometry);
        if (pixelInCell != null && gridGeometry instanceof GeneralGridGeometry) {
            mathTransform = ((GeneralGridGeometry)gridGeometry).getGridToCRS(pixelInCell);
            pixelInCell = null;
        } else {
            mathTransform = gridGeometry.getGridToCRS();
        }
        Matrix matrix = Matrices.getMatrix((MathTransform)mathTransform);
        if (matrix == null && gridGeometry instanceof CoordinateReferenceSystem) {
            matrix = DiscreteReferencingFactory.createAffineTransform((CoordinateReferenceSystem)gridGeometry);
        }
        if (matrix != null && pixelInCell != null && (d = PixelTranslation.getPixelTranslation((PixelInCell)pixelInCell)) != 0.0) {
            int n = matrix.getNumCol() - 1;
            int n2 = matrix.getNumRow();
            while (--n2 >= 0) {
                double d2 = 0.0;
                for (int i = 0; i < n; ++i) {
                    d2 += d * matrix.getElement(n2, i);
                }
                matrix.setElement(n2, n, d2 += matrix.getElement(n2, n));
            }
        }
        return matrix;
    }
}

