/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.measure.unit.Unit;
import org.geotoolkit.referencing.cs.DiscreteCoordinateSystemAxis;
import org.geotoolkit.util.NumberRange;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class DiscreteAxis
implements CoordinateSystemAxis,
DiscreteCoordinateSystemAxis<Double>,
Serializable {
    private static final long serialVersionUID = 7456302077762863016L;
    protected final CoordinateSystemAxis axis;
    final double[] ordinates;

    DiscreteAxis(CoordinateSystemAxis coordinateSystemAxis, double ... dArray) {
        this.axis = coordinateSystemAxis;
        this.ordinates = dArray;
    }

    public ReferenceIdentifier getName() {
        return this.axis.getName();
    }

    public Collection<GenericName> getAlias() {
        return this.axis.getAlias();
    }

    public Set<ReferenceIdentifier> getIdentifiers() {
        return this.axis.getIdentifiers();
    }

    public String getAbbreviation() {
        return this.axis.getAbbreviation();
    }

    public AxisDirection getDirection() {
        return this.axis.getDirection();
    }

    public RangeMeaning getRangeMeaning() {
        return this.axis.getRangeMeaning();
    }

    public Unit<?> getUnit() {
        return this.axis.getUnit();
    }

    public double getMinimumValue() {
        return this.axis.getMinimumValue();
    }

    public synchronized double getMaximumValue() {
        return this.axis.getMaximumValue();
    }

    @Override
    public int length() {
        return this.ordinates.length;
    }

    @Override
    public Class<Double> getElementType() {
        return Double.class;
    }

    public Double getOrdinateAt(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n];
    }

    @Override
    public NumberRange<Double> getOrdinateRangeAt(int n) throws IndexOutOfBoundsException {
        boolean bl;
        if (this.ordinates.length < 2) {
            throw new UnsupportedOperationException();
        }
        double d = this.ordinates[n];
        int n2 = n == 0 ? 0 : n - 1;
        int n3 = Math.min(this.ordinates.length - 1, n + 1);
        double d2 = d - 0.5 * (this.ordinates[n2 + 1] - this.ordinates[n2]);
        double d3 = d + 0.5 * (this.ordinates[n3] - this.ordinates[n3 - 1]);
        boolean bl2 = bl = d2 > d3;
        if (bl) {
            double d4 = d2;
            d2 = d3;
            d3 = d4;
        }
        return NumberRange.create((double)d2, (!bl ? 1 : 0) != 0, (double)d3, (boolean)bl);
    }

    public InternationalString getRemarks() {
        return this.axis.getRemarks();
    }

    public String toWKT() throws UnsupportedOperationException {
        return this.axis.toWKT();
    }

    public String toString() {
        return this.axis.toString();
    }

    public int hashCode() {
        return this.axis.hashCode() + 31 * Arrays.hashCode(this.ordinates);
    }

    public boolean equals(Object object) {
        if (object instanceof DiscreteAxis) {
            DiscreteAxis discreteAxis = (DiscreteAxis)object;
            return this.axis.equals(discreteAxis.axis) && Arrays.equals(this.ordinates, discreteAxis.ordinates);
        }
        return false;
    }
}

