/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListImpl;
import javax.media.jai.util.Range;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.ImagingParameter;
import org.geotoolkit.parameter.ImagingParameterDescriptors;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class ImagingParameters
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = 1378692626023992530L;
    public final ParameterList parameters;
    private List<GeneralParameterValue> values;

    public ImagingParameters(ImagingParameterDescriptors imagingParameterDescriptors) {
        super((GeneralParameterDescriptor)imagingParameterDescriptors);
        this.parameters = imagingParameterDescriptors.operation instanceof OperationDescriptor ? new ParameterBlockJAI((OperationDescriptor)imagingParameterDescriptors.operation, imagingParameterDescriptors.registryMode) : new ParameterListImpl(imagingParameterDescriptors.descriptor);
    }

    public ImagingParameters(Map<String, ?> map, ParameterList parameterList) {
        super((GeneralParameterDescriptor)new ImagingParameterDescriptors(map, parameterList.getParameterListDescriptor()));
        this.parameters = parameterList;
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterList);
    }

    private static boolean compatible(ParameterDescriptor<?> parameterDescriptor, ParameterListDescriptor parameterListDescriptor, String[] stringArray, Class<?>[] classArray, String[] stringArray2) {
        String string = parameterDescriptor.getName().getCode().trim();
        Class<?> clazz = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                clazz = classArray[i];
                break;
            }
        }
        if (clazz == null || !clazz.isAssignableFrom(parameterDescriptor.getValueClass())) {
            return false;
        }
        Range range = parameterListDescriptor.getParamValueRange(string);
        if (range != null) {
            Comparable comparable = parameterDescriptor.getMinimumValue();
            if (comparable != null && !range.contains(comparable)) {
                return false;
            }
            comparable = parameterDescriptor.getMaximumValue();
            if (comparable != null && !range.contains(comparable)) {
                return false;
            }
        }
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray2[i])) continue;
                EnumeratedParameter[] enumeratedParameterArray = parameterListDescriptor.getEnumeratedParameterValues(string);
                Set set = parameterDescriptor.getValidValues();
                if (set != null && Arrays.asList(enumeratedParameterArray).containsAll(set)) continue;
                return false;
            }
        }
        return true;
    }

    private GeneralParameterValue[] createElements() {
        Object object;
        int n;
        ImagingParameterDescriptors imagingParameterDescriptors = (ImagingParameterDescriptors)this.descriptor;
        ParameterListDescriptor parameterListDescriptor = this.parameters.getParameterListDescriptor();
        String[] stringArray = parameterListDescriptor.getParamNames();
        Class[] classArray = parameterListDescriptor.getParamClasses();
        String[] stringArray2 = parameterListDescriptor.getEnumeratedParameterNames();
        List list = imagingParameterDescriptors.descriptors();
        Object[] objectArray = new GeneralParameterValue[list.size()];
        for (n = 0; n < objectArray.length; ++n) {
            object = (ParameterDescriptor)list.get(n);
            Object object2 = ImagingParameters.compatible(object, parameterListDescriptor, stringArray, classArray, stringArray2) ? ImagingParameter.create(object, this.parameters) : object.createValue();
            objectArray[n] = object2;
        }
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n].getDescriptor().getName().getCode().trim();
            for (int i = 0; i < objectArray.length; ++i) {
                ParameterDescriptor parameterDescriptor;
                if (i == n || !IdentifiedObjects.nameMatches((IdentifiedObject)(parameterDescriptor = (ParameterDescriptor)objectArray[i].getDescriptor()), (String)object)) continue;
                throw new InvalidParameterNameException(Errors.format((int)182, (Object)parameterDescriptor.getName().getCode(), (Object)n, (Object)object, (Object)i), (String)object);
            }
        }
        this.values = UnmodifiableArrayList.wrap((Object[])objectArray);
        return objectArray;
    }

    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    public synchronized List<GeneralParameterValue> values() {
        if (this.values == null) {
            this.createElements();
        }
        assert (((ParameterDescriptorGroup)this.descriptor).descriptors().size() == this.values.size()) : this.values;
        return this.values;
    }

    public synchronized ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = string.trim();
        List<GeneralParameterValue> list = this.values();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ParameterValue parameterValue = (ParameterValue)list.get(i);
            if (!IdentifiedObjects.nameMatches((IdentifiedObject)parameterValue.getDescriptor(), (String)string)) continue;
            return parameterValue;
        }
        throw new ParameterNotFoundException(Errors.format((int)224, (Object)string), string);
    }

    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Errors.format((int)224, (Object)string), string);
    }

    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Errors.format((int)224, (Object)string), string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ImagingParameters imagingParameters = (ImagingParameters)((Object)object);
            return Utilities.equals((Object)this.parameters, (Object)imagingParameters.parameters);
        }
        return false;
    }

    public int hashCode() {
        return Utilities.hash((Object)this.parameters, (int)super.hashCode());
    }

    public synchronized ImagingParameters clone() {
        GeneralParameterValue[] generalParameterValueArray;
        ImagingParameters imagingParameters = (ImagingParameters)super.clone();
        try {
            generalParameterValueArray = this.parameters.getClass().getMethod("clone", null);
            Field field = ImagingParameters.class.getField("parameters");
            field.setAccessible(true);
            field.set((Object)imagingParameters, generalParameterValueArray.invoke((Object)this.parameters, (Object[])null));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Clone not supported.", exception);
        }
        if (imagingParameters.values != null) {
            generalParameterValueArray = imagingParameters.createElements();
            assert (this.values.size() == generalParameterValueArray.length) : this.values;
            for (int i = 0; i < generalParameterValueArray.length; ++i) {
                if (generalParameterValueArray[i] instanceof ImagingParameter) continue;
                generalParameterValueArray[i] = ((ParameterValue)this.values.get(i)).clone();
            }
        }
        return imagingParameters;
    }
}

