/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import javax.media.jai.PlanarImage;
import org.geotoolkit.internal.image.ImageUtilities;

public abstract class SimpleBufferedImageOp
implements BufferedImageOp,
Serializable {
    private static final long serialVersionUID = 6973234963094057672L;

    protected SimpleBufferedImageOp() {
    }

    public abstract RenderedImage filter(BufferedImage var1);

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        RenderedImage renderedImage = this.filter(bufferedImage);
        if (bufferedImage2 != renderedImage) {
            Object object;
            if (bufferedImage2 == null) {
                if (renderedImage instanceof BufferedImage) {
                    return (BufferedImage)renderedImage;
                }
                if (renderedImage instanceof PlanarImage) {
                    return ((PlanarImage)renderedImage).getAsBufferedImage();
                }
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            } else {
                object = this.getBounds2D(bufferedImage);
                if ((double)bufferedImage2.getWidth() != ((RectangularShape)object).getWidth() || (double)bufferedImage2.getHeight() != ((RectangularShape)object).getHeight()) {
                    throw new IllegalArgumentException();
                }
            }
            ImageUtilities.fill(bufferedImage2, (Number)0);
            object = bufferedImage2.createGraphics();
            ((Graphics2D)object).drawRenderedImage(renderedImage, new AffineTransform());
            ((Graphics)object).dispose();
        }
        return bufferedImage2;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return ImageUtilities.getBounds(bufferedImage);
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }
}

