/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
final class MultiBandsIndexColorModel
extends IndexColorModel {
    final int numBands;
    final int visibleBand;

    public MultiBandsIndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5, int n6, int n7) {
        super(n, n2, nArray, n3, bl, n4, n5);
        this.numBands = n6;
        this.visibleBand = n7;
    }

    @Override
    public Object getDataElements(int n, Object object) {
        if (object == null) {
            switch (this.transferType) {
                case 1: 
                case 2: {
                    object = new short[this.numBands];
                    break;
                }
                case 0: {
                    object = new byte[this.numBands];
                    break;
                }
                case 3: {
                    object = new int[this.numBands];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unsupported());
                }
            }
        }
        object = super.getDataElements(n, object);
        switch (this.transferType) {
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                Arrays.fill(sArray, 1, this.numBands, sArray[0]);
                break;
            }
            case 0: {
                byte[] byArray = (byte[])object;
                Arrays.fill(byArray, 1, this.numBands, byArray[0]);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                Arrays.fill(nArray, 1, this.numBands, nArray[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return object;
    }

    @Override
    public int[] getComponents(Object object, int[] nArray, int n) {
        int n2;
        switch (this.transferType) {
            case 1: 
            case 2: {
                n2 = ((short[])object)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 0: {
                n2 = ((byte[])object)[this.visibleBand] & 0xFF;
                break;
            }
            case 3: {
                n2 = ((int[])object)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getComponents(n2, nArray, n);
    }

    @Override
    public int getRed(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = ((byte[])object)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                n = ((short[])object)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                n = ((int[])object)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getRed(n);
    }

    @Override
    public int getGreen(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = ((byte[])object)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                n = ((short[])object)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                n = ((int[])object)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getGreen(n);
    }

    @Override
    public int getBlue(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = ((byte[])object)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                n = ((short[])object)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                n = ((int[])object)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getBlue(n);
    }

    @Override
    public int getAlpha(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = ((byte[])object)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                n = ((short[])object)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                n = ((int[])object)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getAlpha(n);
    }

    private String unsupported() {
        return "This method has not been implemented for transferType " + this.transferType;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return Raster.createBandedRaster(this.transferType, n, n2, this.numBands, null);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new BandedSampleModel(this.transferType, n, n2, this.numBands);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel && sampleModel.getTransferType() == this.transferType && sampleModel.getNumBands() == this.numBands && 1 << sampleModel.getSampleSize(this.visibleBand) >= this.getMapSize();
    }
}

