/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;

public final class ImageUtilities
extends Static {
    private static final Dimension DEFAULT_TILE_SIZE = new Dimension(512, 512);
    public static final int MIN_TILE_SIZE = 256;
    private static final int STRIPE_SIZE = 64;
    private static final String[] INTERPOLATION_NAMES = new String[]{"Nearest", "NearestNeighbor", "Bilinear", "Bicubic", "Bicubic2"};
    private static final int[] INTERPOLATION_TYPES = new int[]{0, 0, 1, 2, 3};

    private ImageUtilities() {
    }

    public static Rectangle getBounds(RenderedImage renderedImage) {
        return new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
    }

    public static ImageLayout getImageLayout(RenderedImage renderedImage) {
        return ImageUtilities.getImageLayout(renderedImage, true);
    }

    private static ImageLayout getImageLayout(RenderedImage renderedImage, boolean bl) {
        ImageLayout imageLayout;
        if (renderedImage == null) {
            return null;
        }
        ImageLayout imageLayout2 = imageLayout = bl ? new ImageLayout(renderedImage) : null;
        if (!(renderedImage.getNumXTiles() != 1 && renderedImage.getTileWidth() > 64 || renderedImage.getNumYTiles() != 1 && renderedImage.getTileHeight() > 64)) {
            int n;
            Dimension dimension;
            if (imageLayout != null) {
                imageLayout = imageLayout.unsetTileLayout();
            }
            if ((dimension = JAI.getDefaultTileSize()) == null) {
                dimension = DEFAULT_TILE_SIZE;
            }
            if ((n = ImageUtilities.toTileSize(renderedImage.getWidth(), dimension.width)) != 0) {
                if (imageLayout == null) {
                    imageLayout = new ImageLayout();
                }
                imageLayout = imageLayout.setTileWidth(n);
                imageLayout.setTileGridXOffset(renderedImage.getMinX());
            }
            if ((n = ImageUtilities.toTileSize(renderedImage.getHeight(), dimension.height)) != 0) {
                if (imageLayout == null) {
                    imageLayout = new ImageLayout();
                }
                imageLayout = imageLayout.setTileHeight(n);
                imageLayout.setTileGridYOffset(renderedImage.getMinY());
            }
        }
        return imageLayout;
    }

    public static RenderingHints getRenderingHints(RenderedImage renderedImage) {
        ImageLayout imageLayout = ImageUtilities.getImageLayout(renderedImage, false);
        return imageLayout != null ? new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout) : null;
    }

    public static boolean isTiled(RenderedImage renderedImage) {
        return renderedImage.getTileWidth() < renderedImage.getWidth() || renderedImage.getTileHeight() < renderedImage.getHeight();
    }

    public static Dimension toTileSize(Dimension dimension) {
        int n;
        Dimension dimension2 = JAI.getDefaultTileSize();
        if (dimension2 == null) {
            dimension2 = DEFAULT_TILE_SIZE;
        }
        if ((n = ImageUtilities.toTileSize(dimension.width, dimension2.width)) != 0) {
            dimension.width = n;
        }
        if ((n = ImageUtilities.toTileSize(dimension.height, dimension2.height)) != 0) {
            dimension.height = n;
        }
        return dimension;
    }

    private static int toTileSize(int n, int n2) {
        int n3 = Math.min(n2 * 2, n);
        int n4 = Math.max(n2 - 256, n3 - n2);
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i <= n4; ++i) {
            int n7;
            int n8 = n2 + i;
            if (n8 <= n3) {
                n7 = n % n8;
                if (n7 == 0) {
                    return n8;
                }
                if (n7 > n6) {
                    n6 = n7;
                    n5 = n8;
                }
            }
            if ((n8 = n2 - i) < 256) continue;
            n7 = n % n8;
            if (n7 == 0) {
                return n8;
            }
            if (n7 <= n6) continue;
            n6 = n7;
            n5 = n8;
        }
        return n6 >= n2 - n2 / 4 ? n5 : 0;
    }

    public static ImageLayout createIntersection(ImageLayout imageLayout, List<? extends RenderedImage> list) {
        int n;
        ImageLayout imageLayout2 = imageLayout;
        if (imageLayout2 == null) {
            imageLayout2 = new ImageLayout();
        }
        if ((n = list.size()) != 0) {
            int n2;
            int n3;
            RenderedImage renderedImage = list.get(0);
            int n4 = imageLayout2.getMinX(renderedImage);
            int n5 = imageLayout2.getMinY(renderedImage);
            int n6 = imageLayout2.getWidth(renderedImage) + n4;
            int n7 = imageLayout2.getHeight(renderedImage) + n5;
            for (n3 = 0; n3 < n; ++n3) {
                renderedImage = list.get(n3);
                n2 = renderedImage.getMinX();
                int n8 = renderedImage.getMinY();
                int n9 = renderedImage.getWidth() + n2;
                int n10 = renderedImage.getHeight() + n8;
                int n11 = 0;
                if (n4 < n2) {
                    n11 |= 5;
                }
                if (n5 < n8) {
                    n11 |= 0xA;
                }
                if (n6 > n9) {
                    n11 |= 4;
                }
                if (n7 > n10) {
                    n11 |= 8;
                }
                if (n11 == 0) continue;
                if (imageLayout == imageLayout2) {
                    imageLayout2 = (ImageLayout)imageLayout.clone();
                }
                if ((n11 & 1) != 0) {
                    n4 = n2;
                    imageLayout2.setMinX(n4);
                }
                if ((n11 & 2) != 0) {
                    n5 = n8;
                    imageLayout2.setMinY(n5);
                }
                if ((n11 & 4) != 0) {
                    n6 = n9;
                    imageLayout2.setWidth(n6 - n4);
                }
                if ((n11 & 8) == 0) continue;
                n7 = n10;
                imageLayout2.setHeight(n7 - n5);
            }
            if (imageLayout2 != imageLayout) {
                renderedImage = list.get(0);
                if (imageLayout2.isValid(64) && (n3 = imageLayout2.getTileWidth(renderedImage)) != (n2 = ImageUtilities.toTileSize(imageLayout2.getWidth(renderedImage), n3))) {
                    imageLayout2.setTileWidth(n2);
                }
                if (imageLayout2.isValid(128) && (n3 = imageLayout2.getTileHeight(renderedImage)) != (n2 = ImageUtilities.toTileSize(imageLayout2.getHeight(renderedImage), n3))) {
                    imageLayout2.setTileHeight(n2);
                }
            }
        }
        return imageLayout2;
    }

    public static Interpolation toInterpolation(Object object) throws IllegalArgumentException {
        if (object instanceof Interpolation) {
            return (Interpolation)object;
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            int n = INTERPOLATION_NAMES.length;
            for (int i = 0; i < n; ++i) {
                if (!INTERPOLATION_NAMES[i].equalsIgnoreCase(string)) continue;
                return Interpolation.getInstance((int)INTERPOLATION_TYPES[i]);
            }
        }
        throw new IllegalArgumentException(Errors.format((int)221, (Object)object));
    }

    public static String getInterpolationName(Interpolation interpolation) {
        if (interpolation == null) {
            interpolation = Interpolation.getInstance((int)0);
        }
        for (Class<?> clazz = interpolation.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String string = Classes.getShortName(clazz);
            int n = string.lastIndexOf("Interpolation");
            if (n < 0) continue;
            return string.substring(n + "Interpolation".length());
        }
        return Classes.getShortClassName((Object)interpolation);
    }

    public static boolean isFloatType(int n) {
        return n == 4 || n == 5;
    }

    public static int typeForBoth(int n, int n2) {
        int n3;
        int n4 = Math.min(n, n2);
        if (n4 == (n3 = Math.max(n, n2))) {
            return n3;
        }
        if (n4 >= 0 && n3 <= 5) {
            return n4 == 1 && n3 == 2 ? 3 : n3;
        }
        return 32;
    }

    public static int typeForRange(double d, double d2) {
        if (d2 >= d) {
            for (int i = 0; i <= 5; ++i) {
                if (!(d >= ImageUtilities.minimum(i)) || !(d2 <= ImageUtilities.maximum(i))) continue;
                return i;
            }
        }
        return 32;
    }

    public static double minimum(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 2: {
                return -32768.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public static double maximum(int n) {
        switch (n) {
            case 0: {
                return 255.0;
            }
            case 1: {
                return 65535.0;
            }
            case 2: {
                return 32767.0;
            }
            case 3: {
                return 2.147483647E9;
            }
            case 4: {
                return 3.4028234663852886E38;
            }
            case 5: {
                return Double.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(WritableRenderedImage writableRenderedImage, Number number) {
        int n = writableRenderedImage.getMinTileY();
        int n2 = writableRenderedImage.getNumYTiles();
        while (--n2 >= 0) {
            int n3 = writableRenderedImage.getMinTileX();
            int n4 = writableRenderedImage.getNumXTiles();
            while (--n4 >= 0) {
                WritableRaster writableRaster = writableRenderedImage.getWritableTile(n3, n);
                try {
                    ImageUtilities.fill(writableRaster.getDataBuffer(), number);
                }
                finally {
                    writableRenderedImage.releaseWritableTile(n3, n);
                }
                ++n3;
            }
            ++n;
        }
    }

    public static void fill(WritableRaster writableRaster, Rectangle rectangle, Number number) {
        Rectangle rectangle2 = writableRaster.getBounds();
        if (rectangle.contains(rectangle2)) {
            ImageUtilities.fill(writableRaster.getDataBuffer(), number);
        } else {
            rectangle = rectangle.intersection(rectangle2);
            double[] dArray = new double[writableRaster.getNumBands()];
            Arrays.fill(dArray, number.doubleValue());
            ImageUtil.fillBackground((WritableRaster)writableRaster, (Rectangle)rectangle, (double[])dArray);
        }
    }

    private static void fill(DataBuffer dataBuffer, Number number) {
        int[] nArray = dataBuffer.getOffsets();
        int n = dataBuffer.getSize();
        if (dataBuffer instanceof DataBufferByte) {
            DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
            byte by = number.byteValue();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                Arrays.fill(dataBufferByte.getData(i), n2, n2 + n, by);
            }
        } else if (dataBuffer instanceof DataBufferShort) {
            DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
            short s = number.shortValue();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                Arrays.fill(dataBufferShort.getData(i), n3, n3 + n, s);
            }
        } else if (dataBuffer instanceof DataBufferUShort) {
            DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
            short s = number.shortValue();
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                Arrays.fill(dataBufferUShort.getData(i), n4, n4 + n, s);
            }
        } else if (dataBuffer instanceof DataBufferInt) {
            DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
            int n5 = number.intValue();
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = nArray[i];
                Arrays.fill(dataBufferInt.getData(i), n6, n6 + n, n5);
            }
        } else if (dataBuffer instanceof DataBufferFloat) {
            DataBufferFloat dataBufferFloat = (DataBufferFloat)dataBuffer;
            float f = number.floatValue();
            for (int i = 0; i < nArray.length; ++i) {
                int n7 = nArray[i];
                Arrays.fill(dataBufferFloat.getData(i), n7, n7 + n, f);
            }
        } else if (dataBuffer instanceof DataBufferDouble) {
            DataBufferDouble dataBufferDouble = (DataBufferDouble)dataBuffer;
            double d = number.doubleValue();
            for (int i = 0; i < nArray.length; ++i) {
                int n8 = nArray[i];
                Arrays.fill(dataBufferDouble.getData(i), n8, n8 + n, d);
            }
        } else {
            throw new IllegalArgumentException(Errors.format((int)239));
        }
    }

    public static RenderedImage replaceColorModel(RenderedImage renderedImage, ColorModel colorModel) {
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            renderedImage = new BufferedImage(colorModel, bufferedImage.getRaster(), bufferedImage.isAlphaPremultiplied(), null);
        } else {
            ImageLayout imageLayout = new ImageLayout();
            imageLayout.setColorModel(colorModel);
            renderedImage = new NullOpImage(renderedImage, imageLayout, null, 1);
        }
        return renderedImage;
    }
}

