/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.coverage;

import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.PropertySource;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.RenderedCoverage;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.NumberRange;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CoverageUtilities
extends Static {
    private CoverageUtilities() {
    }

    public static CoordinateReferenceSystem getCRS2D(Coverage coverage) throws TransformException {
        if (coverage instanceof GridCoverage2D) {
            return ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D gridGeometry2D = GridGeometry2D.castOrCopy(((GridCoverage)coverage).getGridGeometry());
            if (gridGeometry2D.isDefined(1)) {
                return gridGeometry2D.getCoordinateReferenceSystem2D();
            }
            try {
                return gridGeometry2D.reduce(coverage.getCoordinateReferenceSystem());
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return CRSUtilities.getCRS2D((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
    }

    public static Envelope2D getEnvelope2D(Coverage coverage) throws MismatchedDimensionException {
        if (coverage instanceof GridCoverage2D) {
            return ((GridCoverage2D)coverage).getEnvelope2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D gridGeometry2D = GridGeometry2D.castOrCopy(((GridCoverage)coverage).getGridGeometry());
            if (gridGeometry2D.isDefined(2)) {
                return gridGeometry2D.getEnvelope2D();
            }
            return gridGeometry2D.reduce(coverage.getEnvelope());
        }
        return new Envelope2D(coverage.getEnvelope());
    }

    public static double[] getBackgroundValues(GridCoverage gridCoverage) {
        int n = gridCoverage.getNumSampleDimensions();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            SampleDimension sampleDimension = gridCoverage.getSampleDimension(i);
            if (!(sampleDimension instanceof GridSampleDimension)) continue;
            NumberRange<?> numberRange = ((GridSampleDimension)sampleDimension).getBackground().getRange();
            double d = numberRange.getMinimum();
            double d2 = numberRange.getMaximum();
            dArray[i] = numberRange.isMinIncluded() ? d : (numberRange.isMaxIncluded() ? d2 : 0.5 * (d + d2));
        }
        return dArray;
    }

    public static boolean hasRenderingCategories(GridCoverage gridCoverage) {
        int n = gridCoverage.getNumSampleDimensions();
        if (n == 0) {
            return false;
        }
        SampleDimension[] sampleDimensionArray = new SampleDimension[n];
        for (int i = 0; i < n; ++i) {
            sampleDimensionArray[i] = gridCoverage.getSampleDimension(i);
        }
        return CoverageUtilities.hasTransform(sampleDimensionArray);
    }

    public static boolean hasTransform(SampleDimension[] sampleDimensionArray) {
        int n = sampleDimensionArray.length;
        while (--n >= 0) {
            MathTransform1D mathTransform1D;
            SampleDimension sampleDimension = sampleDimensionArray[n];
            if (sampleDimension instanceof GridSampleDimension) {
                sampleDimension = ((GridSampleDimension)sampleDimension).geophysics(false);
            }
            if ((mathTransform1D = sampleDimension.getSampleToGeophysics()) == null || mathTransform1D.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public static boolean uses(GridCoverage gridCoverage, RenderedImage renderedImage) {
        if (gridCoverage != null) {
            if (gridCoverage instanceof RenderedCoverage && ((RenderedCoverage)gridCoverage).getRenderedImage() == renderedImage) {
                return true;
            }
            List list = gridCoverage.getSources();
            if (list != null) {
                for (GridCoverage gridCoverage2 : list) {
                    if (!CoverageUtilities.uses(gridCoverage2, renderedImage)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getVisibleBand(Object object) {
        Object object2 = null;
        if (object instanceof RenderedImage) {
            object2 = ((RenderedImage)object).getProperty("GC_VisibleBand");
        } else if (object instanceof PropertySource) {
            object2 = ((PropertySource)object).getProperty("GC_VisibleBand");
        }
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 0;
    }

    public static ViewType preferredViewForOperation(GridCoverage2D gridCoverage2D, Interpolation interpolation, boolean bl, RenderingHints renderingHints) {
        Vector<RenderedImage> vector;
        GridCoverage2D gridCoverage2D2;
        Object object;
        if (renderingHints != null && (object = renderingHints.get(Hints.COVERAGE_PROCESSING_VIEW)) instanceof ViewType) {
            return (ViewType)((Object)object);
        }
        object = gridCoverage2D.getRenderedImage();
        if (object.getColorModel() instanceof IndexColorModel) {
            if (!CoverageUtilities.hasRenderingCategories(gridCoverage2D)) {
                return ViewType.PHOTOGRAPHIC;
            }
            if (!bl && (interpolation == null || interpolation instanceof InterpolationNearest)) {
                if (renderingHints != null) {
                    Object object2 = renderingHints.get(RenderingHints.KEY_RENDERING);
                    if (RenderingHints.VALUE_RENDER_QUALITY.equals(object2)) {
                        return ViewType.NATIVE;
                    }
                    if (RenderingHints.VALUE_RENDER_SPEED.equals(object2)) {
                        return ViewType.SAME;
                    }
                }
                return ViewType.SAME;
            }
            return ViewType.GEOPHYSICS;
        }
        if (!bl && (interpolation == null || interpolation instanceof InterpolationNearest) && (gridCoverage2D2 = gridCoverage2D.view(ViewType.NATIVE)) != gridCoverage2D && (vector = gridCoverage2D.getRenderedImage().getSources()) != null && vector.contains(gridCoverage2D2.getRenderedImage())) {
            return ViewType.NATIVE;
        }
        return ViewType.SAME;
    }

    @Deprecated
    public static ViewType preferredViewAfterOperation(GridCoverage2D gridCoverage2D) {
        Set<ViewType> set = gridCoverage2D.getViewTypes();
        if (set.contains((Object)ViewType.GEOPHYSICS)) {
            return ViewType.GEOPHYSICS;
        }
        if (set.contains((Object)ViewType.RENDERED)) {
            return ViewType.RENDERED;
        }
        if (set.contains((Object)ViewType.PACKED)) {
            return ViewType.PACKED;
        }
        if (set.contains((Object)ViewType.PHOTOGRAPHIC)) {
            return ViewType.PHOTOGRAPHIC;
        }
        return ViewType.SAME;
    }
}

