/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.TransfertRectIter;

public class Mask
extends PointOpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.Mask";
    private final double[] newValues;

    public Mask(RenderedImage renderedImage, RenderedImage renderedImage2, ImageLayout imageLayout, Map<?, ?> map, double[] dArray) {
        super(renderedImage, renderedImage2, Mask.layout(renderedImage, imageLayout), map, false);
        this.newValues = dArray == null ? null : Arrays.copyOf(dArray, renderedImage.getSampleModel().getNumBands());
        this.permitInPlaceOperation();
    }

    private static ImageLayout layout(RenderedImage renderedImage, ImageLayout imageLayout) {
        if (imageLayout == null) {
            imageLayout = new ImageLayout();
        } else if ((imageLayout.getValidMask() & 0x300) == 0) {
            imageLayout = (ImageLayout)imageLayout.clone();
        } else {
            return imageLayout;
        }
        return imageLayout.setSampleModel(renderedImage.getSampleModel()).setColorModel(renderedImage.getColorModel());
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        assert (planarImageArray.length == 2);
        PlanarImage planarImage = planarImageArray[0];
        PlanarImage planarImage2 = planarImageArray[1];
        RectIter rectIter = RectIterFactory.create((RenderedImage)planarImage2, (Rectangle)rectangle);
        WritableRectIter writableRectIter = TransfertRectIter.create((RenderedImage)planarImage, writableRaster, rectangle);
        boolean bl = writableRectIter instanceof TransfertRectIter;
        if (writableRectIter.finishedLines()) {
            return;
        }
        int n = this.getNumBands();
        switch (this.sampleModel.getDataType()) {
            default: 
        }
        int[] nArray = ArraysExt.copyAsInts((double[])this.newValues);
        int[] nArray2 = new int[n];
        do {
            rectIter.startPixels();
            writableRectIter.startPixels();
            if (!writableRectIter.finishedPixels()) {
                do {
                    int n2 = rectIter.getSample();
                    rectIter.nextPixel();
                    if (n2 != 0) {
                        int[] nArray3;
                        if (nArray != null) {
                            nArray3 = nArray;
                        } else {
                            nArray3 = nArray2;
                            Arrays.fill(nArray2, n2);
                        }
                        writableRectIter.setPixel(nArray3);
                        continue;
                    }
                    if (!bl) continue;
                    writableRectIter.setPixel(writableRectIter.getPixel(nArray2));
                } while (!writableRectIter.nextPixelDone());
            }
            rectIter.nextLine();
        } while (!writableRectIter.nextLineDone());
    }
}

