/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import javax.imageio.IIOException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.image.io.ContinuousPalette;
import org.geotoolkit.image.io.IndexedPalette;
import org.geotoolkit.image.io.Palette;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.DefaultFileFilter;
import org.geotoolkit.io.LineFormat;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.logging.Logging;

public class PaletteFactory {
    private static final String LIST_FILE = "list.txt";
    private static final File DEFAULT_DIRECTORY = new File("colors");
    private static PaletteFactory defaultFactory;
    private PaletteFactory fallback;
    private final ClassLoader classloader;
    private final Class<?> loader;
    private final File directory;
    private final String extension;
    private final Charset charset;
    private final Locale locale;
    private transient ThreadLocal<Locale> warningLocales;
    protected final WeakHashSet<Palette> palettes = WeakHashSet.newInstance(Palette.class);
    final Set<Palette> protectedPalettes = new HashSet<Palette>();

    public static synchronized PaletteFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new PaletteFactory();
            PaletteFactory.scanForPlugins(null);
        }
        return defaultFactory;
    }

    public static synchronized void scanForPlugins(ClassLoader classLoader) {
        HashSet hashSet = new HashSet();
        Object object = PaletteFactory.getDefault();
        while (object != null) {
            hashSet.add(object.getClass());
            object = ((PaletteFactory)object).fallback;
        }
        object = classLoader == null ? ServiceLoader.load(PaletteFactory.class) : ServiceLoader.load(PaletteFactory.class, classLoader);
        Iterator iterator = ((ServiceLoader)object).iterator();
        while (iterator.hasNext()) {
            PaletteFactory paletteFactory = (PaletteFactory)iterator.next();
            if (!hashSet.add(paletteFactory.getClass())) continue;
            PaletteFactory paletteFactory2 = paletteFactory;
            while (paletteFactory2.fallback != null) {
                paletteFactory2 = paletteFactory2.fallback;
            }
            paletteFactory2.fallback = defaultFactory;
            defaultFactory = paletteFactory;
        }
    }

    protected PaletteFactory() {
        this.classloader = null;
        this.loader = this.getClass();
        this.directory = DEFAULT_DIRECTORY;
        this.extension = ".pal";
        this.charset = Charset.forName("ISO-8859-1");
        this.locale = Locale.US;
    }

    public PaletteFactory(File file, String string, Charset charset, Locale locale) {
        this.classloader = null;
        this.loader = null;
        this.directory = file;
        this.extension = PaletteFactory.startWithDot(string);
        this.charset = charset;
        this.locale = locale;
    }

    public PaletteFactory(PaletteFactory paletteFactory, ClassLoader classLoader, File file, String string, Charset charset, Locale locale) {
        this.fallback = paletteFactory;
        this.classloader = classLoader;
        this.loader = null;
        this.directory = file;
        this.extension = PaletteFactory.startWithDot(string);
        this.charset = charset;
        this.locale = locale;
    }

    public PaletteFactory(PaletteFactory paletteFactory, Class<?> clazz, File file, String string, Charset charset, Locale locale) {
        this.fallback = paletteFactory;
        this.classloader = null;
        this.loader = clazz;
        this.directory = file;
        this.extension = PaletteFactory.startWithDot(string);
        this.charset = charset;
        this.locale = locale;
    }

    private static String startWithDot(String string) {
        if (string != null && !string.startsWith(".")) {
            string = '.' + string;
        }
        return string;
    }

    public synchronized void setWarningLocale(Locale locale) {
        if (locale != null) {
            if (this.warningLocales == null) {
                this.warningLocales = this.warningLocales();
            }
            this.warningLocales.set(locale);
        } else if (this.warningLocales != null) {
            this.warningLocales.remove();
        }
    }

    private synchronized ThreadLocal<Locale> warningLocales() {
        if (this.warningLocales == null) {
            this.warningLocales = this.fallback != null ? this.fallback.warningLocales() : new ThreadLocal<Locale>();
        }
        return this.warningLocales;
    }

    public synchronized Locale getWarningLocale() {
        ThreadLocal<Locale> threadLocal = this.warningLocales;
        if (threadLocal != null) {
            return threadLocal.get();
        }
        return null;
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getWarningLocale());
    }

    protected InputStream getResourceAsStream(String string) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(string);
        }
        if (this.classloader != null) {
            return this.classloader.getResourceAsStream(string);
        }
        return null;
    }

    public Set<String> getAvailableNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        return this.getAvailableNames(linkedHashSet) ? linkedHashSet : null;
    }

    private boolean getAvailableNames(Collection<String> collection) {
        String[] stringArray;
        Object object;
        boolean bl = this.fallback != null && this.fallback.getAvailableNames(collection);
        try {
            object = this.getReader(LIST_FILE, "getAvailableNames");
            if (object != null) {
                PaletteFactory.readNames((BufferedReader)object, collection);
                bl = true;
            }
            if (this.classloader != null) {
                stringArray = new File(this.directory, LIST_FILE).getPath().replace(File.separatorChar, '/');
                Enumeration<URL> enumeration = this.classloader.getResources((String)stringArray);
                while (enumeration.hasMoreElements()) {
                    String[] stringArray2 = enumeration.nextElement();
                    object = this.getReader(stringArray2.openStream());
                    PaletteFactory.readNames((BufferedReader)object, collection);
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            Logging.unexpectedException(PaletteFactory.class, (String)"getAvailableNames", (Throwable)iOException);
        }
        object = this.directory != null ? this.directory : new File(".");
        try {
            if (this.classloader != null) {
                object = IOUtilities.toFile((URL)this.classloader.getResource(((File)object).getPath()), null);
            } else if (this.loader != null) {
                object = IOUtilities.toFile((URL)this.loader.getResource(((File)object).getPath()), null);
            }
        }
        catch (IOException iOException) {
            return bl;
        }
        if (object == null) {
            return bl;
        }
        stringArray = ((File)object).list((FilenameFilter)new DefaultFileFilter('*' + this.extension));
        if (stringArray == null) {
            return bl;
        }
        int n = this.extension.length();
        for (String string : stringArray) {
            int n2 = string.length();
            if (n2 <= n || !string.regionMatches(true, n2 - n, this.extension, 0, n)) continue;
            collection.add(string.substring(0, n2 - n));
        }
        return true;
    }

    private static void readNames(BufferedReader bufferedReader, Collection<String> collection) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty() || string.charAt(0) == '#') continue;
            collection.add(string);
        }
        bufferedReader.close();
    }

    private LineNumberReader getPaletteReader(String string) {
        if (this.extension != null && !string.endsWith(this.extension)) {
            string = string + this.extension;
        }
        return this.getReader(string, "getPalette");
    }

    private LineNumberReader getReader(String string, String string2) {
        InputStream inputStream;
        block5: {
            File file = new File(this.directory, string);
            String string3 = file.getPath().replace(File.separatorChar, '/');
            try {
                inputStream = this.getResourceAsStream(string3);
                if (inputStream != null) break block5;
                if (file.canRead()) {
                    try {
                        inputStream = new FileInputStream(file);
                        break block5;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Logging.unexpectedException(PaletteFactory.class, (String)string2, (Throwable)fileNotFoundException);
                        return null;
                    }
                }
                return null;
            }
            catch (SecurityException securityException) {
                Logging.recoverableException(PaletteFactory.class, (String)string2, (Throwable)securityException);
                return null;
            }
        }
        return this.getReader(inputStream);
    }

    private LineNumberReader getReader(InputStream inputStream) {
        return new LineNumberReader(this.charset != null ? new InputStreamReader(inputStream, this.charset) : new InputStreamReader(inputStream));
    }

    private Color[] getColors(LineNumberReader lineNumberReader, String string) throws IOException {
        String string2;
        int[] nArray = null;
        LineFormat lineFormat = this.locale != null ? new LineFormat(this.locale) : new LineFormat();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        while ((string2 = lineNumberReader.readLine()) != null) {
            try {
                Color color;
                int n;
                int n2;
                int n3;
                if ((string2 = string2.trim()).isEmpty() || string2.charAt(0) == '#' || lineFormat.setLine(string2) == 0) continue;
                nArray = lineFormat.getValues(nArray);
                int n4 = 255;
                switch (nArray.length) {
                    case 4: {
                        n4 = this.byteValue(nArray[3]);
                    }
                    case 3: {
                        n3 = this.byteValue(nArray[2]);
                        n2 = this.byteValue(nArray[1]);
                        n = this.byteValue(nArray[0]);
                        break;
                    }
                    default: {
                        throw this.syntaxError(lineNumberReader, string, null);
                    }
                }
                try {
                    color = new Color(n, n2, n3, n4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw this.syntaxError(lineNumberReader, string, illegalArgumentException);
                }
                arrayList.add(color);
            }
            catch (ParseException parseException) {
                throw this.syntaxError(lineNumberReader, string, parseException);
            }
        }
        return arrayList.toArray(new Color[arrayList.size()]);
    }

    private IIOException syntaxError(LineNumberReader lineNumberReader, String string, Exception exception) {
        String string2 = this.getErrorResources().getString(10, (Object)string, (Object)lineNumberReader.getLineNumber());
        if (exception != null) {
            string2 = string2 + exception.getLocalizedMessage();
        }
        return new IIOException(string2, exception);
    }

    public Color[] getColors(String string) throws IOException {
        Color[] colorArray;
        if (string.startsWith("#")) {
            try {
                colorArray = new Color[]{Color.decode(string)};
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        } else {
            LineNumberReader lineNumberReader = this.getPaletteReader(string);
            if (lineNumberReader == null) {
                return this.fallback != null ? this.fallback.getColors(string) : null;
            }
            colorArray = this.getColors(lineNumberReader, string);
            lineNumberReader.close();
        }
        return colorArray;
    }

    private int byteValue(int n) throws ParseException {
        if (n >= 0 && n < 256) {
            return n;
        }
        throw new ParseException(this.getErrorResources().getString(195, (Object)n), 0);
    }

    public Palette getPalette(String string, int n) {
        return this.getPalette(string, 0, n, n, 1, 0);
    }

    public Palette getPalettePadValueFirst(String string, int n) {
        return this.getPalette(string, 1, n, n, 1, 0);
    }

    public Palette getPalettePadValueLast(String string, int n) {
        return this.getPalette(string, 0, n - 1, n, 1, 0);
    }

    public Palette getPalette(String string, int n, int n2, int n3, int n4, int n5) {
        Palette palette = new IndexedPalette(this, string, n, n2, n3, n4, n5);
        palette = (Palette)this.palettes.unique((Object)palette);
        return palette;
    }

    public Palette getContinuousPalette(String string, float f, float f2, int n, int n2, int n3) {
        Palette palette = new ContinuousPalette(this, string, f, f2, n, n2, n3);
        palette = (Palette)this.palettes.unique((Object)palette);
        return palette;
    }
}

