/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import net.jcip.annotations.Immutable;
import org.geotoolkit.image.io.Palette;
import org.geotoolkit.image.io.PaletteFactory;
import org.geotoolkit.internal.image.ColorUtilities;

@Immutable
final class IndexedPalette
extends Palette {
    static final int MAX_UNSIGNED = 65535;
    protected final int lower;
    protected final int upper;
    protected final int size;

    protected IndexedPalette(PaletteFactory paletteFactory, String string, int n, int n2, int n3, int n4, int n5) {
        super(paletteFactory, string, n4, n5);
        int n6;
        int n7;
        if (n < 0) {
            n7 = Short.MIN_VALUE;
            n6 = Short.MAX_VALUE;
            n3 = n3 <= 256 ? 256 : 65536;
        } else {
            n7 = 0;
            n6 = 65535;
        }
        this.ensureInsideBounds(n, n7, n6);
        this.ensureInsideBounds(n2, n7, n6 + 1);
        this.ensureInsideBounds(n3, n2, 65536);
        if (n >= n2) {
            throw new IllegalArgumentException(paletteFactory.getErrorResources().getString(14, (Object)n, (Object)n2));
        }
        this.lower = n;
        this.upper = n2;
        this.size = n3;
    }

    @Override
    final double getScale() {
        return this.upper - this.lower;
    }

    @Override
    final double getOffset() {
        return this.lower;
    }

    private int[] createARGB() throws IOException {
        Color[] colorArray = this.factory.getColors(this.name);
        if (colorArray == null) {
            throw new FileNotFoundException(this.factory.getErrorResources().getString(64, (Object)this.name));
        }
        int[] nArray = new int[this.size];
        if (this.lower >= 0) {
            ColorUtilities.expand(colorArray, nArray, this.lower, this.upper);
        } else {
            ColorUtilities.expand(colorArray, nArray, 0, this.upper - this.lower);
            int n = this.size + this.lower;
            int n2 = -this.lower;
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            System.arraycopy(nArray, n2, nArray, 0, n);
            System.arraycopy(nArray2, 0, nArray, n, n2);
        }
        return nArray;
    }

    public static boolean isGrayPalette(int[] nArray) {
        boolean bl = nArray.length >= 256;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if ((n & 0xFF000000) != -16777216) {
                return false;
            }
            int n2 = i;
            if (bl) {
                n2 >>>= 8;
            }
            if ((n & 0xFF) == n2 && (n >>> 8 & 0xFF) == n2 && (n >>> 16 & 0xFF) == n2) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ImageTypeSpecifier createImageTypeSpecifier() throws IOException {
        SampleModel sampleModel;
        ColorModel colorModel;
        int[] nArray = this.createARGB();
        int n = ColorUtilities.getBitCount(nArray.length);
        int n2 = n <= 8 ? 0 : 1;
        boolean bl = n == 1 || n == 2 || n == 4;
        boolean bl2 = bl || n == 8 || n == 16;
        boolean bl3 = IndexedPalette.isGrayPalette(nArray);
        if (!bl3 && bl2 && 1 << n == nArray.length && this.numBands == 1) {
            byte[] byArray = new byte[nArray.length];
            byte[] byArray2 = new byte[nArray.length];
            byte[] byArray3 = new byte[nArray.length];
            byte[] byArray4 = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                byArray4[i] = (byte)(n3 & 0xFF);
                byArray3[i] = (byte)((n3 >>>= 8) & 0xFF);
                byArray2[i] = (byte)((n3 >>>= 8) & 0xFF);
                byArray[i] = (byte)((n3 >>>= 8) & 0xFF);
            }
            return ImageTypeSpecifier.createIndexed(byArray2, byArray3, byArray4, byArray, n, n2);
        }
        if (bl3) {
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            colorModel = new ComponentColorModel(colorSpace, new int[]{n}, false, true, 1, n2);
            sampleModel = colorModel.createCompatibleSampleModel(1, 1);
        } else {
            colorModel = ColorUtilities.getIndexColorModel(nArray, this.numBands, this.visibleBand, -1);
            if (bl && this.numBands == 1) {
                sampleModel = new MultiPixelPackedSampleModel(n2, 1, 1, n);
            } else {
                int[] nArray2 = new int[this.numBands];
                for (int i = 1; i < nArray2.length; ++i) {
                    nArray2[i] = i;
                }
                sampleModel = new PixelInterleavedSampleModel(n2, 1, 1, this.numBands, this.numBands, nArray2);
            }
        }
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * (this.lower + 31 * (this.upper + 31 * this.size));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IndexedPalette indexedPalette = (IndexedPalette)object;
            return this.lower == indexedPalette.lower && this.upper == indexedPalette.upper && this.size == indexedPalette.size;
        }
        return false;
    }

    public String toString() {
        return this.name + " [" + this.lower + " \u2026 " + (this.upper - 1) + "] size=" + this.size;
    }
}

