/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.color.ColorSpace;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import net.jcip.annotations.Immutable;
import org.geotoolkit.image.io.Palette;
import org.geotoolkit.image.io.PaletteFactory;
import org.geotoolkit.internal.image.ScaledColorSpace;
import org.geotoolkit.util.Utilities;

@Immutable
final class ContinuousPalette
extends Palette {
    protected final float minimum;
    protected final float maximum;
    private final int dataType;

    protected ContinuousPalette(PaletteFactory paletteFactory, String string, float f, float f2, int n, int n2, int n3) {
        super(paletteFactory, string, n2, n3);
        this.minimum = f;
        this.maximum = f2;
        this.dataType = n;
    }

    @Override
    final double getScale() {
        return this.maximum - this.minimum;
    }

    @Override
    final double getOffset() {
        return this.minimum;
    }

    @Override
    protected ImageTypeSpecifier createImageTypeSpecifier() throws IOException {
        ColorSpace colorSpace = this.minimum < this.maximum && !Float.isInfinite(this.minimum) && !Float.isInfinite(this.maximum) ? new ScaledColorSpace(this.numBands, this.visibleBand, this.minimum, this.maximum) : ColorSpace.getInstance(1003);
        int[] nArray = new int[this.numBands];
        int[] nArray2 = new int[this.numBands];
        int n = this.numBands;
        while (--n >= 0) {
            nArray[n] = n;
        }
        return ImageTypeSpecifier.createBanded(colorSpace, nArray, nArray2, this.dataType, false, false);
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 * super.hashCode() + Float.floatToIntBits(this.minimum)) + Float.floatToIntBits(this.maximum)) + this.dataType;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ContinuousPalette continuousPalette = (ContinuousPalette)object;
            return Utilities.equals((float)this.minimum, (float)continuousPalette.minimum) && Utilities.equals((float)this.maximum, (float)continuousPalette.maximum) && this.dataType == continuousPalette.dataType;
        }
        return false;
    }

    public String toString() {
        return this.name + " [" + this.minimum + " \u2026 " + this.maximum + ']';
    }
}

