/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;

public class TransfertRectIter
implements WritableRectIter {
    private static final String ERROR = "Size mismatch";
    protected final RectIter src;
    protected final WritableRectIter dst;

    protected TransfertRectIter(RectIter rectIter, WritableRectIter writableRectIter) {
        this.src = rectIter;
        this.dst = writableRectIter;
    }

    public static WritableRectIter create(RectIter rectIter, WritableRectIter writableRectIter) {
        if (rectIter == writableRectIter) {
            return writableRectIter;
        }
        return new TransfertRectIter(rectIter, writableRectIter);
    }

    public static WritableRectIter create(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage, Rectangle rectangle) {
        if (writableRenderedImage instanceof BufferedImage) {
            return TransfertRectIter.create(renderedImage, ((BufferedImage)writableRenderedImage).getRaster(), rectangle);
        }
        WritableRectIter writableRectIter = RectIterFactory.createWritable((WritableRenderedImage)writableRenderedImage, (Rectangle)rectangle);
        if (renderedImage != writableRenderedImage) {
            writableRectIter = new TransfertRectIter(RectIterFactory.create((RenderedImage)renderedImage, (Rectangle)rectangle), writableRectIter);
        }
        return writableRectIter;
    }

    public static WritableRectIter create(RenderedImage renderedImage, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = TransfertRectIter.uniqueTile(renderedImage, rectangle);
        if (raster == writableRaster) {
            return TransfertRectIter.create(raster, writableRaster, rectangle);
        }
        return new TransfertRectIter(RectIterFactory.create((RenderedImage)renderedImage, (Rectangle)rectangle), RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle));
    }

    public static WritableRectIter create(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        WritableRectIter writableRectIter = RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle);
        if (raster != writableRaster) {
            writableRectIter = new TransfertRectIter(RectIterFactory.create((Raster)raster, (Rectangle)rectangle), writableRectIter);
        }
        return writableRectIter;
    }

    private static Raster uniqueTile(RenderedImage renderedImage, Rectangle rectangle) {
        if (rectangle == null) {
            if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
                return renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            }
        } else {
            int n;
            int n2 = rectangle.x;
            int n3 = renderedImage.getTileWidth();
            int n4 = renderedImage.getTileGridXOffset();
            if ((n2 -= PlanarImage.tileXToX((int)(n = PlanarImage.XToTileX((int)n2, (int)n4, (int)n3)), (int)n4, (int)n3)) + rectangle.width <= n3) {
                int n5;
                int n6 = rectangle.y;
                int n7 = renderedImage.getTileHeight();
                int n8 = renderedImage.getTileGridYOffset();
                if ((n6 -= PlanarImage.tileYToY((int)(n5 = PlanarImage.YToTileY((int)n6, (int)n8, (int)n7)), (int)n8, (int)n7)) + rectangle.height <= n7) {
                    return renderedImage.getTile(n, n5);
                }
            }
        }
        return null;
    }

    public void startLines() {
        this.src.startLines();
        this.dst.startLines();
    }

    public void startPixels() {
        this.src.startPixels();
        this.dst.startPixels();
    }

    public void startBands() {
        this.src.startBands();
        this.dst.startBands();
    }

    public void jumpLines(int n) {
        this.src.jumpLines(n);
        this.dst.jumpLines(n);
    }

    public void jumpPixels(int n) {
        this.src.jumpPixels(n);
        this.dst.jumpPixels(n);
    }

    public void nextLine() {
        this.src.nextLine();
        this.dst.nextLine();
    }

    public void nextPixel() {
        this.src.nextPixel();
        this.dst.nextPixel();
    }

    public void nextBand() {
        this.src.nextBand();
        this.dst.nextBand();
    }

    public boolean nextLineDone() {
        boolean bl = this.src.nextLineDone();
        if (bl == this.dst.nextLineDone()) {
            return bl;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean nextPixelDone() {
        boolean bl = this.src.nextPixelDone();
        if (bl == this.dst.nextPixelDone()) {
            return bl;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean nextBandDone() {
        boolean bl = this.src.nextBandDone();
        if (bl == this.dst.nextBandDone()) {
            return bl;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean finishedLines() {
        boolean bl = this.src.finishedLines();
        if (bl == this.dst.finishedLines()) {
            return bl;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean finishedPixels() {
        boolean bl = this.src.finishedPixels();
        if (bl == this.dst.finishedPixels()) {
            return bl;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean finishedBands() {
        boolean bl = this.src.finishedBands();
        if (bl == this.dst.finishedBands()) {
            return bl;
        }
        throw new RasterFormatException(ERROR);
    }

    public int[] getPixel(int[] nArray) {
        return this.src.getPixel(nArray);
    }

    public float[] getPixel(float[] fArray) {
        return this.src.getPixel(fArray);
    }

    public double[] getPixel(double[] dArray) {
        return this.src.getPixel(dArray);
    }

    public int getSample() {
        return this.src.getSample();
    }

    public int getSample(int n) {
        return this.src.getSample(n);
    }

    public float getSampleFloat() {
        return this.src.getSampleFloat();
    }

    public float getSampleFloat(int n) {
        return this.src.getSampleFloat(n);
    }

    public double getSampleDouble() {
        return this.src.getSampleDouble();
    }

    public double getSampleDouble(int n) {
        return this.src.getSampleDouble(n);
    }

    public void setPixel(int[] nArray) {
        this.dst.setPixel(nArray);
    }

    public void setPixel(float[] fArray) {
        this.dst.setPixel(fArray);
    }

    public void setPixel(double[] dArray) {
        this.dst.setPixel(dArray);
    }

    public void setSample(int n) {
        this.dst.setSample(n);
    }

    public void setSample(float f) {
        this.dst.setSample(f);
    }

    public void setSample(double d) {
        this.dst.setSample(d);
    }

    public void setSample(int n, int n2) {
        this.dst.setSample(n, n2);
    }

    public void setSample(int n, float f) {
        this.dst.setSample(n, f);
    }

    public void setSample(int n, double d) {
        this.dst.setSample(n, d);
    }
}

