/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;

public final class SampleModels
extends Static {
    private SampleModels() {
    }

    public static int getDataTypeSize(SampleModel sampleModel) {
        return DataBuffer.getDataTypeSize(sampleModel.getDataType());
    }

    public static int getScanlineStride(SampleModel sampleModel) throws IllegalArgumentException {
        if (sampleModel instanceof ComponentSampleModel) {
            return ((ComponentSampleModel)sampleModel).getScanlineStride();
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        }
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            return ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        }
        throw new IllegalArgumentException(Errors.format((int)226, (Object)Classes.getShortClassName((Object)sampleModel)));
    }

    public static float getPixelStride(SampleModel sampleModel) throws IllegalArgumentException {
        if (sampleModel instanceof ComponentSampleModel) {
            return ((ComponentSampleModel)sampleModel).getPixelStride();
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return 1.0f;
        }
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            return (float)((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() / (float)SampleModels.getDataTypeSize(sampleModel);
        }
        throw new IllegalArgumentException(Errors.format((int)226, (Object)Classes.getShortClassName((Object)sampleModel)));
    }

    public static int getPixelBitStride(SampleModel sampleModel) throws IllegalArgumentException {
        if (sampleModel instanceof ComponentSampleModel) {
            return ((ComponentSampleModel)sampleModel).getPixelStride() * SampleModels.getDataTypeSize(sampleModel);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return SampleModels.getDataTypeSize(sampleModel);
        }
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            return ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
        }
        throw new IllegalArgumentException(Errors.format((int)226, (Object)Classes.getShortClassName((Object)sampleModel)));
    }
}

