/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image;

import com.sun.media.jai.util.ImageUtil;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.NullDescriptor;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.image.ImageWorker;
import org.geotoolkit.internal.image.ColorModels;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.coverage.PaletteInterpretation;

@Deprecated
public class ImageInspector {
    public static final PaletteInterpretation IHS = PaletteInterpretation.valueOf((String)"IHS");
    public static final Hints.Key IGNORE_FULLY_TRANSPARENT_PIXELS = new Hints.Key(Boolean.class);
    private static final String EXTREMA = "extrema";
    private RenderedImage inheritanceStopPoint;
    protected RenderedImage image;
    private ROI roi;
    private RenderingHints commonHints;
    private int tileCacheDisabled;
    private transient TileCache nullCache;

    public ImageInspector(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"image", (Object)renderedImage);
        this.inheritanceStopPoint = this.image = renderedImage;
    }

    ImageInspector(ImageInspector imageInspector) {
        this(imageInspector.image);
        if (!XCollections.isNullOrEmpty((Map)imageInspector.commonHints)) {
            this.commonHints = new RenderingHints(null);
            this.commonHints.add(imageInspector.commonHints);
        }
    }

    public void setImage(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"image", (Object)renderedImage);
        this.inheritanceStopPoint = this.image = renderedImage;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public BufferedImage getBufferedImage() {
        if (this.image instanceof BufferedImage) {
            return (BufferedImage)this.image;
        }
        return this.getPlanarImage().getAsBufferedImage();
    }

    public PlanarImage getPlanarImage() {
        return PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
    }

    public RenderedOp getRenderedOperation() {
        RenderedImage renderedImage = this.getRenderedImage();
        if (renderedImage instanceof RenderedOp) {
            return (RenderedOp)renderedImage;
        }
        return NullDescriptor.create((RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
    }

    public ROI getImageAsROI() {
        ImageWorker imageWorker = new ImageWorker(this);
        imageWorker.binarize(true);
        return new ROI(imageWorker.getRenderedImage());
    }

    public ROI getROI() {
        return this.roi;
    }

    public void setROI(ROI rOI) {
        this.roi = rOI;
        this.invalidateStatistics();
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = ImageUtilities.getRenderingHints(this.image);
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
            if (this.commonHints != null) {
                renderingHints.add(this.commonHints);
            }
        } else if (this.commonHints != null) {
            renderingHints.add(this.commonHints);
        }
        if (Boolean.FALSE.equals(renderingHints.get(ImageWorker.TILING_ALLOWED))) {
            ImageLayout imageLayout = ImageInspector.getImageLayout(renderingHints);
            if (this.commonHints == null || imageLayout != this.commonHints.get(JAI.KEY_IMAGE_LAYOUT)) {
                imageLayout.setTileWidth(this.image.getWidth());
                imageLayout.setTileHeight(this.image.getHeight());
                imageLayout.setTileGridXOffset(this.image.getMinX());
                imageLayout.setTileGridYOffset(this.image.getMinY());
                renderingHints.put(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            }
        }
        if (this.tileCacheDisabled != 0) {
            if (this.nullCache == null) {
                this.nullCache = JAI.createTileCache((long)0L);
            }
            renderingHints.put(JAI.KEY_TILE_CACHE, this.nullCache);
        }
        return renderingHints;
    }

    final RenderingHints getRenderingHints(int n) {
        RenderingHints renderingHints = this.getRenderingHints();
        ImageLayout imageLayout = ImageInspector.getImageLayout(renderingHints);
        if (imageLayout.isValid(512)) {
            return renderingHints;
        }
        ColorModel colorModel = this.image.getColorModel();
        this.setColorModel(renderingHints, new ComponentColorModel(colorModel.getColorSpace(), colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency(), n));
        return renderingHints;
    }

    final ColorModel setColorModel(RenderingHints renderingHints, ColorModel colorModel) {
        ImageLayout imageLayout = this.modifiable(ImageInspector.getImageLayout(renderingHints), renderingHints);
        if (colorModel != null) {
            colorModel = ColorModels.unique(colorModel);
            SampleModel sampleModel = colorModel.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight());
            imageLayout.setColorModel(colorModel);
            imageLayout.setSampleModel(sampleModel);
        } else {
            imageLayout.unsetValid(768);
        }
        return colorModel;
    }

    static ImageLayout getImageLayout(RenderingHints renderingHints) {
        Object object = renderingHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (object instanceof ImageLayout) {
            return (ImageLayout)object;
        }
        return new ImageLayout();
    }

    final ImageLayout modifiable(ImageLayout imageLayout, RenderingHints renderingHints) {
        if (this.commonHints != null && imageLayout == this.commonHints.get(JAI.KEY_IMAGE_LAYOUT)) {
            imageLayout = (ImageLayout)imageLayout.clone();
        }
        renderingHints.put(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        return imageLayout;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        ArgumentChecks.ensureNonNull((String)"key", (Object)key);
        return this.commonHints != null ? this.commonHints.get(key) : null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        ArgumentChecks.ensureNonNull((String)"key", (Object)key);
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        this.commonHints.add(new RenderingHints(key, object));
    }

    public void removeRenderingHint(RenderingHints.Key key) {
        ArgumentChecks.ensureNonNull((String)"key", (Object)key);
        if (this.commonHints != null) {
            this.commonHints.remove(key);
        }
    }

    public int getNumBands() {
        return this.image.getSampleModel().getNumBands();
    }

    private Object getComputedProperty(String string) {
        Object object = this.image.getProperty(string);
        return object == this.inheritanceStopPoint.getProperty(string) ? Image.UndefinedProperty : object;
    }

    final double[][] getExtremas() {
        Object object = this.getComputedProperty(EXTREMA);
        if (!(object instanceof double[][])) {
            Integer n = 1;
            this.image = ExtremaDescriptor.create((RenderedImage)this.image, (ROI)this.roi, (Integer)n, (Integer)n, null, (Integer)n, (RenderingHints)this.getRenderingHints());
            object = this.getComputedProperty(EXTREMA);
        }
        return (double[][])object;
    }

    final void invalidateStatistics() {
        this.inheritanceStopPoint = this.image;
    }

    public double[] getMinimums() {
        return this.getExtremas()[0];
    }

    public double[] getMaximums() {
        return this.getExtremas()[1];
    }

    public int getTransparentPixel() {
        ColorModel colorModel = this.image.getColorModel();
        return colorModel instanceof IndexColorModel ? ((IndexColorModel)colorModel).getTransparentPixel() : -1;
    }

    public boolean isTranslucent() {
        return this.image.getColorModel().getTransparency() == 3;
    }

    public boolean isTiled() {
        return this.image.getNumXTiles() != 1 || this.image.getNumYTiles() != 1;
    }

    public boolean isBytes() {
        return this.image.getSampleModel().getDataType() == 0;
    }

    public boolean isBinary() {
        return ImageUtil.isBinary((SampleModel)this.image.getSampleModel());
    }

    public boolean isIndexed() {
        return this.image.getColorModel() instanceof IndexColorModel;
    }

    public boolean isGrayScale() {
        ColorModel colorModel = this.image.getColorModel();
        if (colorModel != null) {
            Serializable serializable;
            if (colorModel instanceof IndexColorModel) {
                serializable = null;
                if (this.commonHints != null) {
                    serializable = (Boolean)this.commonHints.get(IGNORE_FULLY_TRANSPARENT_PIXELS);
                }
                if (serializable == null) {
                    serializable = Boolean.TRUE;
                }
                if (ColorUtilities.isGrayPalette((IndexColorModel)colorModel, (Boolean)serializable)) {
                    return true;
                }
            }
            if ((serializable = colorModel.getColorSpace()) != null) {
                return serializable.getType() == 6;
            }
        }
        return false;
    }

    public PaletteInterpretation getColorSpaceType() {
        ColorSpace colorSpace;
        ColorModel colorModel = this.image.getColorModel();
        if (colorModel != null && (colorSpace = colorModel.getColorSpace()) != null) {
            switch (colorSpace.getType()) {
                case 6: {
                    return PaletteInterpretation.GRAY;
                }
                case 5: {
                    return PaletteInterpretation.RGB;
                }
                case 9: {
                    return PaletteInterpretation.CMYK;
                }
                case 8: {
                    return PaletteInterpretation.HLS;
                }
                case 7: {
                    if (!(colorSpace instanceof IHSColorSpace)) break;
                    return IHS;
                }
            }
        }
        return null;
    }

    public void show() throws HeadlessException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.geotoolkit.gui.swing.image.OperationTreeBrowser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            HeadlessException headlessException = new HeadlessException("The \"geotk-widgets-swing.jar\" file is required.");
            headlessException.initCause(classNotFoundException);
            throw headlessException;
        }
        try {
            clazz.getMethod("show", RenderedImage.class).invoke(null, this.image);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void enableTileCache(boolean bl) {
        if (bl) {
            if (this.tileCacheDisabled == 0) throw new IllegalStateException();
            --this.tileCacheDisabled;
            return;
        } else {
            ++this.tileCacheDisabled;
        }
    }
}

