/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing.operation;

import java.lang.reflect.Array;
import javax.media.jai.Interpolation;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.Interpolator2D;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.processing.Operation2D;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.opengis.coverage.Coverage;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@Immutable
public class Interpolate
extends Operation2D {
    private static final long serialVersionUID = 6742127682733620661L;
    public static final ParameterDescriptor<Object> TYPE = new DefaultParameterDescriptor(Citations.OGC, "Type", Object.class, null, (Object)"NearestNeighbor", null, null, null, true);

    public Interpolate() {
        super((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(Citations.OGC, "Interpolate", new GeneralParameterDescriptor[]{SOURCE_0, TYPE}));
    }

    @Override
    protected ViewType getComputationView(ParameterValueGroup parameterValueGroup) {
        return ViewType.SAME;
    }

    @Override
    protected Coverage doOperation(ParameterValueGroup parameterValueGroup, Hints hints) {
        Interpolation[] interpolationArray;
        GridCoverage2D[] gridCoverage2DArray = new GridCoverage2D[1];
        ViewType viewType = this.extractSources(parameterValueGroup, gridCoverage2DArray);
        GridCoverage2D gridCoverage2D = gridCoverage2DArray[0];
        Object object = parameterValueGroup.parameter("Type").getValue();
        if (object.getClass().isArray()) {
            interpolationArray = new Interpolation[Array.getLength(object)];
            for (int i = 0; i < interpolationArray.length; ++i) {
                interpolationArray[i] = ImageUtilities.toInterpolation(Array.get(object, i));
            }
        } else {
            interpolationArray = new Interpolation[]{ImageUtilities.toInterpolation(object)};
        }
        return Interpolator2D.create(gridCoverage2D, interpolationArray).view(viewType);
    }
}

