/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing.operation;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import javax.measure.unit.Unit;
import javax.media.jai.KernelJAI;
import javax.media.jai.ParameterBlockJAI;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.processing.OperationJAI;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.util.NumberRange;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class GradientMagnitude
extends OperationJAI {
    private static final long serialVersionUID = -1514713427236924048L;
    private static final boolean DEBUG = false;
    private static final boolean NORMALIZE = true;
    private static final double DEFAULT_RANGE_SCALE = 1.0;
    private static final Color[] DEFAULT_COLOR_PALETTE = new Color[]{new Color(16, 32, 64), new Color(192, 224, 255)};
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;

    public GradientMagnitude() {
        super("GradientMagnitude");
    }

    private static double getScaleFactor(KernelJAI kernelJAI, double d, double d2) {
        d *= d;
        d2 *= d2;
        double d3 = GradientMagnitude.getNormalizationFactorSquared(kernelJAI, 1);
        double d4 = GradientMagnitude.getNormalizationFactorSquared(kernelJAI, 2);
        double d5 = (d3 * d + d4 * d2) / (d3 + d4);
        return Math.sqrt(d5);
    }

    private static double getNormalizationFactorSquared(KernelJAI kernelJAI, int n) {
        int n2;
        int n3;
        int n4;
        double d = 0.0;
        double d2 = 0.0;
        int n5 = kernelJAI.getWidth();
        int n6 = kernelJAI.getHeight();
        if ((n & 1) != 0) {
            n4 = kernelJAI.getYOrigin();
            n3 = n6;
            while (--n3 >= 0) {
                n2 = n5;
                while (--n2 >= 0) {
                    d += (double)((float)n4 * kernelJAI.getElement(n2, n3));
                }
                --n4;
            }
        }
        if ((n & 2) != 0) {
            n4 = kernelJAI.getXOrigin();
            n3 = n5;
            while (--n3 >= 0) {
                n2 = n6;
                while (--n2 >= 0) {
                    d2 += (double)((float)n4 * kernelJAI.getElement(n3, n2));
                }
                --n4;
            }
        }
        return d * d + d2 * d2;
    }

    private static double getNormalizationFactor(KernelJAI kernelJAI, KernelJAI kernelJAI2) {
        double d = GradientMagnitude.getNormalizationFactorSquared(kernelJAI, 3);
        d += GradientMagnitude.getNormalizationFactorSquared(kernelJAI2, 3);
        d = Math.sqrt(d / 2.0);
        return d;
    }

    private static KernelJAI divide(KernelJAI kernelJAI, double d) {
        if (d != 1.0) {
            float[] fArray = kernelJAI.getKernelData();
            int n = fArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                fArray[n3] = (float)((double)fArray[n3] / d);
            }
            kernelJAI = new KernelJAI(kernelJAI.getWidth(), kernelJAI.getHeight(), kernelJAI.getXOrigin(), kernelJAI.getYOrigin(), fArray);
        }
        return kernelJAI;
    }

    @Override
    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] gridCoverage2DArray, OperationJAI.Parameters parameters) {
        MathTransform2D mathTransform2D;
        KernelJAI kernelJAI;
        ParameterBlockJAI parameterBlockJAI = parameters.parameters;
        KernelJAI kernelJAI2 = (KernelJAI)parameterBlockJAI.getObjectParameter("Mask1");
        double d = GradientMagnitude.getNormalizationFactor(kernelJAI2, kernelJAI = (KernelJAI)parameterBlockJAI.getObjectParameter("Mask2"));
        if (!(d > 0.0)) {
            d = 1.0;
        }
        double d2 = 1.0;
        double d3 = 1.0;
        if (gridCoverage2DArray.length != 0 && (mathTransform2D = gridCoverage2DArray[0].getGridGeometry().getGridToCRS2D()) instanceof AffineTransform) {
            AffineTransform affineTransform = (AffineTransform)mathTransform2D;
            double d4 = XAffineTransform.getScaleX0((AffineTransform)affineTransform);
            double d5 = XAffineTransform.getScaleY0((AffineTransform)affineTransform);
            d2 = GradientMagnitude.getScaleFactor(kernelJAI2, d4, d5);
            d3 = GradientMagnitude.getScaleFactor(kernelJAI, d4, d5);
            if (!(d2 > 0.0) || !(d3 > 0.0)) {
                d2 = 1.0;
                d3 = 1.0;
            }
        }
        parameterBlockJAI.setParameter("Mask1", (Object)GradientMagnitude.divide(kernelJAI2, d * d2));
        parameterBlockJAI.setParameter("Mask2", (Object)GradientMagnitude.divide(kernelJAI, d * d3));
        return super.deriveGridCoverage(gridCoverage2DArray, parameters);
    }

    @Override
    protected Category deriveCategory(Category[] categoryArray, OperationJAI.Parameters parameters) {
        NumberRange numberRange = null;
        Category category = categoryArray[0];
        NumberRange<?> numberRange2 = category.geophysics(false).getRange();
        boolean bl = category == category.geophysics(true);
        ParameterBlockJAI parameterBlockJAI = parameters.parameters;
        KernelJAI kernelJAI = (KernelJAI)parameterBlockJAI.getObjectParameter("Mask1");
        KernelJAI kernelJAI2 = (KernelJAI)parameterBlockJAI.getObjectParameter("Mask2");
        double d = (double)(kernelJAI.getWidth() + kernelJAI.getHeight() + kernelJAI2.getWidth() + kernelJAI2.getHeight()) / 4.0;
        double d2 = GradientMagnitude.getNormalizationFactor(kernelJAI, kernelJAI2) / (d - 1.0);
        if (d2 > 0.0 && !Double.isInfinite(d2)) {
            numberRange = category.geophysics(true).getRange();
            double d3 = numberRange.getMinimum();
            double d4 = numberRange.getMaximum();
            numberRange = NumberRange.create((double)0.0, (double)(d2 *= (d4 - d3) * 1.0));
        }
        if (numberRange != null) {
            category = new Category((CharSequence)category.getName(), DEFAULT_COLOR_PALETTE, numberRange2, numberRange);
            return category.geophysics(bl);
        }
        return super.deriveCategory(categoryArray, parameters);
    }

    @Override
    protected Unit<?> deriveUnit(Unit<?>[] unitArray, OperationJAI.Parameters parameters) {
        CoordinateSystem coordinateSystem = parameters.crs.getCoordinateSystem();
        if (unitArray.length == 1 && unitArray[0] != null) {
            Unit unit = coordinateSystem.getAxis(0).getUnit();
            int n = Math.min(coordinateSystem.getDimension(), 2);
            while (--n >= 0) {
                if (unit.equals((Object)coordinateSystem.getAxis(n).getUnit())) continue;
                return super.deriveUnit(unitArray, parameters);
            }
            try {
                return unitArray[0].divide(unit);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return super.deriveUnit(unitArray, parameters);
    }
}

