/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.processing.OperationJAI;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.ColorUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;

final class BandSelector2D
extends GridCoverage2D {
    private static final long serialVersionUID = -6572017920456641730L;
    private final int[] bandIndices;

    private BandSelector2D(GridCoverage2D gridCoverage2D, PlanarImage planarImage, GridSampleDimension[] gridSampleDimensionArray, int[] nArray, Hints hints) {
        super((CharSequence)gridCoverage2D.getName(), (RenderedImage)planarImage, gridCoverage2D.getGridGeometry(), gridSampleDimensionArray, (GridCoverage[])new GridCoverage2D[]{gridCoverage2D}, null, hints);
        this.bandIndices = nArray;
        assert (nArray == null || nArray.length == gridSampleDimensionArray.length);
    }

    static GridCoverage2D create(GridCoverage2D gridCoverage2D, ParameterValueGroup parameterValueGroup, Hints hints) {
        IndexColorModel indexColorModel;
        Object object;
        int n;
        int n2;
        RenderedImage renderedImage;
        GridSampleDimension[] gridSampleDimensionArray;
        GridSampleDimension[] gridSampleDimensionArray2;
        int[] nArray = parameterValueGroup.parameter("SampleDimensions").intValueList();
        if (nArray != null) {
            nArray = (int[])nArray.clone();
        }
        Integer n3 = (Integer)parameterValueGroup.parameter("VisibleSampleDimension").getValue();
        while (true) {
            gridSampleDimensionArray = gridSampleDimensionArray2 = gridCoverage2D.getSampleDimensions();
            if (nArray != null) {
                if (nArray.length != gridSampleDimensionArray2.length || !BandSelector2D.isIdentity(nArray)) {
                    gridSampleDimensionArray = new GridSampleDimension[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        gridSampleDimensionArray[i] = gridSampleDimensionArray2[nArray[i]];
                    }
                } else {
                    nArray = null;
                }
            }
            renderedImage = gridCoverage2D.getRenderedImage();
            n2 = CoverageUtilities.getVisibleBand(renderedImage);
            if (n3 != null) {
                n = BandSelector2D.mapSourceToTarget(n3, nArray);
                if (n2 < 0) {
                    throw new IllegalArgumentException("Visible sample dimension is not among the ones specified in SampleDimensions param");
                }
            } else {
                n = BandSelector2D.mapSourceToTarget(n2, nArray);
                if (n < 0) {
                    n = 0;
                }
            }
            if (nArray == null && n2 == n) {
                return gridCoverage2D;
            }
            if (!(gridCoverage2D instanceof BandSelector2D)) break;
            int[] nArray2 = ((BandSelector2D)gridCoverage2D).bandIndices;
            if (nArray2 != null) {
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = nArray2[nArray[i]];
                    }
                } else {
                    nArray = (int[])nArray2.clone();
                }
            }
            assert (gridCoverage2D.getSources().size() == 1) : gridCoverage2D;
            gridCoverage2D = (GridCoverage2D)gridCoverage2D.getSources().get(0);
        }
        String string = "Null";
        ImageLayout imageLayout = null;
        if (hints != null) {
            imageLayout = (ImageLayout)hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
        }
        if (imageLayout == null) {
            imageLayout = new ImageLayout();
        }
        if (n3 != null || !imageLayout.isValid(512)) {
            object = renderedImage.getColorModel();
            if (object instanceof IndexColorModel && gridSampleDimensionArray2[n2].equals(gridSampleDimensionArray[n])) {
                indexColorModel = (IndexColorModel)object;
                int[] nArray3 = new int[indexColorModel.getMapSize()];
                indexColorModel.getRGBs(nArray3);
                object = ColorUtilities.getIndexColorModel(nArray3, gridSampleDimensionArray.length, n, -1);
            } else {
                object = gridSampleDimensionArray[n].getColorModel(n, gridSampleDimensionArray.length);
            }
            if (object != null) {
                imageLayout.setColorModel((ColorModel)object);
            }
            if (hints != null) {
                hints = hints.clone();
                hints.put((Object)JAI.KEY_IMAGE_LAYOUT, (Object)imageLayout);
            } else {
                hints = new Hints(JAI.KEY_IMAGE_LAYOUT, (Object)imageLayout);
            }
        }
        if (n3 == null) {
            n3 = n;
        }
        object = new ParameterBlock().addSource(renderedImage);
        if (gridSampleDimensionArray != gridSampleDimensionArray2) {
            string = "BandSelect";
            object = ((ParameterBlock)object).add(nArray);
        }
        indexColorModel = OperationJAI.getJAI((RenderingHints)hints).createNS(string, (ParameterBlock)object, (RenderingHints)hints);
        indexColorModel.setProperty("GC_VisibleBand", n3);
        return new BandSelector2D(gridCoverage2D, (PlanarImage)indexColorModel, gridSampleDimensionArray, nArray, hints);
    }

    private static int mapSourceToTarget(int n, int[] nArray) {
        if (nArray == null) {
            return n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private static boolean isIdentity(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == i) continue;
            return false;
        }
        return true;
    }
}

