/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import javax.measure.unit.Unit;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.referencing.operation.MathTransform1D;

public class RangeSpecifier
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8436500582161136302L;
    private NumberRange<?> range;
    private MathTransform1D transform;
    private Unit<?> unit;
    private Color[] colors;

    public RangeSpecifier() {
    }

    public RangeSpecifier(NumberRange<?> numberRange) {
        this.range = numberRange;
    }

    public RangeSpecifier(MathTransform1D mathTransform1D) {
        this.transform = mathTransform1D;
    }

    public NumberRange<?> getRange() {
        return this.range;
    }

    public void setRange(NumberRange<?> numberRange) {
        this.range = numberRange;
        this.transform = null;
    }

    public MathTransform1D getSampleToGeophysics() {
        return this.transform;
    }

    public void setSampleToGeophysics(MathTransform1D mathTransform1D) {
        this.transform = mathTransform1D;
        this.range = null;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public void setUnit(Unit<?> unit) {
        this.unit = unit;
    }

    public Color[] getColors() {
        return this.colors != null ? (Color[])this.colors.clone() : null;
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray != null ? (Color[])colorArray.clone() : null;
    }

    public RangeSpecifier clone() {
        try {
            return (RangeSpecifier)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int hashCode() {
        int n = -1156105554;
        if (this.range != null) {
            n += this.range.hashCode();
        }
        if (this.transform != null) {
            n += this.transform.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            RangeSpecifier rangeSpecifier = (RangeSpecifier)object;
            return Utilities.equals(this.range, rangeSpecifier.range) && Utilities.equals((Object)this.transform, (Object)rangeSpecifier.transform) && Utilities.equals(this.unit, rangeSpecifier.unit) && Arrays.equals(this.colors, rangeSpecifier.colors);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this));
        stringBuilder.append('[');
        if (this.range != null) {
            stringBuilder.append(this.range);
        } else if (this.transform != null) {
            stringBuilder.append(this.transform);
        }
        return stringBuilder.append(']').toString();
    }
}

