/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.coverage.CoverageFactoryFinder;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.coverage.processing.ColorMap;
import org.geotoolkit.coverage.processing.CoverageProcessingException;
import org.geotoolkit.coverage.processing.operation.Resample;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.resources.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
public class Operations {
    public static final Operations DEFAULT = new Operations(null);
    protected final AbstractCoverageProcessor processor;

    public Operations(Hints hints) {
        if (hints == null) {
            this.processor = AbstractCoverageProcessor.getInstance();
        } else {
            Object object = hints.get((Object)Hints.GRID_COVERAGE_PROCESSOR);
            if (AbstractCoverageProcessor.class.isInstance(object)) {
                this.processor = (AbstractCoverageProcessor)((Object)object);
            } else {
                if (!(object instanceof Class) || !AbstractCoverageProcessor.class.isAssignableFrom((Class)object)) {
                    hints = hints.clone();
                    hints.put((Object)Hints.GRID_COVERAGE_PROCESSOR, AbstractCoverageProcessor.class);
                }
                this.processor = (AbstractCoverageProcessor)CoverageFactoryFinder.getCoverageProcessor(hints);
            }
        }
    }

    public Coverage add(Coverage coverage, double ... dArray) throws CoverageProcessingException {
        return this.doOperation("AddConst", coverage, "constants", dArray);
    }

    public Coverage subtract(Coverage coverage, double ... dArray) throws CoverageProcessingException {
        return this.doOperation("SubtractConst", coverage, "constants", dArray);
    }

    public Coverage subtractFrom(Coverage coverage, double ... dArray) throws CoverageProcessingException {
        return this.doOperation("SubtractFromConst", coverage, "constants", dArray);
    }

    public Coverage multiply(Coverage coverage, double ... dArray) throws CoverageProcessingException {
        return this.doOperation("MultiplyConst", coverage, "constants", dArray);
    }

    public Coverage divideBy(Coverage coverage, double ... dArray) throws CoverageProcessingException {
        return this.doOperation("DivideByConst", coverage, "constants", dArray);
    }

    public Coverage rescale(Coverage coverage, double[] dArray, double[] dArray2) throws CoverageProcessingException {
        return this.doOperation("Rescale", coverage, "constants", dArray, "offsets", dArray2);
    }

    public Coverage invert(Coverage coverage) throws CoverageProcessingException {
        return this.doOperation("Invert", coverage);
    }

    public Coverage absolute(Coverage coverage) throws CoverageProcessingException {
        return this.doOperation("Absolute", coverage);
    }

    public Coverage log(Coverage coverage) throws CoverageProcessingException {
        return this.doOperation("Log", coverage);
    }

    public Coverage exp(Coverage coverage) throws CoverageProcessingException {
        return this.doOperation("Exp", coverage);
    }

    public GridCoverage nodataFilter(GridCoverage gridCoverage) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("NodataFilter", (Coverage)gridCoverage);
    }

    public GridCoverage nodataFilter(GridCoverage gridCoverage, int n, int n2) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("NodataFilter", (Coverage)gridCoverage, "padding", n, "validityThreshold", n2);
    }

    public GridCoverage interpolate(GridCoverage gridCoverage, String string) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", (Coverage)gridCoverage, "Type", string);
    }

    public GridCoverage interpolate(GridCoverage gridCoverage, Interpolation interpolation) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", (Coverage)gridCoverage, "Type", interpolation);
    }

    public GridCoverage interpolate(GridCoverage gridCoverage, Interpolation ... interpolationArray) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", (Coverage)gridCoverage, "Type", interpolationArray);
    }

    public GridCoverage recolor(GridCoverage gridCoverage, ColorMap ... colorMapArray) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Recolor", (Coverage)gridCoverage, "ColorMaps", colorMapArray);
    }

    public Coverage selectSampleDimension(Coverage coverage, int ... nArray) throws CoverageProcessingException {
        return this.doOperation("SelectSampleDimension", coverage, "SampleDimensions", nArray);
    }

    public Coverage resample(Coverage coverage, CoordinateReferenceSystem coordinateReferenceSystem) throws CoverageProcessingException {
        return this.doOperation("Resample", coverage, "CoordinateReferenceSystem", coordinateReferenceSystem);
    }

    public Coverage resample(GridCoverage gridCoverage, Envelope envelope, Interpolation interpolation) throws CoverageProcessingException {
        GridGeometry gridGeometry;
        try {
            gridGeometry = Resample.computeGridGeometry(gridCoverage, envelope);
        }
        catch (TransformException transformException) {
            throw new CoverageProcessingException(transformException);
        }
        return this.doOperation("Resample", (Coverage)gridCoverage, "CoordinateReferenceSystem", envelope.getCoordinateReferenceSystem(), "GridGeometry", gridGeometry, "InterpolationType", interpolation);
    }

    public Coverage resample(GridCoverage gridCoverage, CoordinateReferenceSystem coordinateReferenceSystem, GridGeometry gridGeometry, Interpolation interpolation) throws CoverageProcessingException {
        return this.doOperation("Resample", (Coverage)gridCoverage, "CoordinateReferenceSystem", coordinateReferenceSystem, "GridGeometry", gridGeometry, "InterpolationType", interpolation);
    }

    public Coverage crop(Coverage coverage, Envelope envelope) throws CoverageProcessingException {
        return this.doOperation("CoverageCrop", coverage, "Envelope", envelope);
    }

    public GridCoverage scale(GridCoverage gridCoverage, double d, double d2, double d3, double d4) throws CoverageProcessingException {
        return this.scale(gridCoverage, d, d2, d3, d4, Interpolation.getInstance((int)0));
    }

    public GridCoverage scale(GridCoverage gridCoverage, double d, double d2, double d3, double d4, Interpolation interpolation) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Scale", (Coverage)gridCoverage, "xScale", Float.valueOf((float)d), "yScale", Float.valueOf((float)d2), "xTrans", Float.valueOf((float)d3), "yTrans", Float.valueOf((float)d4), "Interpolation", interpolation);
    }

    public GridCoverage subsampleAverage(GridCoverage gridCoverage, double d, double d2) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("SubsampleAverage", (Coverage)gridCoverage, "scaleX", d, "scaleY", d2);
    }

    public GridCoverage filteredSubsample(GridCoverage gridCoverage) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("FilteredSubsample", (Coverage)gridCoverage);
    }

    public GridCoverage filteredSubsample(GridCoverage gridCoverage, int n, int n2, float[] fArray) throws CoverageProcessingException {
        return this.filteredSubsample(gridCoverage, n, n2, fArray, Interpolation.getInstance((int)0));
    }

    public GridCoverage filteredSubsample(GridCoverage gridCoverage, int n, int n2, float[] fArray, Interpolation interpolation) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("FilteredSubsample", (Coverage)gridCoverage, "scaleX", n, "scaleY", n2, "qsFilterArray", fArray, "Interpolation", interpolation);
    }

    public Coverage gradientMagnitude(Coverage coverage) throws CoverageProcessingException {
        return this.doOperation("GradientMagnitude", coverage);
    }

    public Coverage gradientMagnitude(Coverage coverage, KernelJAI kernelJAI, KernelJAI kernelJAI2) throws CoverageProcessingException {
        return this.doOperation("GradientMagnitude", coverage, "mask1", kernelJAI, "mask2", kernelJAI2);
    }

    protected final Coverage doOperation(String string, Coverage coverage) throws OperationNotFoundException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        return this.processor.doOperation(parameterValueGroup);
    }

    protected final Coverage doOperation(String string, Coverage coverage, String string2, Object object) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        Operations.setParameterValue(parameterValueGroup, string2, object);
        return this.processor.doOperation(parameterValueGroup);
    }

    protected final Coverage doOperation(String string, Coverage coverage, String string2, Object object, String string3, Object object2) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        Operations.setParameterValue(parameterValueGroup, string2, object);
        Operations.setParameterValue(parameterValueGroup, string3, object2);
        return this.processor.doOperation(parameterValueGroup);
    }

    protected final Coverage doOperation(String string, Coverage coverage, String string2, Object object, String string3, Object object2, String string4, Object object3) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        Operations.setParameterValue(parameterValueGroup, string2, object);
        Operations.setParameterValue(parameterValueGroup, string3, object2);
        Operations.setParameterValue(parameterValueGroup, string4, object3);
        return this.processor.doOperation(parameterValueGroup);
    }

    protected final Coverage doOperation(String string, Coverage coverage, String string2, Object object, String string3, Object object2, String string4, Object object3, String string5, Object object4) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        Operations.setParameterValue(parameterValueGroup, string2, object);
        Operations.setParameterValue(parameterValueGroup, string3, object2);
        Operations.setParameterValue(parameterValueGroup, string4, object3);
        Operations.setParameterValue(parameterValueGroup, string5, object4);
        return this.processor.doOperation(parameterValueGroup);
    }

    protected final Coverage doOperation(String string, Coverage coverage, String string2, Object object, String string3, Object object2, String string4, Object object3, String string5, Object object4, String string6, Object object5) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        Operations.setParameterValue(parameterValueGroup, string2, object);
        Operations.setParameterValue(parameterValueGroup, string3, object2);
        Operations.setParameterValue(parameterValueGroup, string4, object3);
        Operations.setParameterValue(parameterValueGroup, string5, object4);
        Operations.setParameterValue(parameterValueGroup, string6, object5);
        return this.processor.doOperation(parameterValueGroup);
    }

    protected final Coverage doOperation(String string, Coverage coverage, String string2, Object object, String string3, Object object2, String string4, Object object3, String string5, Object object4, String string6, Object object5, String string7, Object object6) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(string);
        ParameterValueGroup parameterValueGroup = operation.getParameters();
        parameterValueGroup.parameter("Source").setValue((Object)coverage);
        Operations.setParameterValue(parameterValueGroup, string2, object);
        Operations.setParameterValue(parameterValueGroup, string3, object2);
        Operations.setParameterValue(parameterValueGroup, string4, object3);
        Operations.setParameterValue(parameterValueGroup, string5, object4);
        Operations.setParameterValue(parameterValueGroup, string6, object5);
        Operations.setParameterValue(parameterValueGroup, string7, object6);
        return this.processor.doOperation(parameterValueGroup);
    }

    private static void setParameterValue(ParameterValueGroup parameterValueGroup, String string, Object object) throws InvalidParameterNameException {
        if (object != null) {
            try {
                parameterValueGroup.parameter(string).setValue(object);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                throw new InvalidParameterNameException(Errors.format((int)224, (Object)string), (Throwable)parameterNotFoundException, string);
            }
        }
    }
}

